/*************************************************************************/
/* DUCTAPE Version 2.0                                                   */
/* Copyright (C) 2001                                                    */
/* Forschungszentrum Juelich, Zentralinstitut fuer Angewandte Mathematik */
/*************************************************************************/

#ifndef __PDB_FAT_ITEM_H__
#define __PDB_FAT_ITEM_H__

#include "pdbItem.h"

class pdbFatItem: public pdbItem {
public:
  pdbFatItem(int id);
  pdbFatItem(const string& name, int id);
  virtual ~pdbFatItem();
  
  virtual ostream& print(ostream& ostr) const;
  
  void headBegin(const pdbLoc& loc);
  void headEnd  (const pdbLoc& loc);
  void bodyBegin(const pdbLoc& loc);
  void bodyEnd  (const pdbLoc& loc);

  const pdbLoc& headBegin(void) const;
  const pdbLoc& headEnd  (void) const;
  const pdbLoc& bodyBegin(void) const;
  const pdbLoc& bodyEnd  (void) const;

  virtual void adjustPtrs(PDB*);

protected:
  pdbLoc pos[4];
};

#ifndef NO_INLINE
#  include "pdbFatItem.inl"
#endif
#endif
