/*************************************************************************/
/* DUCTAPE Version 2.0                                                   */
/* Copyright (C) 2001                                                    */
/* Forschungszentrum Juelich, Zentralinstitut fuer Angewandte Mathematik */
/*************************************************************************/

// class pdbCallee inlines
inline pdbCallee::pdbCallee ()
       : virt(pdbItem::VI_NO), rptr(0)  {}
inline pdbCallee::pdbCallee (const pdbRoutine *call, pdbItem::virt_t v,
             pdbFile *file, int line, int col)
       : pdbLoc(file, line, col), virt(v), rptr(call) {}
  
inline pdbItem::virt_t pdbCallee::virtuality() const { return virt; }
inline const pdbRoutine *pdbCallee::call() const { return rptr; }
inline bool pdbCallee::isVirtual() const { return virt == pdbItem::VI_VIRT; }

inline void pdbCallee::virtuality(pdbItem::virt_t v) { virt = v; }
inline void pdbCallee::call(const pdbRoutine* call) { rptr = call; }

// class pdbRoutine inlines
inline pdbRoutine::pdbRoutine(int id)
       : pdbTemplateItem(id),
         sig(0), knd(RO_NA), rspec(RS_NA), numc(0), link(LK_NA) {}
inline pdbRoutine::pdbRoutine(const string& name, int id)
       : pdbTemplateItem(name, id),
         sig(0), knd(RO_NA), rspec(RS_NA), numc(0), link(LK_NA) {}

inline const char *pdbRoutine::desc() const { return "routine"; }

inline const pdbType *pdbRoutine::signature() const { return sig; }
inline pdbItem::routine_t pdbRoutine::kind() const { return knd; }
inline pdbItem::rspec_t pdbRoutine::specialKind() const { return rspec; }
inline pdbRoutine::callvec& pdbRoutine::callees() { return calls; }
inline const pdbRoutine::callvec& pdbRoutine::callees() const { return calls; }
inline int pdbRoutine::numCalled() const { return numc; }
inline pdbItem::link_t pdbRoutine::linkage() const { return link; }
inline const pdbLoc& pdbRoutine::firstExecStmtLocation() const {
  return festmt;
}
inline const pdbRoutine::locvec& pdbRoutine::returnLocations() const {
  return retrns;
}

inline void pdbRoutine::signature(const pdbType *sigtype) { sig = sigtype; }
inline void pdbRoutine::kind(routine_t kind) { knd = kind; }
inline void pdbRoutine::specialKind(rspec_t rs) { rspec = rs; }
inline void pdbRoutine::addCallee(const pdbRoutine *callee, pdbItem::virt_t v,
                                  pdbFile *file, int line, int col) {
  calls.push_back(new pdbCallee(callee, v, file, line, col));
  callee->incrCalled();
}
inline void pdbRoutine::linkage(link_t l) { link = l; }
inline void pdbRoutine::firstExecStmtLocation(const pdbLoc& l) {
  festmt = l;
}
inline void pdbRoutine::addReturnLocation(pdbFile *file, int line, int col) {
  retrns.push_back(new pdbLoc(file, line, col));
}
