/*************************************************************************/
/* DUCTAPE Version 2.0                                                   */
/* Copyright (C) 2001                                                    */
/* Forschungszentrum Juelich, Zentralinstitut fuer Angewandte Mathematik */
/*************************************************************************/

#ifndef __PDB_ROUTINE_H__
#define __PDB_ROUTINE_H__

#include "pdbTemplateItem.h"

class pdbCallee : public pdbLoc {
public:
  pdbCallee ();
  pdbCallee (const pdbRoutine *call, pdbItem::virt_t v,
             pdbFile *file, int line, int col);
  
  pdbItem::virt_t virtuality() const;
  const pdbRoutine *call() const;
  bool isVirtual() const;

  void virtuality(pdbItem::virt_t v);
  void call(const pdbRoutine* call);

private:
  pdbItem::virt_t virt;
  const pdbRoutine *rptr;
};

ostream& operator<<(ostream& ostr, const pdbCallee& c);

class pdbRoutine : public pdbTemplateItem {
public:
  pdbRoutine(int id);
  pdbRoutine(const string& name, int id);
  virtual ~pdbRoutine();

  virtual ostream& print(ostream& ostr) const;
  virtual const char *desc() const;
  virtual void adjustPtrs(PDB* p);
  virtual dupl_t findDuplicate(pdbSimpleItem* r);

  typedef vector<pdbCallee *> callvec;
  typedef vector<pdbLoc *> locvec;

  const pdbType *signature() const;
  routine_t kind() const;
  rspec_t specialKind() const;
  callvec& callees();
  const callvec& callees() const;
  int numCalled() const;
  link_t linkage() const;
  const pdbLoc& firstExecStmtLocation() const;
  const locvec& returnLocations() const;

  void signature(const pdbType *sigtype);
  void kind(routine_t kind);
  void specialKind(rspec_t rs);
  void addCallee(const pdbRoutine *callee, pdbItem::virt_t v,
                 pdbFile *file, int line, int col);
  void linkage(link_t l);
  void firstExecStmtLocation(const pdbLoc& l);
  void addReturnLocation(pdbFile *file, int line, int col);

  virtual void process(PDB *p);

protected:
  void incrCalled() const;

  const pdbType     *sig;
  routine_t          knd;
  rspec_t            rspec;
  link_t             link;
  int                numc;
  callvec            calls;
  locvec             retrns;
  pdbLoc             festmt;
};

#ifndef NO_INLINE
#  include "pdbRoutine.inl"
#endif
#endif
