/*************************************************************************/
/* DUCTAPE Version 2.0                                                   */
/* Copyright (C) 2001                                                    */
/* Forschungszentrum Juelich, Zentralinstitut fuer Angewandte Mathematik */
/*************************************************************************/

#include "pdbItem.h"

#ifdef NO_INLINE
#  define inline
#  include "pdbFile.inl"
#endif

void pdbFile::process(PDB *p) {
  // if file wasn't included, add it to the toplevel files
  if ( numCalled() == 0 ) {
    p->fileTree()->addInclude(this);
  }
}

ostream& pdbFile::print(ostream& ostr) const {
  ostr << "so#" << id() << " " << name() << "\n";
  for (pdbFile::incvec::const_iterator it=incls.begin(); it!=incls.end(); ++it)
    ostr << "sinc so#" << (*it)->id() << "\n";
  return ostr << endl;
}

void pdbFile::adjustPtrs(PDB* p) {
  for (incvec::iterator it=incls.begin(); it!=incls.end(); ++it) {
    if ( (*it)->newId() > UNIQUE ) (*it) = p->getFileMap()[(*it)->newId()];
  }
}
