/*************************************************************************/
/* DUCTAPE Version 2.0                                                   */
/* Copyright (C) 2001                                                    */
/* Forschungszentrum Juelich, Zentralinstitut fuer Angewandte Mathematik */
/*************************************************************************/

#include "pdbType.h"
#include "pdbCRoutine.h"
#include "pdbFRoutine.h"
#include "pdbClass.h"

#ifdef NO_INLINE
#  define inline
#  include "pdbRoutine.inl"
#endif

ostream& operator<<(ostream& ostr, const pdbCallee& c) {
  ostr << "ro#" << c.call()->id() << " "
       << pdbItem::toName(c.virtuality()) << " ";
  return c.printLoc(ostr);
}

pdbRoutine::~pdbRoutine() {
  for (callvec::const_iterator ct=calls.begin(); ct!=calls.end(); ++ct)
    delete *ct;
  for (locvec::const_iterator ct=retrns.begin(); ct!=retrns.end(); ++ct)
    delete *ct;
}

void pdbRoutine::incrCalled() const {
  pdbRoutine *self = const_cast<pdbRoutine*>(this);
  self->numc++;
}

void pdbRoutine::process(PDB *p) {
  // if routine wasn't called, add it to the toplevel functions
  if ( numCalled() == 0 ) {
    p->callTree()->addCallee(this, pdbItem::VI_NO, 0, 0, 0);
  }

  pdbItem::process(p);
}

ostream& pdbRoutine::print(ostream& ostr) const {
  rspec_t k;
  link_t l;
 
  pdbItem::print(ostr);
  if ( signature() ) ostr << "rsig ty#" << signature()->id() << "\n";
  if ( (l = linkage()) != LK_NA )
    ostr << "rlink " << toName(l) << "\n";
  ostr << "rkind " << toName(kind()) << "\n";
  if ( (k = specialKind()) != RS_NA )
    ostr << "rskind " << toName(k) << "\n";
  pdbTemplateItem::print(ostr);
  const pdbRoutine::callvec c = callees();
  for (pdbRoutine::callvec::const_iterator ct=c.begin(); ct!=c.end(); ++ct)
    ostr << "rcall " << **ct << "\n";
  pdbFatItem::print(ostr);
  if ( firstExecStmtLocation().file() )
    ostr << "rstart " << firstExecStmtLocation() << "\n";
  const pdbRoutine::locvec lr = returnLocations();
  for (pdbRoutine::locvec::const_iterator lt=lr.begin(); lt!=lr.end(); ++lt)
    ostr << "rret " << **lt << "\n";
 
  return ostr;
}

void pdbRoutine::adjustPtrs(PDB* p) {
  const pdbRoutine* r;
  const pdbFile* fi;

  pdbTemplateItem::adjustPtrs(p);
  if ( sig->newId() > UNIQUE ) sig = p->getTypeMap()[sig->newId()];
  for( callvec::iterator it = calls.begin(); it!=calls.end(); ++it) {
    r = (*it)->call();
    if ( r->newId() > UNIQUE )
      if ( p->language() & PDB::LA_C_or_CXX ) {
        (*it)->call(p->getCRoutineMap()[r->newId()]);
      } else if ( p->language() & PDB::LA_FORTRAN ) {
        (*it)->call(p->getFRoutineMap()[r->newId()]);
      }
    if ( (fi=(*it)->file()) && (fi->newId() > UNIQUE) )
      (*it)->file(p->getFileMap()[fi->newId()]);
  }
  if ( (fi=firstExecStmtLocation().file()) && (fi->newId() > UNIQUE) )
    festmt.file(p->getFileMap()[fi->newId()]);
  for( locvec::iterator it = retrns.begin(); it!=retrns.end(); ++it) {
    if ( (fi=(*it)->file()) && (fi->newId() > UNIQUE) )
      (*it)->file(p->getFileMap()[fi->newId()]);
  }
}

pdbSimpleItem::dupl_t pdbRoutine::findDuplicate(pdbSimpleItem* r) {
  pdbRoutine* rhs = dynamic_cast<pdbRoutine*> (r);
  if ( fullName() == rhs->fullName() ) {
    if ( kind() == RO_EXT && rhs->kind() != RO_EXT )
      return OLDDUPL;
    else
      return NEWDUPL;
  } else {
      return NODUPL;
  }
}
