/*************************************************************************/
/* DUCTAPE Version 2.0                                                   */
/* Copyright (C) 2001                                                    */
/* Forschungszentrum Juelich, Zentralinstitut fuer Angewandte Mathematik */
/*************************************************************************/

#ifndef __PDB_FILE_H__
#define __PDB_FILE_H__

#include "pdbSimpleItem.h"

class pdbComment {
public:
  pdbComment(int id);

  int id() const;
  PDB::lang_t kind() const;
  const pdbLoc& cmtBegin() const;
  const pdbLoc& cmtEnd() const;
  const string& text() const;

  void kind(PDB::lang_t kind);
  void cmtBegin(const pdbLoc& loc);
  void cmtEnd(const pdbLoc& loc);
  void text(const string& text);

  friend class pdbFile;

private:
  int         i;
  PDB::lang_t knd;
  pdbLoc      bg;
  pdbLoc      ed;
  string      txt;
};

ostream& operator<<(ostream& ostr, const pdbComment& c);

class pdbFile : public pdbSimpleItem {
public:
  pdbFile(int id);
  pdbFile(const string& name, int id);
  virtual ~pdbFile();

  typedef vector<pdbFile *> incvec;
  typedef vector<pdbComment *> cmtvec;

  virtual const char *desc() const;
  virtual ostream& print(ostream& ostr) const;
  virtual void adjustPtrs(PDB* p);
  virtual void process(PDB* p);

  incvec& includes();
  const incvec& includes() const;
  int numCalled() const;
  bool isSystemFile() const;
  const cmtvec& comments() const;

  void addInclude(pdbFile *inc);
  void isSystemFile(bool s);
  pdbComment* addComment(int id);

private:
  incvec incls;
  cmtvec cmts;
  int    ncall;
  bool   sys;
};

#ifndef NO_INLINE
#  include "pdbFile.inl"
#endif
#endif
