/* 
 *  gr.h: Formatting for "grind"-ing program listings.  This
 *      is intended to be a layer between the (language-specific, 
 *      formatter-independent) pattern recognition layer and the 
 *      (language-independent, formatter-specific) document driver
 *      layer of a listing-grinding application.  grmif is specfic
 *      to the task of grinding program listings, but the interface 
 *      should be independent of whether the listing is produced in 
 *      tex, frame, etc.   There should be alternative modules grtex,
 *      grhtml, etc. for other document formatting systems, with 
 *      identical interfaces.
 */


void init_gr();
void end_gr(); 

void gr_error(char *context, char *badstring); 
void gr_trace(char *whatpattern); 

void keyword(char *s);     
void identifier(char *s);
void declaration(char *s); /* special case of identifier */
void blanks(char *s);
void comment(char *s); 
void quoted(char *s); 
void newline(); 
void echo_char(char ch); 

/* The above classes are really just special cases 
 *  of string or string_in_style
 */


/* UNIT IDENTIFICATION */
/* 
 *  "Title" is generally for a whole document.
 *  Use "sourcefile" and/or "unitname" for individual files
 *    in a composite document (e.g., source files in a FrameMaker book)
 *
 *  Probably there should be a general "TaggedString" procedure, but
 *  I'm not yet certain that a tagged paragraph is always the right way
 *  to place these in a document. 
 */

void title(char *s);     /* A string with tag "Title"            */

void heading(char *tag, char *content); /* A string with any tag */


/* 
 * Leave cross-reference markers for declarations - 
 *    Argument is the string to be put in the index
 * 
 * Note: The open/close pairs are needed for some back 
 *    ends like html, in which an anchor *must* contain
 *    text. (This is a flaw in the html design, but rules
 *    are rules and we have to live with it.) For back ends
 *    in which anchors are points, rather than stretches of
 *    text, close_mark_declaration can be a no-op.
 *
 *  Note on usage: Do not nest declaration tags.  The html
 *    spec is doubly broken, in that tags must contain text
 *    but they cannot be nested.  Go figure.
 *
 */

/* DEPRECATED */
void mark_declaration(char *index_string); 

/* REPLACES mark_declaration */
void begin_mark_declaration(char *index_string); 
void end_mark_declaration(); 
     
/* 
 * Tagged conditional text 
 */

void begin_block_comment();

void end_block_comment(); 

/*  Figures (diagrams) - references to a file containing the graphic.
 *
 */  
void gr_figure(char *kind, char *filename); 

/* Symbols - those that are printed as themselves, and 
 *  those that aren't.  The argument is a keyboard entry string,
 *  which is used if the special symbol does not exist in the 
 *  chosen rendering (e.g., lack of a not-equals symbol in 
 *  html version 2). 
 */

void echo_symbol(char ch); 

void s_neq(char *s);
void s_leq(char *s);
void s_geq(char *s);
void s_Rtarrow(char *s);
void s_not(char *s);
void s_bullet(char *s);












