#include <stdio.h>
#include "groptions.h"

struct options optblock;

void getoptions(int argc, char *argv[]) {

  int i, slot, lnum_frequency; 
  optblock.debug = false;
  optblock.headings_count = 0; 
  optblock.line_nums = 0;      
  optblock.glyph_mapping = true;    // Substitute glyphs for symbols like != 
  optblock.image_conversion = true; // Expect images to be converted

  for (i=1; i<argc; i++) {
    if (strlen(argv[i]) == 0) {
      fprintf(stderr, 
	      "%s: Null string as option?  Ignored.\n",
	      argv[0]); 
    } 
    else if ((argv[i][0] != '-') && (argv[i][0] != '+')) {
      fprintf(stderr, "%s: %s is not a recognized option\n",
	      argv[0], argv[i]);
      fprintf(stderr, "All options begin with '-' or '+',"
	              " input filename may be indicated as <file\n"); 
      exit(1); 
    }


    else if (strcasecmp(argv[i],"+debug") == 0 ) {
      fprintf(stderr, "%s: Debugging mode on\n", argv[0]); 
      optblock.debug = true; 
    }
    else if (strcasecmp(argv[i], "-debug") == 0) {
      fprintf(stderr, "%s: -debug is default, give +debug to turn on\n",
	      argv[0]); 
    }


    else if (strcasecmp(argv[i],"+ximg") == 0 ) {
      fprintf(stderr, "%s: Image conversion mode on\n", argv[0]); 
      optblock.image_conversion = true; 
    }
    else if (strcasecmp(argv[i], "-ximg") == 0) {
      fprintf(stderr, "%s: Image conversion mode off\n",
	      argv[0]); 
      optblock.image_conversion = false; 
    }


    else if (strcasecmp(argv[i],"+lines") == 0 ) {
	i++;
	if (i >= argc) {
		fprintf(stderr,
			"%s: +Lines option not followed by "
			 "integer \n",
			argv[0]); 
		        exit(1); 
	}
	sscanf(argv[i], "%d", &lnum_frequency); 
	if (lnum_frequency <= 0) {
	    fprintf(stderr, "%s: Line numbering option ignored; "
		    "should be a positive integer >= 1\n", argv[0]);
	} else {
	    optblock.line_nums = lnum_frequency;
	}
    }
    else if (strcasecmp(argv[i], "+Heading") == 0) {
	if (optblock.headings_count >= 9) {
	    fprintf(stderr, "%s: Too many headings\n", argv[0]); 
	    exit(1); 
	}
	slot = optblock.headings_count++; 
	i++;
	if ((i+1) >= argc) {
		fprintf(stderr,
			"%s: +Heading  option not followed by "
			 "label and text\n",
			argv[0]); 
		        exit(1); 
	}
	strcpy(optblock.headings[slot].tag, argv[i]); 
	i++;
	strcpy(optblock.headings[slot].content,argv[i]); 
    }
    else if (strcasecmp(argv[i],"+glyphs") == 0 ) 
      {
	fprintf(stderr, 
		"%s: Glyphs (special characters) substitions on (default)\n",
		argv[0]); 
	optblock.glyph_mapping = true; 
      }
    else if (strcasecmp(argv[i],"-glyphs") == 0 ) 
      {
	fprintf(stderr, 
		"%s: Glyphs (special characters) substitions off\n",
		argv[0]); 
	optblock.glyph_mapping = false; 
      }
    else {
      fprintf(stderr, "%s: Unrecognized option %s\n", argv[0], argv[i]); 
      fprintf(stderr, 
	      "Usage: %s [+debug] "
	      "[+Heading ] tag content] ... "
	      "inputfile >outputfile\n", 
	      argv[0]);
    };
  }
return;
}
