%{ 
/* 
 *  awk2gr.l
 *     Front end for formatting awk programs. 
 * 
 */
#define yywrap() 1

char Marker_Suffix_Buf[100] = " (oops)";
char Marker_Buf[200] = "!!!"; 

int Figure_Context = 0;  /* Save/restore state around figure */
char Image_Name[100] = "!undefined figure";
char Image_MIME_Type[100] = ""; /* Null means not specified */
char Default_MIME_Type[] = "unknown"; 

%}

Blank   [ ]
W       [ \t\n]+
Quote   ["]
Ident   [a-zA-Z][a-zA-Z0-9_\.]*	
FileName [^ \n\t]+
MIME_Type [_a-zA-Z]([-/a-zA-Z0-9_])*	
URL	[^ \t\n>]+
%x BlockComment 
%x Figure Link RawContent
%x URL MIME_Type
%s Decl

%%

(function) {
	 keyword(yytext); 
	 strcpy(Marker_Suffix_Buf, yytext); 
	 BEGIN(Decl); 
 }

<Decl>{Ident} {
	sprintf(Marker_Buf,"%s (%s)", yytext, Marker_Suffix_Buf); 
	begin_mark_declaration(Marker_Buf); 
	declaration(yytext); 
	end_mark_declaration(); 
	BEGIN(INITIAL); 
}

  /* Operation symbols in awk (some of these could be transliterated) */
"++"|"+"|"--"|"-"|"\$"|"^"|"!"|"*"|"/"|"%" |
"<"|"<="|"!="|"=="|">"|">="|"~"|"!~" |
"&&"|"||"|"?"|":" |
"^="|"%="|"*="|"/="|"+="|"-="|"=" {  keyword(yytext); }

  /* Special variables */
ARGC|ARGV|CONVFMT|ENVIRON|FILENAME|FNR|FS|NF|NR |
OFMT|OFS|ORS|LENGTH|RSTART|SUBSEP  { keyword(yytext); }

  /* Program Structure ("actions" that form statements) */
if|else|while|do|for|delete|break|continue |
"{"|"}" |
print|printf|next|exit|return  { keyword(yytext); }

BEGIN|END { keyword(yytext); }

  /* Output (re-)direction, valid only in print statements */
">"|">>"|"|" { keyword(yytext); }

  /* built-in arithmetic functions */
atan2|cos|sin|exp|log|sqrt|int|rand|srand { keyword(yytext); }

  /* built-in string functions */
gsub|index|length|match|split|sprintf|sub|substr |
tolower|toupper  { keyword(yytext); }

  /* Input/output and general functions */
close|getline|system  { keyword(yytext); }

  /* Extended regular expressions */
  /*  (This pattern isn't perfect, 
   *but it should only rarely match too much) 
   */

"/"([^/]|("\\/")|("["[^\]]*"]"))*"/"    { quoted(yytext); }

   /* Quoted strings, identifiers, strings of blanks */

{Ident}  { identifier(yytext); }

 /* Pseudo-comments:  Embedded images, links, escape to formatting system.
  * We use a restricted version of the  HTML style for recognition, 
  * with the idea of converting as possible to other output formats
  * (except RawContent comes out the back end with no conversion ---
  *  therefore the existence of RawContent in a source file ties you
  *  to a single output format.) 
  * 
  * Current experimental version:  Only the html back-end exists, so
  * further variations and restrictions are likely in future versions
  * (especially as regards identifying file type, which the URL format
  *  does only implicitly through file name conventions.)
  * 
  * --<IMG SRC=filename TYPE=mime-type >
  */

<INITIAL,BlockComment>"#"[ ]*"<IMG"{W} {
	 	strcpy(Image_MIME_Type, Default_MIME_Type); 
		strcpy(Image_Name, "!NO_IMAGE_SPECIFIED"); 
		Figure_Context = YY_START; 
		BEGIN Figure; 
	     }

<Figure>SRC=  { BEGIN URL; }

<URL>\"{URL}\"	{
	strcpy(Image_Name, yytext+1);
	Image_Name[yyleng-2] = 0;
	BEGIN Figure;
	}

<URL>{URL} {
	strcpy(Image_Name, yytext);
	BEGIN Figure;
	}

<URL>{W}	{ ; }
<URL>.		{ gr_error("Unrecognized characters in URL context");
		  BEGIN Figure;
		}
	
<Figure>= { BEGIN MIME_Type; }
<MIME_Type>\"{MIME_Type}\"	{
	strcpy(Image_MIME_Type, yytext+1);
	Image_MIME_Type[yyleng-2] = 0;
	BEGIN Figure;
	}

<MIME_Type>{MIME_Type} {
	strcpy(Image_MIME_Type, yytext); 
	BEGIN Figure;
	}

<MIME_Type>{W}	{ ; }
<MIME_Type>.		{ gr_error("Unrecognized characters"
				   " in MIME Type context");
			  BEGIN Figure;
			}

<Figure>">"{W}?$ |
<Figure>">"	{  gr_figure(Image_MIME_Type, Image_Name); 
		   BEGIN(Figure_Context);
		}

 /*
  * Block comments and single line-ending comments
  */

^[ \t]*#([^<\n].*)?$	{ 
  begin_block_comment(); 
  comment(yytext); 
  BEGIN BlockComment;
}

<BlockComment>"\n"   {
   newline();
}

<BlockComment>^[ \t]*#[^<].*$  { comment(yytext); }
<BlockComment>^[ \t]*#$ 	{ comment(yytext); }



<BlockComment>. {
  end_block_comment(); 
  BEGIN INITIAL;
  unput(yytext[0]);
}



 /* No condition tag for line-ending comment after other text */
#[^<\n].*$			{ comment(yytext); } 
#$				{ comment(yytext); }


{Quote}((\\.)|([^"\\\n]))*{Quote}	{ quoted(yytext); }
['](("\\"[a-zA-Z])|("\\"[0-9][0-9]0-9])|("\\".))['] { quoted(yytext); }
['][^\\]['] { quoted(yytext); }

{Blank}{Blank}*			{ blanks(yytext); }

   /* New line is not echoed - it starts a new paragraph */

"\n"				{  newline(); }


   /* Echo everything else.  If a character needs to be escaped, 
    * it will be.  The driver will build up multi-character strings
    * when it can. 
    */
.				{ echo_char(yytext[0]); }
%%

/* The driver (main procedure) 
 * has been moved to flexdriver.c 
 */




