%{ 
/* 
 *  csh2gr.l:
 *    Translate CSH to MIF or another formatter for inclusion in documents
 *    Similar in function to tgrind, but so far without a vgrindefs-like
 *        pattern definition language.  Current emphasis is to 
 *        find the right layers to support multiple languages and 
 *         multiple document formatting systems.  In addition to 
 *        framemaker, we should be aiming for LaTeX, html, and Chimera.
 *    Author: Michal Young, July 1994
 * $Id: csh2gr.l,v 1.5 1995/06/22 22:48:01 young Exp $ 
 * 
 *  NOTE: this file should be processed without the -i option
 *        to create a case-sensitive scanner, since 
 *	  csh is a case-sensitive language. 
 * 
 */

char Marker_Suffix_Buf[100] = " (oops)";
char Marker_Buf[200] = "!!!"; 

#define yywrap() 1

%}

Blank   [ ]
Quote   ["]
SQuote  [']
GQuote  [`]
Ident   [_a-zA-Z][a-zA-Z0-9_]*	
W       [ \t\n]+
OptW    [ \t\n]*
H	(#)

%x BlockComment
%s Decl

%%


 /* Keywords: 
  *   Include phrases like "or else" to override the symbol definition
  *   of "or" 
  */ 


alias|alloc|break|breaksw|case|cd|chdir|continue|default |
echo|else|end|endif|endsw|exec|exit|foreach |
glob|goto|history|if|logout|nice|nohup|onintr|repeat|set |
setenv|shift|source|switch|then|time |
while|umask|unalias|unset|wait|while|"@"|env |
argv|child|home|ignoreeof|noclobber|noglob |
nomatch|path|prompt|shell|status|verbose {
						  keyword(yytext); }

";"|"("|")" { keyword(yytext); }

{Ident}	    { identifier(yytext); } 
[$]{Ident}  { identifier(yytext); /* Need another category */ } 
[$][#]argv  { identifier(yytext); }
"${"{Ident}"}"  { identifier(yytext); }

 /*
  * Block comments and single line-ending comments
  */

^[ \t]*{H}.*$	{ 
  begin_block_comment(); 
  comment(yytext); 
  BEGIN BlockComment;
}

<BlockComment>"\n"   {
   newline();
}

<BlockComment>^[ \t]*{H}.*$	{ 
  comment(yytext); 
}

<BlockComment>. {
  end_block_comment(); 
  BEGIN INITIAL;
  unput(yytext[0]);
}

 /* No condition tag for line-ending comment after other text */
{H}.*$			{ comment(yytext); } 



{Quote}((["]["])|([^"]))*{Quote}	{ quoted(yytext); }
{SQuote}(([']['])|([^']))*{SQuote}	{ quoted(yytext); }
{GQuote}(([`][`])|([^`]))*{GQuote}	{ quoted(yytext); }

{Blank}{Blank}*			{ blanks(yytext); }

   /* New line is not echoed - it starts a new paragraph */

"\n"				{  newline(); }


   /* Echo everything else.  If a character needs to be escaped, 
    * it will be.  The driver will build up multi-character strings
    * when it can. 
    */
.				{ echo_char(yytext[0]); }

%%












