/* $Revision: 1.5 $ */
/* RECENT CHANGE --- IMPORTANT: 
 * This was a function that was passed an option block to fill.
 * That meant the option block lived somewhere else ... but where?
 * Options may be useful to various parts of the pipeline, so it 
 * it might as well live here. 
 */


typedef int boolean; /* 0=false, 1=true */
#define true 1
#define false 0

struct options {
    boolean  debug;         /* true should trigger debugging output */
    int headings_count;     /* up to 10 tag,content pairs */
    struct heading_struct {
	char tag[100]; 
	char content[200];
    } headings[10];
    int line_nums;          /* 0      : don't print line numbers, 
			       k >= 0 : print line k, 2k, 3k, ... 
			     */
    boolean glyph_mapping;        /* 0: Don't map glyphs, 1: do
			       later we will add customizable
			       glyph mapping tables. 
			       */
    boolean image_conversion;    /* if true, attempt to convert
				  *    images to a type acceptable
				  *    in a particular kind of document,
				  *    e.g., from postscript to gif for
				  *    html documents.  Conversion is 
				  *    handled by the document driver
				  *    (e.g., htmldrvr.c)  
				  *    and/or external scripts
				  */
};

extern struct options optblock; 

void getoptions(int argc, char *argv[]); 




