#
#  htmlmarkers.awk: 
#   Extract a list of markers from an html file
#   We assume
#       - Each line has at most one anchor (subsequent markers are ignored)
#       - Slightly non-standard use of TITLE in anchor, to indicate the 
#         title that a link should appear with.  This permits non-unique 
#         strings to be indexed, using unique serial #'s as the real key.
#   Print them as 
#     ANCHOR  anchorname label file 
#   where anchorname is a serial# unique within a file
#
#   File name (for cross-file linking) may be given as "-v File=foo.html"
#     on the command line; otherwise it is inferred from the source file
#     name (beware problems with getting the directory right if the web
#     directory is not where this script is executed.)
#
BEGIN {
             if (File == "") File = FILENAME;
	     serial = 0
	   }

/<A NAME/ { ## We'll assume there is just one per line, for now
	      # print "Line: " $0
	      i=index($0,"<A NAME");
              # print "Index: " i
	      part=substr($0, i, length($0));
	      # print "Part: " part
	      split(part, parts, "\"");
	      anchor=parts[2];
	      i=index(part,"TITLE=");
	      if (i > 0) { 
		part=substr(part,i,length(part));
		split(part, parts, "\"");
		label = parts[2];
	      } else {
		label = anchor;
	      }
	      printf("ANCHOR:\t%s\t%s\t%s\n", anchor, label, File)
	      # print
	    }


