/*
 *  html_styles.{h,c}
 *     Mapping from symbolic style names (e.g., keyword) to 
 *     beginning/ending tags in html. It would be better to read this
 *     at run-time, rather than compiling it in, but it would be better
 *     yet to use style-sheets.  And since style sheets are (still) just
 *     around the corner, we'll take the easy way out for now. 
 *
 * 
 */
#include "html_styles.h"
#include <string.h>


struct style_tag { char *style_name; char *begin_tag; char *end_tag; };

static struct style_tag styles[] = 
 {
   { "Keyword", "<B>", "</B>" },
   { "Identifier", "", "" },
   { "Declaration", 
     "<FONT SIZE=+1 COLOR=\"Red\" FACE=\"Arial,Helvetica\">", 
     "</FONT>"},
   { "Comment",   "<FONT COLOR=\"Navy\"><EM>", "</EM></FONT>"},
   { "Quoted",    "<FONT COLOR=\"Green\"><SAMP>", "</SAMP></FONT>"},
   { 0, 0, 0 } /* Marks end of table */
 }; 

char static * table_sentry = 0;           /* style entry of table sentry */
char static * empty_string = "";   /* what to use if no style */

/* 
 *  styles init:  Currently a do-nothing function, but in future this
 *  might load a user-supplied table of desired style mappings at 
 *  run-time.
 */

extern void init_html_styles() { return; }
/* 
 * style map:
 *  Look up symbolic style name.  This is not implemented efficiently,
 *  so it is best to call it once for each desired style name and store
 *  styles in local variables. 
 *  
 *  Two  values are passed by reference, the beginning and 
 *  ending tags sequence for the given symbolic style. These should
 *  be references to character pointers.
 *   If everything is ok, return value is
 *  1.  If style is not found, return value is 0, and 
 */
extern int  html_style_map ( char *style_name, 
			     char * *begin_tag, char * *end_tag )
{
  int i =0;
  while (styles[i].style_name != table_sentry) 
    {
      if (strcasecmp(style_name, styles[i].style_name)==0) 
	{
	  * begin_tag = styles[i].begin_tag;  /* Reference! */
	  * end_tag = styles[i].end_tag;      /* Reference! */
	  return 1; 
	}
      ++i;
    }
  * begin_tag = empty_string;
  * end_tag = empty_string;
  return 0;
}

