#
#  html_clean.awk
#    Remove cruft from html files.
#    Especially, remove TITLE attribute from anchors.  It's legal,
#      but LYNX chokes on it. 
#
#  See also html_markers.awk.  Do NOT use this filter until after 
#  html_markers.awk has had its chance to extract information from the 
#  anchors, including information from the TITLE attribute.
#
# 
BEGIN {
  ## Nothing to do? 
}
/<A NAME/  { ## We'll assume there is just one per line, for now
    ## print "*** Looking  ***"
    count = sub(/TITLE *= *\"[^\"]*\"/, "", $0);
    ## if (count) print "***Got one***";
}

  { 
   gsub(/<\/EM><EM>/, "", $0);
   gsub(/<\/B><B>/, "", $0); 
   print 
   }


END {
  ## Nothing to do? 
}

