#
#  html_guide_index.awk
#    Build guide letters for an html index from a list of markers
#    NOTE: This script is tightly coupled with html_global_index.awk; 
#          If you edit one, you will almost certainly need to edit the other
#
# Input format (fields separated by tabs) 
# ANCHOR: M_001   Purify_String (returns char *  )        htmldrvr.html
#
# Input must be sorted
# 
#  Output: A set of guide letters for a menu of links
#

BEGIN {
  CurIndexChar = "";  ## Control breaks for "Guide characters"
  CurIndex = 0;
}

/^ANCHOR:/ {
  split($0,fields,"\t");
  anchor=fields[2];
  label=fields[3];
  file=fields[4]
  NewIndexChar = upcase(substr(label,1,1)); 
  if (NewIndexChar != CurIndexChar) { ## New guide character
     CurIndexChar = NewIndexChar;
     printf("<A HREF=\"#Guide%s\">%s</A>\n", NewIndexChar, NewIndexChar); 
   }
}


## The function "toupper" exists in gawk but not nawk, so we'll
## hack our way (very clumsily and inefficiently) around its absence.
## s must be a single-character string.
##
function upcase(s,     i) {
  i=index("abcdefghijklmnopqrstuvwxyz", s);
  if (i) {

     return substr("ABCDEFGHIJKLMNOPQRSTUVWXYZ",i,1);
   } else {
     return s;
   }
}

