##
## glyphcodes.awk:  
##    Process a list of names of glyphs (symbols) and produce a table 
##    that can be used for communicating the glyph names from each front end
##    to each back end.  Not all front ends will produce all glyphs, and 
##    not all back ends will interpret all glyphs; the fallback is always 
##    to reproduce the input sequence on the output.
##
BEGIN {
  glyph_count = 0; 
  print "/* DO NOT EDIT THIS FILE */";
  print "/* It was generated automatically by glyphcodes.awk */";
  print "/* Edit the glyph list (e.g. glyphcodes.src) and any */"
  print "/* language-specific mapping table (e.g. glyphs_tex.src) */"
  print "/* and then regenerate this file using make. */"
  print "/* Generated on ";
  system("date");
  print "*/"
    }

/^BEGIN LIST/ { next; } ## This is for other scripts ...
/^END LIST/ { next; } ##

/^[a-zA-Z]/ {
  glyph_name = "GLYPH_" $1 ; 
  ++glyph_count; 
  print "#define", glyph_name, glyph_count
    }




