#
#  html_global_index.awk
#    Build an html index from a list of markers for several files
#    NOTE: This script is tightly coupled with html_guide_index.awk; 
#          If you edit one, you will almost certainly need to edit the other
#
# Input format (fields separated by tabs) 
# ANCHOR: M_001   Purify_String (returns char *  )        htmldrvr.html
#
# Input must be sorted
# 
#  Output: A sequence of menus of links, grouped by first letter, and idexed
#          by a list of guide letters at the beginning of the file. 
#

BEGIN {
  CurIndexChar = "";  ## Control breaks for "Guide characters"
  CurIndex = 0;
  CloseMenu = ""; ## What must be printed at control break
}

/^ANCHOR:/ {
  split($0,fields,"\t");
  anchor=fields[2];
  label=fields[3];
  file=fields[4]
  NewIndexChar = upcase(substr(label,1,1)); 
  if (NewIndexChar != CurIndexChar) { ## New guide character
     print CloseMenu; ## Will be empty first time
     CurIndexChar = NewIndexChar;
     printf("<A NAME=\"Guide%s\">", CurIndexChar); 
     printf("<H3>%s</H3></A>\n<MENU>\n", CurIndexChar); 
     CloseMenu = "</MENU>"
   }
  fname = file; sub(/[.][hH][tT][mM][lL]?$/, "", fname); 
  if (anchor=="-") 
    {
      ## This means a reference to a whole file; see script src2www
      ## where this is done for awk scripts.
      printf("<LI><A HREF=\"%s\">%s</A>   (script file)\n", 
	 file, label); 
    }
  else
    {
      ## Other anchors are given suffixed to file name
      printf("<LI><A HREF=\"%s#%s\">%s</A> in %s\n", 
	 file, anchor, label, fname);
    }
}

END {
  print CloseMenu
}

## The function "toupper" exists in gawk but not nawk, so we'll
## hack our way (very clumsily and inefficiently) around its absence.
## s must be a single-character string.
##
function upcase(s,     i) {
  i=index("abcdefghijklmnopqrstuvwxyz", s);
  if (i) {

     return substr("ABCDEFGHIJKLMNOPQRSTUVWXYZ",i,1);
   } else {
     return s;
   }
}


