%{ 
/* 
 *  ada95gr.l
 *    Pretty-print Ada source code -- In FrameMaker, html, ...
 *    Similar in function to tgrind, but so far without a vgrindefs-like
 *        pattern definition language.  Current emphasis is to 
 *        find the right layers to support multiple languages and 
 *         multiple document formatting systems.  In addition to 
 *        framemaker, we should be aiming for LaTeX, html, and Chimera.
 *    Author: Michal Young, July 1994
 * $Id: ada95gr.l,v 1.30 1997/02/01 22:53:29 young Exp $ 
 * 
 *  NOTE: this file should be processed with flex -i 
 *        to create a case-insensitive scanner. For a 
 *        version that will work correctly with the standard
 *        unix lex, without automatic case folding, 
 *        each Ada keyword must be given in the 
 *        [fF][oO][rR] style. 
 */
#define yywrap() 1
#include "glyphcodes.h"

char Marker_Suffix_Buf[100] = " (oops)";
char Marker_Buf[200] = "!!!"; 

int Figure_Context = 0;  /* Save/restore state around figure */
char Image_Name[100] = "!undefined figure";
char Image_MIME_Type[100] = ""; /* Null means not specified */
char Default_MIME_Type[] = "unknown"; 

%}

Blank   [ ]
W       [ \t\n]+
Quote   ["]
Ident   [a-zA-Z][a-zA-Z0-9_\.]*	
FileName [^ \n\t]+
MIME_Type [_a-zA-Z]([-/a-zA-Z0-9_])*	
URL	[^ \t\n>]+
%x BlockComment 
%x Figure Link RawContent
%x URL MIME_Type
%s Decl

%%

(procedure|function|type|subtype|package|task|entry|accept) {
	 keyword(yytext); 
	 strcpy(Marker_Suffix_Buf, yytext); 
	 BEGIN(Decl); 
 }

(package[ \t\n]*body) {
	 keyword(yytext); 
	 strcpy(Marker_Suffix_Buf, "package body"); 
	 BEGIN(Decl); 
 }

(task[ \t\n]*body) {
	 keyword(yytext); 
	 strcpy(Marker_Suffix_Buf, "task body"); 
	 BEGIN(Decl); 
 }

<Decl>{Ident} {
	sprintf(Marker_Buf,"%s (%s)", yytext, Marker_Suffix_Buf); 
	begin_mark_declaration(Marker_Buf); 
	declaration(yytext); 
	end_mark_declaration(); 
	BEGIN(INITIAL); 
}
<Decl>{Quote}[^"]*{Quote} {
	sprintf(Marker_Buf,"%s (overloaded operator)", yytext); 
	begin_mark_declaration(Marker_Buf); 
	declaration(yytext); 
	end_mark_declaration(); 
	BEGIN(INITIAL); 
}

	

  /* Symbols before keywords, so that if a keyword is defined both
   * places, the symbol definition takes precedence. 
   */

":"|"="|"<"|">"|"\\" |
"/"|"+"|"-"|"*"  { 
	echo_symbol(0, yytext); 
  }

"/="                            { echo_symbol(GLYPH_not_equal, yytext); }
"<="                            { echo_symbol(GLYPH_less_equal, yytext); }
">="                            { echo_symbol(GLYPH_greater_equal, yytext); }
"=>"                            { echo_symbol(GLYPH_rightarrow_dbl, yytext); }
"not"                           { echo_symbol(GLYPH_logic_not, yytext); }
"<>"                            { echo_symbol(GLYPH_bullet, yytext); }

 /* Note: "or" and "and" are not given symbol declarations because they
  *        appear in combinations like "or terminate" in which the 
  *        textual version is more natural.  
  */

 /* Keywords from Ada 83: 
  *   Include phrases like "or else" to override the symbol definition
  *   of "or" 
  */ 

abort|abs|accept|access|all|and|array|at|begin|body|case |
constant|declare|delay|delta|digits|do|else|elsif|end|entry |
exception|exit|for|function|generic|goto|if|in|is|limited |
loop|mod|new|not|null|of|or|others|out|package|pragma|private |
procedure|raise|range|record|rem|renames|return|reverse|select |
separate|subtype|task|terminate|then|type|use|when|while|with|xor |
"or else"|"and then"  { 
   			keyword(yytext); }

  /* Keywords added in Ada 95: 
   */
abstract|aliased|protected|requeue|tagged { keyword(yytext); }

   /* Quoted strings, identifiers, strings of blanks */

{Ident}  { identifier(yytext); }

 /* Pseudo-comments:  Embedded images, links, escape to formatting system.
  * We use a restricted version of the  HTML style for recognition, 
  * with the idea of converting as possible to other output formats
  * (except RawContent comes out the back end with no conversion ---
  *  therefore the existence of RawContent in a source file ties you
  *  to a single output format.) 
  * 
  * Current experimental version:  Only the html back-end exists, so
  * further variations and restrictions are likely in future versions
  * (especially as regards identifying file type, which the URL format
  *  does only implicitly through file name conventions.)
  * 
  * --<IMG SRC=filename TYPE=mime-type >
  */

<INITIAL,BlockComment>"--"[ ]*"<IMG"{W} {
	 	strcpy(Image_MIME_Type, Default_MIME_Type); 
		strcpy(Image_Name, "!NO_IMAGE_SPECIFIED"); 
		Figure_Context = YY_START; 
		BEGIN Figure; 
	     }

<Figure>SRC=  { BEGIN URL; }

<URL>\"{URL}\"	{
	strcpy(Image_Name, yytext+1);
	Image_Name[yyleng-2] = 0;
	BEGIN Figure;
	}

<URL>{URL} {
	strcpy(Image_Name, yytext);
	BEGIN Figure;
	}

<URL>{W}	{ ; }
<URL>.		{ gr_error("Unrecognized characters in URL context");
		  BEGIN Figure;
		}
	
<Figure>= { BEGIN MIME_Type; }
<MIME_Type>\"{MIME_Type}\"	{
	strcpy(Image_MIME_Type, yytext+1);
	Image_MIME_Type[yyleng-2] = 0;
	BEGIN Figure;
	}

<MIME_Type>{MIME_Type} {
	strcpy(Image_MIME_Type, yytext); 
	BEGIN Figure;
	}

<MIME_Type>{W}	{ ; }
<MIME_Type>.		{ gr_error("Unrecognized characters"
				   " in MIME Type context");
			  BEGIN Figure;
			}

<Figure>">"{W}?$ |
<Figure>">"	{  gr_figure(Image_MIME_Type, Image_Name); 
		   BEGIN(Figure_Context);
		}

 /*
  * Block comments and single line-ending comments
  */

^[ \t]*--([^<\n].*)?$	{ 
  begin_block_comment(); 
  comment(yytext); 
  BEGIN BlockComment;
}

<BlockComment>"\n"   {
   newline();
}

<BlockComment>^[ \t]*--[^<].*$  { comment(yytext); }
<BlockComment>^[ \t]*--$ 	{ comment(yytext); }



<BlockComment>. {
  end_block_comment(); 
  BEGIN INITIAL;
  unput(yytext[0]);
}



 /* No condition tag for line-ending comment after other text */
--[^<\n].*$			{ comment(yytext); } 
--$				{ comment(yytext); }


{Quote}((["]["])|([^"\n]))*{Quote}	{ quoted(yytext); }
['].[']					{ quoted(yytext); }

{Blank}{Blank}*			{ blanks(yytext); }

   /* New line is not echoed - it starts a new paragraph */

"\n"				{  newline(); }


   /* Echo everything else.  If a character needs to be escaped, 
    * it will be.  The driver will build up multi-character strings
    * when it can. 
    */
.				{ echo_char(yytext[0]); }
%%

/* The driver (main procedure) 
 * has been moved to flexdriver.c 
 */




