/*
 *  html_styles.{h,c}
 *     Mapping from symbolic style names (e.g., keyword) to 
 *     beginning/ending tags in html. It would be better to read this
 *     at run-time, rather than compiling it in, but it would be better
 *     yet to use style-sheets.  And since style sheets are (still) just
 *     around the corner, we'll take the easy way out for now. 
 *
 *     Currently the initialized table lives in html_styles.c
 * 
 */


/* 
 *  styles init:  Currently a do-nothing function, but in future this
 *  might load a user-supplied table of desired style mappings at 
 *  run-time.
 */
extern void init_html_styles() ; 

/* 
 * style map:
 *  Look up symbolic style name.  This is not implemented efficiently,
 *  so it is best to call it once for each desired style name and store
 *  styles in local variables. 
 *  
 *  Two  values are passed by reference, the beginning and 
 *  ending tags sequence for the given symbolic style. These should
 *  be references to strings. If everything is ok, return value is
 *  1.  If style is not found, return value is 0, and 
 */
extern int  html_style_map ( char *style_name, 
			     char * * begin_tag, char * * end_tag ); 






