/*
 *  HTML driver for source code pretty-printers
 * 
 * 
 *  Author: Michal Young
 *  Created: 24 Aug 91 for LaTeX
 *  Revised 30 Apr 94 for MIF
 *  Revised 9 July 94 for ada2mif 
 *  Separated 11 July 94 as a library
 *  Revised 23 Febuary 95 for HTML
 *    
 */


/*************************************************************/
/*  Initiation and shutdown (required!)                      */
/*************************************************************/

void init_html(); 

void end_html(); 

/*************************************************************
 * Heading elements 
/*************************************************************/
void html_page_title(char *s); 

/*************************************************************/
/* The following sets substrings within a line               */
/*   with an appropriate character tag                       */
/*************************************************************/

void html_string(char *s); 

/* ************** */
/* When we have complex tags, and possibly groups of tags, we need    */
/* to specify the beginning and ending tag sequences separately.      */
/* One could argue that we should be passed only a single logical tag, */
/* and map it to a sequence of html tags here .... but then we put the */
/* semantics-to-presentation mapping in the driver, making it depend on */
/* a particular application (e.g., source code listings).  So, instead */
/* we keep this function simple and do the tag translation in the */
/* application-dependent part. */
void html_styled_string(char *s, char *begin_tags, char *end_tags); 

/* An invisible marker in the text, for indexing
 *  Second argument is a string name that can be placed in
 *  an index. 
 * 
 */
void html_marker_string(char *marker, char *index); 

/* Replace with: */
void html_open_marker(char *marker, char *index); 
void html_close_marker(); 

void html_image_reference(char *kind, char * filename); 

/* 
 * Increase/decrease font size
 */
void html_begin_larger(int delta); 
void html_end_larger();


/* 
 * Special characters
 */
void html_symbol(int glyph_code, char *str);


/**************************************************************/
/* The following set individual characters or special symbols;*/
/* If a character needs to be escaped or printed in hex, it   */
/* will be.                                                   */
/**************************************************************/

void html_echo_char(char ch);    

void html_newline();

