/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IContributedModelBuilder;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.photran.core.ASTFactory;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.lexer.SourceForm;
import org.eclipse.photran.internal.core.model.FortranElement;
import org.eclipse.photran.internal.core.model.FortranModelBuildingVisitor;
import org.eclipse.photran.internal.core.model.FortranParseTreeModelBuildingVisitor;
import org.eclipse.photran.internal.core.parser.GenericParseTreeVisitor;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;

public class FortranModelBuilder
implements IContributedModelBuilder {
    private TranslationUnit translationUnit;
    private Map newElements;
    private boolean isFixedForm;

    public FortranModelBuilder(ITranslationUnit tu, boolean isFixedForm) {
        if (!(tu instanceof ITranslationUnit)) {
            throw new Error("Unexpected subclass of ITranslationUnit");
        }
        this.translationUnit = (TranslationUnit)tu;
        this.newElements = new HashMap();
        this.isFixedForm = isFixedForm;
    }

    public void parse(boolean quickParseMode) throws Exception {
        String input = this.translationUnit.getBuffer().getContents();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input.getBytes());
        String filename = this.translationUnit.getElementName();
        boolean wasSuccessful = true;
        try {
            SourceForm sourceForm = this.isFixedForm ? SourceForm.FIXED_FORM : SourceForm.UNPREPROCESSED_FREE_FORM;
            IFortranAST ast = ASTFactory.buildAST((InputStream)inputStream, (String)filename, (SourceForm)sourceForm);
            if (this.isParseTreeModelEnabled()) {
                ast.visitUsing((GenericParseTreeVisitor)new FortranParseTreeModelBuildingVisitor(this.translationUnit, this));
            } else {
                ast.visitUsing((GenericParseTreeVisitor)new FortranModelBuildingVisitor(this.translationUnit, this));
            }
            this.addF90Elements(this.newElements);
        }
        catch (Exception e) {
            this.createParseFailureNode((Parent)this.translationUnit, e.getMessage());
            wasSuccessful = false;
        }
        this.setIsStructureKnown(wasSuccessful);
    }

    public void setIsStructureKnown(boolean isStructureKnown) {
        this.translationUnit.setIsStructureKnown(isStructureKnown);
    }

    private boolean isParseTreeModelEnabled() {
        return FortranPreferences.SHOW_PARSE_TREE.getValue();
    }

    private FortranElement createParseFailureNode(Parent parent, String errorMessage) throws CModelException {
        FortranElement.ErrorNode element = new FortranElement.ErrorNode(parent, errorMessage);
        parent.addChild((ICElement)element);
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    public FortranElement addF90Element(FortranElement element) throws CModelException {
        ICElement parent;
        if (element.getParent() == null) {
            element.setParent((ICElement)this.translationUnit);
        }
        if ((parent = element.getParent()) instanceof Parent) {
            ((Parent)parent).addChild((ICElement)element);
        }
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private void addF90Elements(Map elts) throws CModelException {
        this.addF90ElementsFor(null, elts);
    }

    private void addF90ElementsFor(Parent parent, Map elts) throws CModelException {
        Iterator it = elts.keySet().iterator();
        while (it.hasNext()) {
            FortranElement e = (FortranElement)((Object)it.next());
            if (e.getParent() != parent) continue;
            this.addF90Element(e);
            e.setIdentifier(e.getIdentifier());
            this.addF90ElementsFor((Parent)e, elts);
        }
    }
}

