/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.Wget;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.perfdmf.database.ConfigureFiles;
import edu.uoregon.tau.perfdmf.database.ParseConfig;
import edu.uoregon.tau.perfdmf.loader.Configure;
import edu.uoregon.tau.perfdmf.loader.ConfigureTest;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DatabaseManagerWindow
extends JFrame
implements ActionListener,
Observer,
ListSelectionListener,
ItemListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private String lastDirectory = "";
    private JList configList = new JList((Vector)ConfigureFiles.getConfigurationNames());
    private JButton saveConfig = new JButton("Save Configuration");
    private JButton removeConfig = new JButton("Remove Configuration");
    private JTextField name = new JTextField(15);
    private JPanel configurations = new JPanel();
    private JPanel editConfiguration = new JPanel();
    private String[] adapters = new String[]{"mysql", "postgresql", "oracle", "derby", "db2"};
    private JComboBox adapter = new JComboBox<String>(this.adapters);
    private JTextField driver = new JTextField(15);
    private JTextField host = new JTextField(15);
    private JTextField databaseName = new JTextField(15);
    private JTextField databaseUser = new JTextField(15);
    private JPasswordField databasePassword = new JPasswordField(15);
    private JButton jarfileChooser = new JButton("Browse...");
    private JButton schemafileChooser = new JButton("Browse...");
    private JTextField jarfile = new JTextField(15);
    private JTextField port = new JTextField(4);
    private JButton download = new JButton("Downloading");
    private JProgressBar bar = new JProgressBar();
    private JTextField schema = new JTextField(15);
    private JButton newConfig = new JButton("New Configuration");
    private JButton close = new JButton("Close");
    private JPanel buttons = new JPanel();
    private JCheckBox savePassword = new JCheckBox();
    private JLabel labelAdapter = new JLabel("Database Adapter:");
    private JLabel labelDriver = new JLabel("Database Driver:");
    private JLabel labelHost = new JLabel("Database Host:");
    private JLabel labelDatabaseName = new JLabel("Database Name:");
    private JLabel labelDatabaseUser = new JLabel("Database Username:");
    private JLabel labelDatabasePassword = new JLabel("Database Password:");
    private JLabel labelJarFile = new JLabel("Jar Path:");
    private JLabel labelPort = new JLabel("Database Port:");
    private JLabel labelConfig = new JLabel("Configurations:");
    private JLabel labelName = new JLabel("Name:");
    private JLabel labelBar = new JLabel("Downloading...");
    private JLabel labelSchema = new JLabel("Schema File:");
    private ParseConfig selectedConfig;
    private ParaProfManagerWindow mainWindow;

    public DatabaseManagerWindow(ParaProfManagerWindow paraProfManagerWindow) {
        this.mainWindow = paraProfManagerWindow;
        this.selectedConfig = ConfigureFiles.getConfigurations().size() > 0 ? (ParseConfig)ConfigureFiles.getConfigurations().get(0) : null;
        this.jarfileChooser.setText("Browse...");
        this.jarfileChooser.addActionListener(this);
        this.jarfileChooser.setActionCommand("jar");
        this.schemafileChooser.setText("Browse...");
        this.schemafileChooser.addActionListener(this);
        this.schemafileChooser.setActionCommand("schema");
        this.saveConfig.setText("Save Configuration");
        this.saveConfig.addActionListener(this);
        this.removeConfig.setText("Remove Configuration");
        this.removeConfig.addActionListener(this);
        this.newConfig.setText("New Configuration");
        this.newConfig.addActionListener(this);
        this.close.setText("Close");
        this.close.addActionListener(this);
        this.download.setText("Download");
        this.download.addActionListener(this);
        this.adapter.addItemListener(this);
        this.bar.setVisible(false);
        this.savePassword.setText("Save in cleartext?");
        this.savePassword.setSelected(true);
        this.savePassword.addChangeListener(this);
        this.adapter.setSelectedItem("derby");
        this.host.setEnabled(false);
        this.host.setText("");
        this.databasePassword.setEditable(false);
        this.databasePassword.setEnabled(true);
        this.databasePassword.setText("");
        this.savePassword.setEnabled(false);
        this.port.setEnabled(false);
        this.port.setText("");
        this.download.setEnabled(false);
        this.labelBar.setVisible(false);
        this.labelBar.setLabelFor(this.bar);
        this.labelAdapter.setLabelFor(this.adapter);
        this.labelDriver.setLabelFor(this.driver);
        this.labelHost.setLabelFor(this.host);
        this.labelDatabaseName.setLabelFor(this.databaseName);
        this.labelDatabaseUser.setLabelFor(this.databaseUser);
        this.labelDatabasePassword.setLabelFor(this.databasePassword);
        this.labelJarFile.setLabelFor(this.jarfile);
        this.labelPort.setLabelFor(this.port);
        this.labelConfig.setLabelFor(this.configList);
        this.labelName.setLabelFor(this.name);
        this.labelSchema.setLabelFor(this.schema);
        this.labelBar.setAlignmentY(1.0f);
        this.labelAdapter.setAlignmentY(1.0f);
        this.labelDriver.setAlignmentY(1.0f);
        this.labelHost.setAlignmentY(1.0f);
        this.labelDatabaseName.setAlignmentY(1.0f);
        this.labelDatabaseUser.setAlignmentY(1.0f);
        this.labelDatabasePassword.setAlignmentY(1.0f);
        this.labelJarFile.setAlignmentY(1.0f);
        this.labelPort.setAlignmentY(1.0f);
        this.labelName.setAlignmentY(1.0f);
        this.setTitle("Manage Database Configurations");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.editConfiguration.setLayout(new GridBagLayout());
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.labelName, gridBagConstraints, 0, 0, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.name, gridBagConstraints, 1, 0, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.labelAdapter, gridBagConstraints, 0, 1, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.adapter, gridBagConstraints, 1, 1, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.labelHost, gridBagConstraints, 0, 2, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.host, gridBagConstraints, 1, 2, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.labelDatabaseName, gridBagConstraints, 0, 3, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.databaseName, gridBagConstraints, 1, 3, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.labelDatabaseUser, gridBagConstraints, 0, 4, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.databaseUser, gridBagConstraints, 1, 4, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.labelDatabasePassword, gridBagConstraints, 0, 5, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.databasePassword, gridBagConstraints, 1, 5, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.savePassword, gridBagConstraints, 2, 5, 2, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.labelPort, gridBagConstraints, 0, 6, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.port, gridBagConstraints, 1, 6, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.labelDriver, gridBagConstraints, 0, 7, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.driver, gridBagConstraints, 1, 7, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.labelJarFile, gridBagConstraints, 0, 8, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.jarfile, gridBagConstraints, 1, 8, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.jarfileChooser, gridBagConstraints, 2, 8, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.download, gridBagConstraints, 3, 8, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.labelSchema, gridBagConstraints, 0, 9, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.schema, gridBagConstraints, 1, 9, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.schemafileChooser, gridBagConstraints, 2, 9, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.labelBar, gridBagConstraints, 0, 10, 1, 1);
        ParaProfUtils.addCompItem(this.editConfiguration, (Component)this.bar, gridBagConstraints, 1, 10, 2, 1);
        this.configurations.setLayout(new GridBagLayout());
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.setSelectionMode(0);
        this.configList.setSelectionModel(defaultListSelectionModel);
        this.configList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.configList.addListSelectionListener(this);
        ParaProfUtils.addCompItem(this.configurations, (Component)this.labelConfig, gridBagConstraints, 0, 0, 1, 1);
        ParaProfUtils.addCompItem(this.configurations, (Component)this.configList, gridBagConstraints, 0, 1, 1, 1);
        this.buttons.setLayout(new GridBagLayout());
        ParaProfUtils.addCompItem(this.buttons, (Component)this.newConfig, gridBagConstraints, 0, 0, 1, 1);
        ParaProfUtils.addCompItem(this.buttons, (Component)this.saveConfig, gridBagConstraints, 1, 0, 1, 1);
        ParaProfUtils.addCompItem(this.buttons, (Component)this.removeConfig, gridBagConstraints, 2, 0, 1, 1);
        ParaProfUtils.addCompItem(this.buttons, (Component)this.close, gridBagConstraints, 3, 0, 1, 1);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(new Dimension(750, 450));
        ParaProfUtils.addCompItem(this, (Component)this.configurations, gridBagConstraints, 0, 0, 1, 1);
        ParaProfUtils.addCompItem(this, (Component)this.editConfiguration, gridBagConstraints, 1, 0, 1, 1);
        ParaProfUtils.addCompItem(this, (Component)this.buttons, gridBagConstraints, 0, 1, 2, 1);
    }

    public void updateFields() {
        this.name.setText(this.selectedConfig.getName());
        this.adapter.setSelectedItem(this.selectedConfig.getDBType());
        this.host.setText(this.selectedConfig.getDBHost());
        this.databaseName.setText(this.selectedConfig.getDBName());
        this.databaseUser.setText(this.selectedConfig.getDBUserName());
        this.databasePassword.setText(this.selectedConfig.getDBPasswd());
        if (this.selectedConfig.getDBPasswd() == null) {
            this.savePassword.setSelected(false);
        } else {
            this.savePassword.setSelected(true);
        }
        this.port.setText(this.selectedConfig.getDBPort());
        this.driver.setText(this.selectedConfig.getJDBCDriver());
        this.jarfile.setText(this.selectedConfig.getJDBCJarFile());
        this.schema.setText(this.selectedConfig.getDBSchema());
    }

    public String writeConfig() {
        return this.writeConfig((String)this.configList.getModel().getElementAt(this.configList.getSelectedIndex()));
    }

    public String writeConfig(String string) {
        if (string == "unnamed") {
            string = "";
        }
        Configure configure = new Configure("", "");
        configure.initialize(System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator + "perfdmf.cfg");
        if (string.compareTo("Default") == 0) {
            configure.setConfigFileName("");
        } else {
            configure.setConfigFileName(string);
        }
        configure.setJDBCType((Object)((String)this.adapter.getSelectedItem()));
        configure.setDBHostname(this.host.getText());
        configure.setDBName(this.databaseName.getText());
        configure.setDBUsername(this.databaseUser.getText());
        if (this.savePassword.isSelected()) {
            configure.setDBPassword(new String(this.databasePassword.getPassword()));
            configure.savePassword();
        }
        configure.setDBPortNum(this.port.getText());
        configure.setJDBCDriver(this.driver.getText());
        configure.setJDBCJarfile(this.jarfile.getText());
        configure.setDBSchemaFile(this.schema.getText());
        return configure.writeConfigFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("jar")) {
            JFileChooser jFileChooser = new JFileChooser(this.lastDirectory);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setDialogTitle("Select File");
            jFileChooser.setApproveButtonText("Select");
            if (jFileChooser.showOpenDialog(this) != 0) {
                return;
            }
            this.lastDirectory = jFileChooser.getSelectedFile().getParent();
            this.jarfile.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        } else if (string.equals("schema")) {
            JFileChooser jFileChooser = new JFileChooser(this.lastDirectory);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setDialogTitle("Select File");
            jFileChooser.setApproveButtonText("Select");
            if (jFileChooser.showOpenDialog(this) != 0) {
                return;
            }
            this.lastDirectory = jFileChooser.getSelectedFile().getParent();
            this.schema.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        } else if (string.equals("Save Configuration")) {
            int n;
            String string2 = this.writeConfig(this.name.getText());
            this.configList.clearSelection();
            this.configList.setListData((Vector)ConfigureFiles.getConfigurationNames());
            ConfigureTest configureTest = new ConfigureTest("");
            configureTest.initialize(string2);
            if (!configureTest.checkSchema() && (n = JOptionPane.showConfirmDialog(this, "This database has not been initalized with PerfDMF.  Would you like to upload the schema?", "Initialize with PerfDMF", 0, 3)) == 1) {
                return;
            }
            configureTest.createDB(false);
            this.mainWindow.refreshDatabases();
        } else if (string.equals("Remove Configuration")) {
            String string3 = this.selectedConfig.getPath();
            System.out.println("deleating config, path: " + string3);
            File file = new File(string3);
            file.delete();
            this.configList.clearSelection();
            this.configList.setListData((Vector)ConfigureFiles.getConfigurationNames());
            this.mainWindow.refreshDatabases();
        } else if (string.equals("Download")) {
            JFileChooser jFileChooser = new JFileChooser(this.lastDirectory);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setDialogTitle("Download To This Directory");
            jFileChooser.setApproveButtonText("Download");
            if (jFileChooser.showOpenDialog(this) != 0) {
                return;
            }
            JProgressBar jProgressBar = new JProgressBar();
            this.bar.setVisible(true);
            this.labelBar.setVisible(true);
            String string4 = this.download_jar(jFileChooser.getSelectedFile());
            this.jarfile.setText(string4);
        } else if (string.equals("New Configuration")) {
            this.name.setText("");
            this.adapter.setSelectedItem("mysql");
            this.host.setText("");
            this.databaseName.setText("");
            this.databaseUser.setText("");
            this.databasePassword.setText("");
            this.port.setText("");
            this.driver.setText("");
            this.jarfile.setText("");
            this.schema.setText("");
            this.adapter.setSelectedItem("derby");
            this.host.setEnabled(false);
            this.host.setText("");
            this.databasePassword.setEditable(false);
            this.databasePassword.setEnabled(true);
            this.databasePassword.setText("");
            this.savePassword.setEnabled(false);
            this.port.setEnabled(false);
            this.port.setText("");
            this.download.setEnabled(false);
        } else if (string.equals("Close")) {
            this.setVisible(false);
        }
    }

    private String download_jar(File file) {
        new File(".perfdmf_tmp").mkdirs();
        System.setProperty("tar.location", ".perfdmf_tmp");
        String string = null;
        try {
            String string2 = "";
            if (((String)this.adapter.getSelectedItem()).compareToIgnoreCase("postgresql") == 0) {
                Wget.wget((String)"http://www.cs.uoregon.edu/research/paracomp/tau/postgresql-redirect.html", (String)(".perfdmf_tmp" + File.separator + "redirect.html"), (boolean)false);
                string2 = "postgresql.jar";
            } else if (((String)this.adapter.getSelectedItem()).compareToIgnoreCase("mysql") == 0) {
                Wget.wget((String)"http://www.cs.uoregon.edu/research/paracomp/tau/mysql-redirect.html", (String)(".perfdmf_tmp" + File.separator + "redirect.html"), (boolean)false);
                string2 = "mysql.jar";
            } else {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(".perfdmf_tmp" + File.separator + "redirect.html"))));
            String string3 = "";
            String string4 = bufferedReader.readLine();
            while (string4 != null) {
                if (string4.startsWith("URL=")) {
                    string3 = string4.substring(4);
                }
                string4 = bufferedReader.readLine();
            }
            bufferedReader.close();
            string = file.getAbsolutePath() + File.separator + string2;
            DownloadThread downloadThread = new DownloadThread(this.bar, this.labelBar, string3, string);
            downloadThread.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public void update(Observable observable, Object object) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.configList.getSelectedIndex() != -1) {
            this.selectedConfig = (ParseConfig)ConfigureFiles.getConfigurations().get(this.configList.getSelectedIndex());
        }
        this.switchAdapter((String)this.adapter.getSelectedItem());
        this.updateFields();
    }

    private void switchAdapter(String string) {
        String string2 = ParaProf.tauHome + File.separator + "tools" + File.separator + "src" + File.separator + "perfdmf" + File.separator + "etc" + File.separator;
        this.schema.setText(string2 + "dbschema." + string + ".txt");
        if (string.compareTo("mysql") == 0) {
            this.download.setEnabled(true);
            this.host.setEnabled(true);
            this.databasePassword.setEditable(true);
            this.savePassword.setEnabled(true);
            this.databasePassword.setEnabled(true);
            this.savePassword.setSelected(true);
            this.port.setEnabled(true);
            this.labelDatabaseName.setText("Database Name:");
            this.driver.setText("org.gjt.mm.mysql.Driver");
            this.port.setText("3306");
            this.host.setText("localhost");
            String string3 = System.getProperty("os.name").startsWith("Windows") ? ParaProf.tauHome + File.separator + "bin" + File.separator + "mysql.jar" : ParaProf.tauHome + File.separator + ParaProf.tauArch + File.separator + "lib" + File.separator + "mysql.jar";
            File file = new File(string3);
            if (file.exists()) {
                this.jarfile.setText(string3);
            } else {
                this.jarfile.setText("(Please Download >>)");
            }
        } else if (string.compareTo("postgresql") == 0) {
            this.download.setEnabled(true);
            this.host.setEnabled(true);
            this.databasePassword.setEditable(true);
            this.databasePassword.setEnabled(true);
            this.savePassword.setEnabled(true);
            this.savePassword.setSelected(true);
            this.port.setEnabled(true);
            this.labelDatabaseName.setText("Database Name:");
            this.driver.setText("org.postgresql.Driver");
            this.port.setText("5432");
            this.host.setText("localhost");
            String string4 = System.getProperty("os.name").startsWith("Windows") ? ParaProf.tauHome + File.separator + "bin" + File.separator + "postgresql.jar" : ParaProf.tauHome + File.separator + ParaProf.tauArch + File.separator + "lib" + File.separator + "postgresql.jar";
            File file = new File(string4);
            if (file.exists()) {
                this.jarfile.setText(string4);
            } else {
                this.jarfile.setText("(Please Download >>)");
            }
            this.schema.setText(string2 + "dbschema.txt");
        } else if (string.compareTo("oracle") == 0) {
            this.download.setEnabled(false);
            this.host.setEnabled(true);
            this.databasePassword.setEditable(true);
            this.databasePassword.setEnabled(true);
            this.savePassword.setEnabled(true);
            this.savePassword.setSelected(true);
            this.port.setEnabled(true);
            this.labelDatabaseName.setText("Database Name:");
            this.driver.setText("oracle.jdbc.OracleDriver");
            this.port.setText("1521");
            this.host.setText("localhost");
            this.jarfile.setText("(Please Acquire oracle's JDBC driver)");
        } else if (string.compareTo("derby") == 0) {
            this.host.setEnabled(false);
            this.host.setText("");
            this.databasePassword.setEditable(false);
            this.databasePassword.setEnabled(false);
            this.databasePassword.setText("");
            this.savePassword.setEnabled(false);
            this.port.setEnabled(false);
            this.port.setText("");
            this.download.setEnabled(false);
            this.labelDatabaseName.setText("Path to Database:");
            this.driver.setText("org.apache.derby.jdbc.EmbeddedDriver");
            if (System.getProperty("os.name").startsWith("Windows")) {
                this.jarfile.setText(ParaProf.tauHome + File.separator + "bin" + File.separator + "derby.jar");
            } else {
                this.jarfile.setText(ParaProf.tauHome + File.separator + "tools" + File.separator + "src" + File.separator + "contrib" + File.separator + "derby.jar");
            }
        } else if (string.compareTo("db2") == 0) {
            this.download.setEnabled(false);
            this.host.setEnabled(true);
            this.databasePassword.setEditable(true);
            this.databasePassword.setEnabled(true);
            this.savePassword.setEnabled(true);
            this.savePassword.setSelected(true);
            this.port.setEnabled(true);
            this.labelDatabaseName.setText("Database Name:");
            this.driver.setText("com.ibm.db2.jcc.DB2Driver");
            this.port.setText("446");
            this.host.setText("localhost");
            this.jarfile.setText("(Please Acquire db2's JDBC driver)");
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.switchAdapter((String)itemEvent.getItem());
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.savePassword.isSelected()) {
            this.databasePassword.setEditable(true);
        } else {
            this.databasePassword.setEditable(false);
        }
    }

    public class DownloadProgress
    implements Wget.Progress {
        private JProgressBar bar;
        private JLabel label;

        public DownloadProgress(JProgressBar jProgressBar, JLabel jLabel) {
            this.bar = jProgressBar;
            this.label = jLabel;
        }

        public void reportFininshed(int n) {
            this.bar.setValue(n);
            this.label.setText("Done.");
        }

        public void reportProgress(int n) {
            this.bar.setValue(n);
            this.label.repaint();
        }

        public void reportSize(int n) {
            this.bar.setMaximum(n);
            this.bar.setValue(0);
            this.bar.setVisible(true);
            this.label.setText("Downloading");
            this.label.setVisible(true);
        }
    }

    public class DownloadThread
    extends Thread {
        private JProgressBar bar;
        private JLabel label;
        private String url;
        private String file;

        public DownloadThread(JProgressBar jProgressBar, JLabel jLabel, String string, String string2) {
            this.bar = jProgressBar;
            this.label = jLabel;
            this.url = string;
            this.file = string2;
        }

        public void run() {
            DownloadProgress downloadProgress = new DownloadProgress(this.bar, DatabaseManagerWindow.this.labelBar);
            try {
                Wget.wget((String)this.url, (String)this.file, (boolean)true, (Wget.Progress)downloadProgress);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

