/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.sourceview;

import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.sourceview.LineNumberedTextPanel;
import edu.uoregon.tau.perfdmf.SourceRegion;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.File;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;

public class SourceViewer
extends JFrame
implements ParaProfWindow {
    LineNumberedTextPanel textPanel;
    JTextPane ed = null;

    public int getLineStartOffset(JEditorPane jEditorPane, int n) throws BadLocationException {
        Element element = jEditorPane.getDocument().getDefaultRootElement();
        Element element2 = element.getElement(n);
        if (element2 == null) {
            return -1;
        }
        return element2.getStartOffset();
    }

    public int getLineEndOffset(JTextPane jTextPane, int n) throws BadLocationException {
        Element element = jTextPane.getDocument().getDefaultRootElement();
        Element element2 = element.getElement(n);
        if (element2 == null) {
            return -1;
        }
        int n2 = element2.getEndOffset();
        return n2;
    }

    public void highlightRegion(SourceRegion sourceRegion) {
        try {
            final int n = Math.max(0, this.getLineStartOffset(this.ed, Math.max(0, sourceRegion.getStartLine() - 1)));
            final int n2 = Math.max(0, this.getLineEndOffset(this.ed, Math.max(0, sourceRegion.getEndLine() - 1)));
            int n3 = this.getLineStartOffset(this.ed, sourceRegion.getStartLine() + 50);
            if (n3 == -1) {
                n3 = n2;
            }
            int n4 = n3;
            this.ed.setCaretPosition(n);
            this.ed.setEditable(false);
            this.ed.setSelectionStart(n);
            this.ed.setSelectionEnd(n4);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Rectangle rectangle = SourceViewer.this.ed.getVisibleRect();
                    SourceViewer.this.ed.setCaretPosition(n2);
                    SourceViewer.this.ed.moveCaretPosition(n);
                    SourceViewer.this.ed.scrollRectToVisible(rectangle);
                }
            });
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this.textPanel, this.textPanel));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    public SourceViewer(File file) {
        this.setTitle("TAU: ParaProf: Source Browser: " + file);
        ParaProfUtils.setFrameIcon(this);
        try {
            URL uRL = new URL("file", null, file.getAbsolutePath());
            this.textPanel = new LineNumberedTextPanel();
            this.ed = this.textPanel.getJTextPane();
            this.ed.setPage(uRL);
            this.ed.setFont(new Font("Monospaced", ParaProf.preferencesWindow.getFontStyle(), ParaProf.preferencesWindow.getFontSize()));
            this.getContentPane().add((Component)this.textPanel, "West");
            this.getContentPane().add((Component)this.textPanel.scrollPane, "Center");
            this.pack();
            this.setupMenus();
            this.setSize(700, 1000);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void closeThisWindow() {
        this.setVisible(false);
        ParaProf.decrementNumWindows();
        this.dispose();
    }

    public void help(boolean bl) {
        ParaProf.getHelpWindow().clearText();
        if (bl) {
            ParaProf.getHelpWindow().setVisible(true);
        }
        ParaProf.getHelpWindow().writeText("This is the Source Viewer.\n");
        ParaProf.getHelpWindow().writeText("When you right click on a timer with source location information, you can display it here.");
    }
}

