/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.tablemodel;

import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultTreeModel;

public class ApplicationTableModel
extends AbstractTableModel {
    private ParaProfApplication application;
    private String[] columnNames = new String[]{"AppField", "Value"};
    private ParaProfManagerWindow paraProfManager;
    private DefaultTreeModel defaultTreeModel;
    private List fieldNames;

    public ApplicationTableModel(ParaProfManagerWindow paraProfManagerWindow, ParaProfApplication paraProfApplication, DefaultTreeModel defaultTreeModel) {
        this.application = paraProfApplication;
        this.paraProfManager = paraProfManagerWindow;
        this.defaultTreeModel = defaultTreeModel;
        this.fieldNames = new ArrayList();
        this.fieldNames.add("Name");
        this.fieldNames.add("Application ID");
        for (int i = 0; i < this.application.getNumFields(); ++i) {
            this.fieldNames.add(this.application.getFieldName(i));
        }
    }

    public void updateDatabaseFields(ParaProfApplication paraProfApplication) {
        if (paraProfApplication != null) {
            int n;
            this.fieldNames = new ArrayList();
            this.fieldNames.add("Name");
            this.fieldNames.add("Application ID");
            for (n = 0; n < this.application.getNumFields(); ++n) {
                this.fieldNames.add(this.application.getFieldName(n));
            }
            for (n = 0; n < paraProfApplication.getNumFields(); ++n) {
                this.fieldNames.add(paraProfApplication.getFieldName(n));
            }
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public int getRowCount() {
        return this.fieldNames.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.fieldNames.get(n);
        }
        switch (n) {
            case 0: {
                return this.application.getName();
            }
            case 1: {
                return new Integer(this.application.getID());
            }
        }
        return this.application.getField(n - 2);
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 1 && n != 1;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (!(object instanceof String)) {
            return;
        }
        String string = (String)object;
        if (n == 0) {
            this.application.setName(string);
            this.updateDB();
        } else {
            this.application.setField(n - 2, string);
            this.updateDB();
        }
        this.defaultTreeModel.nodeChanged(this.application.getDMTN());
    }

    private void updateDB() {
        DatabaseAPI databaseAPI;
        if (this.application.dBApplication() && (databaseAPI = this.paraProfManager.getDatabaseAPI(this.application.getDatabase())) != null) {
            databaseAPI.saveApplication((Application)this.application);
            databaseAPI.terminate();
        }
    }
}

