/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.IProjectSourceLocation;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.debug.internal.core.sourcelookup.SourceUtils;
import org.eclipse.cdt.debug.ui.sourcelookup.OldDefaultSourceLocator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.DefaultSourceContainer;
import org.w3c.dom.Element;

public class DefaultSourceLocator
extends CSourceLookupDirector {
    static /* synthetic */ Class class$0;

    public void initializeFromMemento(String memento, ILaunchConfiguration configuration) throws CoreException {
        Element rootElement = DebugPlugin.parseDocument((String)memento);
        if (rootElement.getNodeName().equalsIgnoreCase("PromptingSourceLocator")) {
            this.initializeFromOldMemento(memento, configuration);
        } else {
            super.initializeFromMemento(memento, configuration);
        }
    }

    private void initializeFromOldMemento(String memento, ILaunchConfiguration configuration) throws CoreException {
        this.dispose();
        this.setLaunchConfiguration(configuration);
        OldDefaultSourceLocator old = new OldDefaultSourceLocator();
        old.initializeFromMemento(memento);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICSourceLocator csl = (ICSourceLocator)old.getAdapter(clazz);
        this.setFindDuplicates(csl.searchForDuplicateFiles());
        ICSourceLocation[] locations = csl.getSourceLocations();
        IProject project = csl.getProject();
        List list = CDebugUtils.getReferencedProjects((IProject)project);
        HashSet<String> names = new HashSet<String>(list.size() + 1);
        names.add(project.getName());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            names.add(((IProject)it.next()).getName());
        }
        boolean includesDefault = true;
        int i = 0;
        while (i < locations.length) {
            if (locations[i] instanceof IProjectSourceLocation && ((IProjectSourceLocation)locations[i]).isGeneric() && !names.contains(((IProjectSourceLocation)locations[i]).getProject().getName())) {
                includesDefault = false;
                break;
            }
            ++i;
        }
        ArrayList<ICSourceLocation> locs = new ArrayList<ICSourceLocation>(locations.length);
        int i2 = 0;
        while (i2 < locations.length) {
            if (!(includesDefault && locations[i2] instanceof IProjectSourceLocation && names.contains(((IProjectSourceLocation)locations[i2]).getProject().getName()))) {
                locs.add(locations[i2]);
            }
            ++i2;
        }
        ISourceContainer[] containers = SourceUtils.convertSourceLocations((ICSourceLocation[])locs.toArray(new ICSourceLocation[locs.size()]));
        ArrayList<ISourceContainer> cons = new ArrayList<ISourceContainer>(Arrays.asList(containers));
        if (includesDefault) {
            DefaultSourceContainer defaultContainer = new DefaultSourceContainer();
            defaultContainer.init((ISourceLookupDirector)this);
            cons.add(0, (ISourceContainer)defaultContainer);
        }
        this.setSourceContainers(cons.toArray(new ISourceContainer[cons.size()]));
        this.initializeParticipants();
    }
}

