/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDelegate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.core.runtime.PlatformObject;

public class CPPParameter
extends PlatformObject
implements ICPPParameter,
ICPPInternalBinding {
    private IType type = null;
    private IASTName[] declarations = null;
    static /* synthetic */ Class class$0;

    public CPPParameter(IASTName name) {
        this.declarations = new IASTName[]{name};
    }

    public CPPParameter(IType type) {
        this.type = type;
    }

    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    public IASTNode getDefinition() {
        return null;
    }

    public void addDeclaration(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTName name = (IASTName)node;
        if (this.declarations == null) {
            this.declarations = new IASTName[]{name};
        } else if (this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.declarations[0])).getOffset()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declarations = (IASTName[])ArrayUtil.prepend(clazz, this.declarations, name);
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declarations = (IASTName[])ArrayUtil.append(clazz, this.declarations, name);
        }
    }

    public void removeDeclaration(IASTNode node) {
        if (this.declarations != null) {
            int i = 0;
            while (i < this.declarations.length) {
                if (node == this.declarations[i]) {
                    if (i == this.declarations.length - 1) {
                        this.declarations[i] = null;
                    } else {
                        System.arraycopy(this.declarations, i + 1, this.declarations, i, this.declarations.length - 1 - i);
                    }
                }
                ++i;
            }
        }
    }

    private IASTName getPrimaryDeclaration() {
        if (this.declarations != null) {
            int i = 0;
            while (i < this.declarations.length && this.declarations[i] != null) {
                IASTNode node = this.declarations[i].getParent();
                while (!(node instanceof IASTDeclaration)) {
                    node = node.getParent();
                }
                if (node instanceof IASTFunctionDefinition) {
                    return this.declarations[i];
                }
                ++i;
            }
            return this.declarations[0];
        }
        return null;
    }

    public String getName() {
        IASTName name = this.getPrimaryDeclaration();
        if (name != null) {
            return name.toString();
        }
        return "";
    }

    public char[] getNameCharArray() {
        IASTName name = this.getPrimaryDeclaration();
        if (name != null) {
            return name.toCharArray();
        }
        return CPPSemantics.EMPTY_NAME_ARRAY;
    }

    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.getPrimaryDeclaration());
    }

    public IASTNode getPhysicalNode() {
        if (this.declarations != null) {
            return this.declarations[0];
        }
        return null;
    }

    public IType getType() {
        if (this.type == null && this.declarations != null) {
            this.type = CPPVisitor.createType((IASTDeclarator)this.declarations[0].getParent());
        }
        return this.type;
    }

    public boolean isStatic() {
        return false;
    }

    public String[] getQualifiedName() {
        return new String[]{this.getName()};
    }

    public char[][] getQualifiedNameCharArray() {
        return new char[][]{this.getNameCharArray()};
    }

    public boolean isGloballyQualified() {
        return false;
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPParameterDelegate(name, this);
    }

    public void addDefinition(IASTNode node) {
        this.addDeclaration(node);
    }

    public boolean isExtern() {
        return false;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    public boolean hasStorageClass(int storage) {
        IASTNode[] ns = this.getDeclarations();
        if (ns == null) {
            return false;
        }
        int i = 0;
        while (i < ns.length && ns[i] != null) {
            IASTDeclSpecifier declSpec;
            IASTNode parent = ns[i].getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            if (parent instanceof IASTSimpleDeclaration && (declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier()).getStorageClass() == storage) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IASTInitializer getDefaultValue() {
        if (this.declarations == null) {
            return null;
        }
        int i = 0;
        while (i < this.declarations.length && this.declarations[i] != null) {
            IASTNode parent = this.declarations[i].getParent();
            while (parent.getPropertyInParent() == IASTDeclarator.NESTED_DECLARATOR) {
                parent = parent.getParent();
            }
            IASTInitializer init = ((IASTDeclarator)parent).getInitializer();
            if (init != null) {
                return init;
            }
            ++i;
        }
        return null;
    }

    public static class CPPParameterDelegate
    extends CPPDelegate
    implements ICPPParameter {
        public CPPParameterDelegate(IASTName name, IParameter binding) {
            super(name, binding);
        }

        public IType getType() throws DOMException {
            return ((IParameter)this.getBinding()).getType();
        }

        public boolean isStatic() throws DOMException {
            return ((IParameter)this.getBinding()).isStatic();
        }

        public boolean isExtern() {
            return false;
        }

        public boolean isAuto() throws DOMException {
            return ((IParameter)this.getBinding()).isAuto();
        }

        public boolean isRegister() throws DOMException {
            return ((IParameter)this.getBinding()).isRegister();
        }

        public boolean isMutable() {
            return false;
        }

        public IASTInitializer getDefaultValue() {
            return ((ICPPParameter)this.getBinding()).getDefaultValue();
        }
    }
}

