/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPASTPointer;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;

public class GPPPointerType
extends CPPPointerType
implements IGPPPointerType {
    private boolean isRestrict = false;

    public GPPPointerType(IType type, IGPPASTPointer operator) {
        super(type, operator);
        this.isRestrict = operator.isRestrict();
    }

    public GPPPointerType(IType type) {
        super(type);
    }

    public GPPPointerType(IType type, boolean isConst, boolean isVolatile, boolean isRestrict) {
        super(type, isConst, isVolatile);
        this.isRestrict = isRestrict;
    }

    public IType stripQualifiers() {
        GPPPointerType result = (GPPPointerType)super.stripQualifiers();
        if (this.isRestrict) {
            if (result == this) {
                result = (GPPPointerType)this.clone();
                result.isRestrict = false;
            } else {
                result.isRestrict = false;
            }
        }
        return result;
    }

    public boolean isRestrict() {
        return this.isRestrict;
    }

    public boolean isSameType(IType o) {
        if (!super.isSameType(o)) {
            return false;
        }
        if (o instanceof IGPPPointerType) {
            return this.isRestrict == ((IGPPPointerType)o).isRestrict();
        }
        return !this.isRestrict;
    }
}

