/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IRegion;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.MultiOperation;
import org.eclipse.cdt.internal.core.model.Region;

public class DeleteElementsOperation
extends MultiOperation {
    protected Map fChildrenToRemove;

    public DeleteElementsOperation(ICElement[] elementsToDelete, boolean force) {
        super(elementsToDelete, force);
    }

    protected String getMainTaskName() {
        return "operation.deleteElementProgress";
    }

    protected void groupElements() throws CModelException {
        this.fChildrenToRemove = new HashMap(1);
        int uniqueTUs = 0;
        int i = 0;
        int length = this.fElementsToProcess.length;
        while (i < length) {
            ICElement e = this.fElementsToProcess[i];
            ITranslationUnit tu = this.getTranslationUnitFor(e);
            if (tu == null) {
                throw new CModelException(new CModelStatus(976, e));
            }
            IRegion region = (IRegion)this.fChildrenToRemove.get(tu);
            if (region == null) {
                region = new Region();
                this.fChildrenToRemove.put(tu, region);
                ++uniqueTUs;
            }
            region.add(e);
            ++i;
        }
        this.fElementsToProcess = new ICElement[uniqueTUs];
        Iterator iter = this.fChildrenToRemove.keySet().iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            this.fElementsToProcess[i2++] = (ICElement)iter.next();
        }
    }

    protected void processElement(ICElement element) throws CModelException {
        ITranslationUnit tu = (ITranslationUnit)element;
        IBuffer buffer = tu.getBuffer();
        if (buffer == null) {
            return;
        }
        CElementDelta delta = new CElementDelta(tu);
        ICElement[] cuElements = ((IRegion)this.fChildrenToRemove.get(tu)).getElements();
        int i = 0;
        int length = cuElements.length;
        while (i < length) {
            char[] contents;
            ICElement e = cuElements[i];
            if (e.exists() && (contents = buffer.getCharacters()) != null) {
                String tuName = tu.getElementName();
                this.replaceElementInBuffer(buffer, e, tuName);
                delta.removed(e);
            }
            ++i;
        }
        if (delta.getAffectedChildren().length > 0) {
            tu.save(this.getSubProgressMonitor(1), this.fForce);
            if (!tu.isWorkingCopy()) {
                this.addDelta(delta);
            }
        }
    }

    private void replaceElementInBuffer(IBuffer buffer, ICElement elementToRemove, String cuName) throws CModelException {
        if (elementToRemove instanceof ISourceReference) {
            ISourceRange range = ((ISourceReference)((Object)elementToRemove)).getSourceRange();
            int startPosition = range.getStartPos();
            int length = range.getLength();
            boolean newLineFound = false;
            int offset = range.getStartPos() + range.getLength();
            while (true) {
                try {
                    char c = buffer.getChar(offset);
                    if (c == ';') {
                        ++length;
                    } else if (c == '\r' || c == '\n') {
                        newLineFound = true;
                        ++length;
                    } else {
                        if (newLineFound || c != ' ') break;
                        ++length;
                    }
                }
                catch (Exception exception) {
                    break;
                }
                ++offset;
            }
            buffer.replace(startPosition, length, CharOperation.NO_CHAR);
        }
    }

    protected void processElements() throws CModelException {
        this.groupElements();
        super.processElements();
    }

    protected void verify(ICElement element) throws CModelException {
        ICElement[] children = ((IRegion)this.fChildrenToRemove.get(element)).getElements();
        int i = 0;
        while (i < children.length) {
            ICElement child = children[i];
            if (child.getResource() != null) {
                this.error(967, child);
            }
            if (child.isReadOnly()) {
                this.error(976, child);
            }
            ++i;
        }
    }
}

