/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.MoveElementsOperation;

public class RenameElementsOperation
extends MoveElementsOperation {
    public RenameElementsOperation(ICElement[] elements, ICElement[] destinations, String[] newNames, boolean force) {
        super(elements, destinations, force);
        this.setRenamings(newNames);
    }

    protected String getMainTaskName() {
        return "operation.renameElementProgress";
    }

    protected boolean isRename() {
        return true;
    }

    protected ICModelStatus verify() {
        ICModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.fRenamingsList == null || this.fRenamingsList.length == 0) {
            return new CModelStatus(982);
        }
        return CModelStatus.VERIFIED_OK;
    }

    protected void verify(ICElement element) throws CModelException {
        int elementType = element.getElementType();
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if (element.isReadOnly()) {
            this.error(976, element);
        }
        if (!(element instanceof ISourceReference)) {
            this.error(967, element);
        }
        if (elementType < 60) {
            this.error(967, element);
        }
        this.verifyRenaming(element);
    }
}

