/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.LinkedList;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.parser.QuickParseCallback;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTLinkageSpecification;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;

public class StructuralParseCallback
extends QuickParseCallback {
    protected LinkedList scopeStack = new LinkedList();
    protected IASTScope currentScope = null;
    protected int inclusionLevel = 0;

    private void addElement(IASTDeclaration element) {
        if (this.inclusionLevel == 0) {
            if (this.currentScope instanceof ASTScope) {
                ((ASTScope)this.currentScope).addDeclaration(element);
            } else if (this.currentScope instanceof ASTLinkageSpecification) {
                ((ASTLinkageSpecification)this.currentScope).addDeclaration(element);
            }
        }
    }

    private void enterScope(IASTNode node) {
        if (node instanceof IASTScope) {
            if (node instanceof ASTScope) {
                ((ASTScope)node).initDeclarations();
            }
            this.pushScope((IASTScope)node);
        }
    }

    private void exitScope(IASTNode node) {
        if (node instanceof IASTScope) {
            this.popScope();
        }
    }

    private void pushScope(IASTScope scope) {
        this.scopeStack.addFirst(this.currentScope);
        this.currentScope = scope;
    }

    private IASTScope popScope() {
        IASTScope oldScope = this.currentScope;
        this.currentScope = this.scopeStack.size() > 0 ? (IASTScope)this.scopeStack.removeFirst() : null;
        return oldScope;
    }

    public void acceptMacro(IASTMacro macro) {
        if (this.inclusionLevel == 0) {
            this.macros.add(macro);
        }
    }

    public void acceptVariable(IASTVariable variable) {
        this.addElement(variable);
    }

    public void acceptFunctionDeclaration(IASTFunction function) {
        if (function.getOwnerTemplateDeclaration() == null) {
            this.addElement(function);
        } else if (function.getOwnerTemplateDeclaration() instanceof IASTTemplateDeclaration) {
            this.addElement((IASTTemplateDeclaration)function.getOwnerTemplateDeclaration());
        }
    }

    public void acceptTypedefDeclaration(IASTTypedefDeclaration typedef) {
        this.addElement(typedef);
    }

    public void acceptUsingDirective(IASTUsingDirective usageDirective) {
        this.addElement(usageDirective);
    }

    public void acceptEnumerationSpecifier(IASTEnumerationSpecifier enumeration) {
        this.enterScope(enumeration);
    }

    public void acceptElaboratedForewardDeclaration(IASTElaboratedTypeSpecifier elaboratedType) {
        this.enterScope(elaboratedType);
    }

    public void acceptAbstractTypeSpecDeclaration(IASTAbstractTypeSpecifierDeclaration abstractDeclaration) {
        if (abstractDeclaration.getOwnerTemplateDeclaration() == null) {
            this.addElement(abstractDeclaration);
        } else if (abstractDeclaration.getOwnerTemplateDeclaration() instanceof IASTTemplateDeclaration) {
            this.addElement((IASTTemplateDeclaration)abstractDeclaration.getOwnerTemplateDeclaration());
        }
    }

    public void enterInclusion(IASTInclusion inclusion) {
        if (this.inclusionLevel == 0) {
            this.inclusions.add(inclusion);
        }
        ++this.inclusionLevel;
    }

    public void enterNamespaceDefinition(IASTNamespaceDefinition namespaceDefinition) {
        this.addElement(namespaceDefinition);
        this.enterScope(namespaceDefinition);
    }

    public void enterClassSpecifier(IASTClassSpecifier classSpecification) {
        this.enterScope(classSpecification);
    }

    public void enterLinkageSpecification(IASTLinkageSpecification linkageSpec) {
        this.addElement(linkageSpec);
        this.enterScope(linkageSpec);
    }

    public void enterCompilationUnit(IASTCompilationUnit compilationUnit) {
        this.enterScope(compilationUnit);
    }

    public void acceptMethodDeclaration(IASTMethod method) {
        if (method.getOwnerTemplateDeclaration() == null) {
            this.addElement(method);
        } else if (method.getOwnerTemplateDeclaration() instanceof IASTTemplateDeclaration) {
            this.addElement((IASTTemplateDeclaration)method.getOwnerTemplateDeclaration());
        }
    }

    public void acceptField(IASTField field) {
        this.addElement(field);
    }

    public void exitCompilationUnit(IASTCompilationUnit compilationUnit) {
        this.exitScope(compilationUnit);
        this.compUnit = compilationUnit;
    }

    public void exitInclusion(IASTInclusion inclusion) {
        --this.inclusionLevel;
    }

    public IASTCompilationUnit getCompilationUnit() {
        return this.compUnit;
    }

    public void exitClassSpecifier(IASTClassSpecifier classSpecification) {
        this.exitScope(classSpecification);
    }

    public void exitLinkageSpecification(IASTLinkageSpecification linkageSpec) {
        this.exitScope(linkageSpec);
    }

    public void exitNamespaceDefinition(IASTNamespaceDefinition namespaceDefinition) {
        this.exitScope(namespaceDefinition);
    }

    public void enterFunctionBody(IASTFunction function) {
        if (function.getOwnerTemplateDeclaration() == null) {
            this.addElement(function);
        } else if (function.getOwnerTemplateDeclaration() instanceof IASTTemplateDeclaration) {
            this.addElement((IASTTemplateDeclaration)function.getOwnerTemplateDeclaration());
        }
    }

    public void enterMethodBody(IASTMethod method) {
        if (method.getOwnerTemplateDeclaration() == null) {
            this.addElement(method);
        } else if (method.getOwnerTemplateDeclaration() instanceof IASTTemplateDeclaration) {
            this.addElement((IASTTemplateDeclaration)method.getOwnerTemplateDeclaration());
        }
    }
}

