/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class PDOMIndexerJob
extends Job {
    private final PDOMManager manager;
    private LinkedList queue = new LinkedList();
    private IPDOMIndexerTask currentTask;
    private boolean isCancelling = false;
    private Object taskMutex = new Object();
    private IProgressMonitor monitor;

    public PDOMIndexerJob(PDOMManager manager) {
        super(CCorePlugin.getResourceString("pdom.indexer.name"));
        this.manager = manager;
        this.setPriority(30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        this.monitor = monitor;
        long start = System.currentTimeMillis();
        String taskName = CCorePlugin.getResourceString("pdom.indexer.task");
        monitor.beginTask(taskName, -1);
        this.fillQueue();
        while (true) {
            if (!this.queue.isEmpty()) {
                Object object = this.taskMutex;
                synchronized (object) {
                    this.currentTask = (IPDOMIndexerTask)this.queue.removeFirst();
                }
                this.currentTask.run(monitor);
                object = this.taskMutex;
                synchronized (object) {
                    if (this.isCancelling) {
                        monitor.setCanceled(false);
                        this.isCancelling = false;
                        this.taskMutex.notify();
                    } else if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                }
            }
            if (this.manager.finishIndexerJob()) break;
            this.fillQueue();
        }
        String showTimings = Platform.getDebugOption((String)"org.eclipse.cdt.core/debug/pdomtimings");
        if (showTimings != null && showTimings.equalsIgnoreCase("true")) {
            System.out.println("PDOM Indexer Job Time: " + (System.currentTimeMillis() - start));
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillQueue() {
        Object object = this.taskMutex;
        synchronized (object) {
            IPDOMIndexerTask task = this.manager.getNextTask();
            while (task != null) {
                this.queue.addLast(task);
                task = this.manager.getNextTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJobs(IPDOMIndexer indexer) {
        Object object = this.taskMutex;
        synchronized (object) {
            Iterator i = this.queue.iterator();
            while (i.hasNext()) {
                IPDOMIndexerTask task = (IPDOMIndexerTask)i.next();
                if (!task.getIndexer().equals(indexer)) continue;
                i.remove();
            }
            if (this.currentTask != null && this.currentTask.getIndexer().equals(indexer)) {
                this.monitor.setCanceled(true);
                this.isCancelling = true;
                try {
                    this.taskMutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

