/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTFunctionStyleMacroParameter;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.FunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectStyleMacro;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroParameter;
import org.eclipse.core.runtime.CoreException;

public class PDOMMacro {
    private final PDOM pdom;
    private final int record;
    private static final int NAME = 0;
    private static final int FIRST_PARAMETER = 4;
    private static final int EXPANSION = 8;
    private static final int NEXT_MACRO = 12;
    private static final int RECORD_SIZE = 16;

    public PDOMMacro(PDOM pdom, int record) {
        this.pdom = pdom;
        this.record = record;
    }

    public PDOMMacro(PDOM pdom, IASTPreprocessorMacroDefinition macro) throws CoreException {
        this.pdom = pdom;
        Database db = pdom.getDB();
        this.record = db.malloc(16);
        db.putInt(this.record + 0, db.newString(macro.getName().toCharArray()).getRecord());
        db.putInt(this.record + 8, db.newString(macro.getExpansion()).getRecord());
        this.setNextMacro(0);
        PDOMMacroParameter last = null;
        if (macro instanceof IASTPreprocessorFunctionStyleMacroDefinition) {
            IASTPreprocessorFunctionStyleMacroDefinition func = (IASTPreprocessorFunctionStyleMacroDefinition)macro;
            IASTFunctionStyleMacroParameter[] params = func.getParameters();
            int i = params.length - 1;
            while (i >= 0) {
                IASTFunctionStyleMacroParameter param = params[i];
                PDOMMacroParameter pdomParam = new PDOMMacroParameter(pdom, param.getParameter());
                if (last != null) {
                    pdomParam.setNextParameter(last);
                }
                last = pdomParam;
                --i;
            }
        }
        db.putInt(this.record + 4, last != null ? last.getRecord() : 0);
    }

    public int getRecord() {
        return this.record;
    }

    public void delete() throws CoreException {
        this.getName().delete();
        this.getExpansion().delete();
        PDOMMacroParameter param = this.getFirstParameter();
        if (param != null) {
            param.delete();
        }
        this.pdom.getDB().free(this.record);
    }

    public IString getName() throws CoreException {
        Database db = this.pdom.getDB();
        int rec = db.getInt(this.record + 0);
        return db.getString(rec);
    }

    public IString getExpansion() throws CoreException {
        Database db = this.pdom.getDB();
        int rec = db.getInt(this.record + 8);
        return db.getString(rec);
    }

    public PDOMMacro getNextMacro() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 12);
        return rec != 0 ? new PDOMMacro(this.pdom, rec) : null;
    }

    public void setNextMacro(PDOMMacro macro) throws CoreException {
        this.setNextMacro(macro != null ? macro.getRecord() : 0);
    }

    public void setNextMacro(int rec) throws CoreException {
        this.pdom.getDB().putInt(this.record + 12, rec);
    }

    public PDOMMacroParameter getFirstParameter() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 4);
        return rec != 0 ? new PDOMMacroParameter(this.pdom, rec) : null;
    }

    private char[] getMacroExpansion() {
        try {
            return this.getExpansion().getChars();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[]{' '};
        }
    }

    public IMacro getMacro() throws CoreException {
        char[] name = this.getName().getChars();
        PDOMMacroParameter param = this.getFirstParameter();
        if (param != null) {
            ArrayList<char[]> paramList = new ArrayList<char[]>();
            while (param != null) {
                paramList.add(param.getName().getChars());
                param = param.getNextParameter();
            }
            char[][] params = (char[][])paramList.toArray((T[])new char[paramList.size()][]);
            return new FunctionStylePDOMMacro(name, params);
        }
        return new ObjectStylePDOMMacro(name);
    }

    private class FunctionStylePDOMMacro
    extends FunctionStyleMacro {
        public FunctionStylePDOMMacro(char[] name, char[][] arglist) {
            super(name, null, arglist);
        }

        public char[] getExpansion() {
            return PDOMMacro.this.getMacroExpansion();
        }
    }

    private class ObjectStylePDOMMacro
    extends ObjectStyleMacro {
        public ObjectStylePDOMMacro(char[] name) {
            super(name, null);
        }

        public char[] getExpansion() {
            return PDOMMacro.this.getMacroExpansion();
        }
    }
}

