/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.FindBindingsInBTree;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPNamespace
extends PDOMBinding
implements ICPPNamespace,
ICPPNamespaceScope {
    private static final int INDEX_OFFSET = 24;
    protected static final int RECORD_SIZE = 28;

    public PDOMCPPNamespace(PDOM pdom, PDOMNode parent, IASTName name) throws CoreException {
        super(pdom, parent, name);
    }

    public PDOMCPPNamespace(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 28;
    }

    public int getNodeType() {
        return 8;
    }

    public BTree getIndex() throws CoreException {
        return new BTree(this.pdom.getDB(), this.record + 24);
    }

    public void accept(final IPDOMVisitor visitor) throws CoreException {
        super.accept(visitor);
        this.getIndex().accept(new IBTreeVisitor(){

            public int compare(int record) throws CoreException {
                return 1;
            }

            public boolean visit(int record) throws CoreException {
                PDOMBinding binding = PDOMCPPNamespace.this.pdom.getBinding(record);
                if (binding != null) {
                    if (visitor.visit(binding)) {
                        binding.accept(visitor);
                    }
                    visitor.leave(binding);
                }
                return true;
            }
        });
    }

    public void addChild(PDOMNamedNode child) throws CoreException {
        this.getIndex().insert(child.getRecord(), child.getIndexComparator());
    }

    public String[] getQualifiedName() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public char[][] getQualifiedNameCharArray() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isGloballyQualified() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IBinding[] getMemberBindings() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public ICPPNamespaceScope getNamespaceScope() throws DOMException {
        return this;
    }

    public void addUsingDirective(IASTNode directive) throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IASTNode[] getUsingDirectives() throws DOMException {
        return new IASTNode[0];
    }

    public void addBinding(IBinding binding) throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public void addName(IASTName name) throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IBinding[] find(String name) throws DOMException {
        try {
            FindBindingsInBTree visitor = new FindBindingsInBTree(this.pdom, name.toCharArray());
            this.getIndex().accept(visitor);
            return visitor.getBinding();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IBinding[0];
        }
    }

    public void flushCache() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public IBinding getBinding(IASTName name, boolean resolve) throws DOMException {
        try {
            if (name instanceof ICPPASTQualifiedName) {
                IASTName lastName = ((ICPPASTQualifiedName)name).getLastName();
                return lastName != null ? lastName.resolveBinding() : null;
            }
            IASTNode parent = name.getParent();
            if (parent instanceof ICPPASTQualifiedName) {
                IASTName[] names = ((ICPPASTQualifiedName)parent).getNames();
                if (name == names[names.length - 1]) {
                    parent = parent.getParent();
                } else {
                    IASTName nsname = null;
                    int i = 0;
                    while (i < names.length - 2) {
                        if (name != names[i]) {
                            nsname = names[i];
                        }
                        ++i;
                    }
                    if (nsname != null && !this.equals(this.pdom.resolveBinding(nsname))) {
                        return null;
                    }
                    FindBindingsInBTree visitor = new FindBindingsInBTree(this.pdom, name.toCharArray(), new int[]{5, 8, 4, 3});
                    this.getIndex().accept(visitor);
                    IBinding[] bindings = visitor.getBinding();
                    return bindings.length > 0 ? bindings[0] : null;
                }
            }
            if (parent instanceof IASTIdExpression) {
                IASTNode eParent = parent.getParent();
                if (eParent instanceof IASTFunctionCallExpression) {
                    FindBindingsInBTree visitor = new FindBindingsInBTree(this.pdom, name.toCharArray(), 4);
                    this.getIndex().accept(visitor);
                    IBinding[] bindings = visitor.getBinding();
                    return bindings.length > 0 ? bindings[0] : null;
                }
                FindBindingsInBTree visitor = new FindBindingsInBTree(this.pdom, name.toCharArray(), name.getParent() instanceof ICPPASTQualifiedName && ((ICPPASTQualifiedName)name.getParent()).getLastName() != name ? 8 : 3);
                this.getIndex().accept(visitor);
                IBinding[] bindings = visitor.getBinding();
                return bindings.length > 0 ? bindings[0] : null;
            }
            if (parent instanceof IASTNamedTypeSpecifier) {
                FindBindingsInBTree visitor = new FindBindingsInBTree(this.pdom, name.toCharArray(), 5);
                this.getIndex().accept(visitor);
                IBinding[] bindings = visitor.getBinding();
                return bindings.length > 0 ? bindings[0] : null;
            }
            return null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public IScope getParent() throws DOMException {
        return null;
    }

    public IASTNode getPhysicalNode() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IASTName getScopeName() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isFullyCached() throws DOMException {
        return true;
    }

    public void removeBinding(IBinding binding) throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public void setFullyCached(boolean b) throws DOMException {
        throw new PDOMNotImplementedError();
    }
}

