/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.AR;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.CygPath;
import org.eclipse.cdt.utils.ICygwinToolsFactroy;
import org.eclipse.cdt.utils.NM;
import org.eclipse.cdt.utils.Objdump;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.PE;
import org.eclipse.cdt.utils.coff.parser.CygwinSymbol;
import org.eclipse.cdt.utils.coff.parser.PEBinaryObject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CygwinPEBinaryObject
extends PEBinaryObject {
    private Addr2line autoDisposeAddr2line;
    private Addr2line symbolLoadingAddr2line;
    private CygPath symbolLoadingCygPath;
    private CPPFilt symbolLoadingCPPFilt;
    long starttime;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public CygwinPEBinaryObject(IBinaryParser parser, IPath path, AR.ARHeader header) {
        super(parser, path, header);
    }

    public CygwinPEBinaryObject(IBinaryParser parser, IPath path, int type) {
        super(parser, path, type);
    }

    public Addr2line getAddr2line(boolean autodisposing) {
        if (!autodisposing) {
            return this.getAddr2line();
        }
        if (this.autoDisposeAddr2line == null) {
            this.autoDisposeAddr2line = this.getAddr2line();
            if (this.autoDisposeAddr2line != null) {
                this.starttime = System.currentTimeMillis();
                Runnable worker = new Runnable(){

                    public void run() {
                        long diff = System.currentTimeMillis() - CygwinPEBinaryObject.this.starttime;
                        while (diff < 10000L) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException) {
                                break;
                            }
                            diff = System.currentTimeMillis() - CygwinPEBinaryObject.this.starttime;
                        }
                        CygwinPEBinaryObject.this.stopAddr2Line();
                    }
                };
                new Thread(worker, "Addr2line Reaper").start();
            }
        } else {
            this.starttime = System.currentTimeMillis();
        }
        return this.autoDisposeAddr2line;
    }

    synchronized void stopAddr2Line() {
        if (this.autoDisposeAddr2line != null) {
            this.autoDisposeAddr2line.dispose();
        }
        this.autoDisposeAddr2line = null;
    }

    private Addr2line getAddr2line() {
        ICygwinToolsFactroy factory;
        IBinaryParser iBinaryParser = this.getBinaryParser();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.utils.ICygwinToolsFactroy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((factory = (ICygwinToolsFactroy)iBinaryParser.getAdapter(clazz)) != null) {
            return factory.getAddr2line(this.getPath());
        }
        return null;
    }

    protected CPPFilt getCPPFilt() {
        ICygwinToolsFactroy factory;
        IBinaryParser iBinaryParser = this.getBinaryParser();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.utils.ICygwinToolsFactroy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((factory = (ICygwinToolsFactroy)iBinaryParser.getAdapter(clazz)) != null) {
            return factory.getCPPFilt();
        }
        return null;
    }

    protected Objdump getObjdump() {
        ICygwinToolsFactroy factory;
        IBinaryParser iBinaryParser = this.getBinaryParser();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.utils.ICygwinToolsFactroy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((factory = (ICygwinToolsFactroy)iBinaryParser.getAdapter(clazz)) != null) {
            return factory.getObjdump(this.getPath());
        }
        return null;
    }

    protected CygPath getCygPath() {
        ICygwinToolsFactroy factory;
        IBinaryParser iBinaryParser = this.getBinaryParser();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.utils.ICygwinToolsFactroy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((factory = (ICygwinToolsFactroy)iBinaryParser.getAdapter(clazz)) != null) {
            return factory.getCygPath();
        }
        return null;
    }

    protected NM getNM() {
        ICygwinToolsFactroy factory;
        IBinaryParser iBinaryParser = this.getBinaryParser();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.utils.ICygwinToolsFactroy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((factory = (ICygwinToolsFactroy)iBinaryParser.getAdapter(clazz)) != null) {
            return factory.getNM(this.getPath());
        }
        return null;
    }

    public InputStream getContents() throws IOException {
        InputStream stream = null;
        Objdump objdump = this.getObjdump();
        if (objdump != null) {
            try {
                byte[] contents = objdump.getOutput();
                stream = new ByteArrayInputStream(contents);
            }
            catch (IOException iOException) {}
        }
        if (stream == null) {
            stream = super.getContents();
        }
        return stream;
    }

    protected void loadSymbols(PE pe) throws IOException {
        this.symbolLoadingAddr2line = this.getAddr2line(false);
        this.symbolLoadingCPPFilt = this.getCPPFilt();
        this.symbolLoadingCygPath = this.getCygPath();
        ArrayList list = new ArrayList();
        super.loadSymbols(pe, list);
        NM nm = this.getNM();
        if (nm != null) {
            NM.AddressNamePair[] pairs = nm.getBSSSymbols();
            int i = 0;
            while (i < pairs.length) {
                this.addSymbol(pairs[i], list, 2);
                ++i;
            }
            pairs = nm.getDataSymbols();
            i = 0;
            while (i < pairs.length) {
                this.addSymbol(pairs[i], list, 2);
                ++i;
            }
        }
        this.symbols = list.toArray(this.NO_SYMBOLS);
        Arrays.sort(this.symbols);
        list.clear();
        if (this.symbolLoadingAddr2line != null) {
            this.symbolLoadingAddr2line.dispose();
            this.symbolLoadingAddr2line = null;
        }
        if (this.symbolLoadingCPPFilt != null) {
            this.symbolLoadingCPPFilt.dispose();
            this.symbolLoadingCPPFilt = null;
        }
        if (this.symbolLoadingCygPath != null) {
            this.symbolLoadingCygPath.dispose();
            this.symbolLoadingCygPath = null;
        }
    }

    private void addSymbol(NM.AddressNamePair p, List list, int type) {
        String name = p.name;
        if (name != null && name.length() > 0 && CConventions.isValidIdentifier(name)) {
            Addr32 addr = new Addr32(p.address);
            int size = 4;
            if (this.symbolLoadingCPPFilt != null) {
                try {
                    name = this.symbolLoadingCPPFilt.getFunction(name);
                }
                catch (IOException iOException) {
                    this.symbolLoadingCPPFilt.dispose();
                    this.symbolLoadingCPPFilt = null;
                }
            }
            if (this.symbolLoadingAddr2line != null) {
                try {
                    String filename = this.symbolLoadingAddr2line.getFileName(addr);
                    if (filename != null && filename.equals("??")) {
                        filename = null;
                    }
                    if (filename != null) {
                        try {
                            if (this.symbolLoadingCygPath != null) {
                                filename = this.symbolLoadingCygPath.getFileName(filename);
                            }
                        }
                        catch (IOException iOException) {
                            this.symbolLoadingCygPath.dispose();
                            this.symbolLoadingCygPath = null;
                        }
                    }
                    Path file = filename != null ? new Path(filename) : Path.EMPTY;
                    int startLine = this.symbolLoadingAddr2line.getLineNumber(addr);
                    int endLine = this.symbolLoadingAddr2line.getLineNumber(addr.add(size - 1));
                    list.add(new CygwinSymbol(this, name, type, (IAddress)addr, (long)size, (IPath)file, startLine, endLine));
                }
                catch (IOException iOException) {
                    this.symbolLoadingAddr2line.dispose();
                    this.symbolLoadingAddr2line = null;
                }
            }
        }
    }

    protected void addSymbols(Coff.Symbol[] peSyms, byte[] table, List list) {
        int i = 0;
        while (i < peSyms.length) {
            String name;
            if ((peSyms[i].isFunction() || peSyms[i].isPointer() || peSyms[i].isArray()) && (name = peSyms[i].getName(table)) != null && name.trim().length() != 0 && Character.isJavaIdentifierStart(name.charAt(0))) {
                int type = peSyms[i].isFunction() ? 1 : 2;
                Addr32 addr = new Addr32(peSyms[i].n_value);
                int size = 4;
                if (this.symbolLoadingCPPFilt != null) {
                    try {
                        name = this.symbolLoadingCPPFilt.getFunction(name);
                    }
                    catch (IOException iOException) {
                        this.symbolLoadingCPPFilt.dispose();
                        this.symbolLoadingCPPFilt = null;
                    }
                }
                if (this.symbolLoadingAddr2line != null) {
                    try {
                        String filename = this.symbolLoadingAddr2line.getFileName(addr);
                        if (filename != null && filename.equals("??")) {
                            filename = null;
                        }
                        if (filename != null) {
                            try {
                                if (this.symbolLoadingCygPath != null) {
                                    filename = this.symbolLoadingCygPath.getFileName(filename);
                                }
                            }
                            catch (IOException iOException) {
                                this.symbolLoadingCygPath.dispose();
                                this.symbolLoadingCygPath = null;
                            }
                        }
                        Path file = filename != null ? new Path(filename) : Path.EMPTY;
                        int startLine = this.symbolLoadingAddr2line.getLineNumber(addr);
                        int endLine = this.symbolLoadingAddr2line.getLineNumber(addr.add(size - 1));
                        list.add(new CygwinSymbol(this, name, type, (IAddress)addr, (long)size, (IPath)file, startLine, endLine));
                    }
                    catch (IOException iOException) {
                        this.symbolLoadingAddr2line.dispose();
                        this.symbolLoadingAddr2line = null;
                        list.add(new CygwinSymbol(this, name, type, (IAddress)addr, (long)size));
                    }
                } else {
                    list.add(new CygwinSymbol(this, name, type, (IAddress)addr, (long)size));
                }
            }
            ++i;
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.cdt.utils.Addr2line");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.getAddr2line(false);
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.cdt.utils.CPPFilt");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return this.getCPPFilt();
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.cdt.utils.CygPath");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz3) {
            return this.getCygPath();
        }
        return super.getAdapter(adapter);
    }
}

