/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.io.OutputStream;
import org.eclipse.cdt.managedbuilder.buildmodel.BuildDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildCommand;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildStep;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.CommandBuilder;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DbgUtil;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.GenDirInfo;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IBuildModelBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class StepBuilder
implements IBuildModelBuilder {
    private IBuildStep fStep;
    private IPath fCWD;
    private GenDirInfo fDirs;
    private boolean fResumeOnErrs;
    private int fNumCommands = -1;
    private CommandBuilder[] fCommandBuilders;

    public StepBuilder(IBuildStep step) {
        this(step, null);
    }

    public StepBuilder(IBuildStep step, IPath cwd) {
        this(step, cwd, true, null);
    }

    public StepBuilder(IBuildStep step, IPath cwd, boolean resumeOnErrs, GenDirInfo dirs) {
        this.fStep = step;
        this.fCWD = cwd;
        this.fDirs = dirs;
        this.fResumeOnErrs = resumeOnErrs;
        if (this.fDirs == null) {
            this.fDirs = new GenDirInfo(this.fStep.getBuildDescription().getConfiguration());
        }
        if (this.fCWD == null) {
            this.fCWD = this.fStep.getBuildDescription().getDefaultBuildDirLocation();
        }
    }

    public int build(OutputStream out, OutputStream err, IProgressMonitor monitor) {
        monitor.beginTask("", this.getNumCommands());
        monitor.subTask("");
        int status = 0;
        CommandBuilder[] bs = this.getCommandBuilders();
        if (bs.length > 0) {
            this.createOutDirs((IProgressMonitor)new NullProgressMonitor());
            int i = 0;
            while (i < bs.length && status != -3 && (this.fResumeOnErrs || status == 0)) {
                CommandBuilder builder = bs[i];
                switch (builder.build(out, err, (IProgressMonitor)new SubProgressMonitor(monitor, builder.getNumCommands()))) {
                    case 0: {
                        break;
                    }
                    case -3: {
                        status = -3;
                    }
                    case -1: {
                        if (status == -2) break;
                        status = -1;
                        break;
                    }
                    default: {
                        status = -2;
                    }
                }
                ++i;
            }
            status = this.postProcess(status, (IProgressMonitor)new NullProgressMonitor());
        }
        monitor.done();
        return status;
    }

    protected int postProcess(int status, IProgressMonitor monitor) {
        if (status != -2) {
            this.refreshOutputs(monitor);
        }
        switch (status) {
            case 0: {
                break;
            }
            default: {
                this.cleanOutputs(monitor);
            }
        }
        return status;
    }

    protected void refreshOutputs(IProgressMonitor monitor) {
        if (this.fStep == this.fStep.getBuildDescription().getInputStep()) {
            return;
        }
        IBuildResource[] rcs = this.fStep.getOutputResources();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < rcs.length) {
            block5: {
                IPath path = rcs[i].getFullPath();
                if (path != null) {
                    IFile file = root.getFile(path);
                    try {
                        file.refreshLocal(0, monitor);
                    }
                    catch (CoreException e) {
                        if (!DbgUtil.DEBUG) break block5;
                        DbgUtil.trace("failed to refresh resource " + file.getFullPath() + ", error: " + e.getLocalizedMessage());
                    }
                }
            }
            ++i;
        }
    }

    protected void cleanOutputs(IProgressMonitor monitor) {
        if (this.fStep == this.fStep.getBuildDescription().getInputStep()) {
            return;
        }
        IBuildResource[] bRcs = this.fStep.getOutputResources();
        int i = 0;
        while (i < bRcs.length) {
            block5: {
                IResource rc = BuildDescriptionManager.findResourceForBuildResource(bRcs[i]);
                if (rc != null) {
                    try {
                        rc.delete(true, monitor);
                    }
                    catch (CoreException e) {
                        if (!DbgUtil.DEBUG) break block5;
                        DbgUtil.trace("failed to delete resource " + rc.getFullPath() + ", error: " + e.getLocalizedMessage());
                    }
                }
            }
            ++i;
        }
    }

    protected void createOutDirs(IProgressMonitor monitor) {
        IBuildResource[] rcs = this.fStep.getOutputResources();
        int i = 0;
        while (i < rcs.length) {
            this.fDirs.createDir(rcs[i], monitor);
            ++i;
        }
    }

    public int getNumCommands() {
        if (this.fNumCommands == -1) {
            CommandBuilder[] bs = this.getCommandBuilders();
            this.fNumCommands = 0;
            int i = 0;
            while (i < bs.length) {
                this.fNumCommands += bs[i].getNumCommands();
                ++i;
            }
        }
        return this.fNumCommands;
    }

    protected CommandBuilder[] getCommandBuilders() {
        if (this.fCommandBuilders == null) {
            IBuildCommand[] cmds = this.fStep.getCommands(this.fCWD, null, null, true);
            if (cmds == null) {
                this.fCommandBuilders = new CommandBuilder[0];
            } else {
                this.fCommandBuilders = new CommandBuilder[cmds.length];
                int i = 0;
                while (i < cmds.length) {
                    this.fCommandBuilders[i] = new CommandBuilder(cmds[i]);
                    ++i;
                }
            }
        }
        return this.fCommandBuilders;
    }
}

