/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PropertyManager {
    private static final String PROPS_PROPERTY = "properties";
    private static final QualifiedName propsSessionProperty = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "properties");
    private static final String NODE_NAME = "properties";
    private static PropertyManager fInstance;

    private PropertyManager() {
    }

    public static PropertyManager getInstance() {
        if (fInstance == null) {
            fInstance = new PropertyManager();
        }
        return fInstance;
    }

    protected void setProperty(IConfiguration cfg, IBuildObject bo, String prop, String value) {
        Properties props = this.getProperties(cfg, bo);
        if (props != null) {
            props.setProperty(prop, value);
        }
    }

    protected String getProperty(IConfiguration cfg, IBuildObject bo, String prop) {
        Properties props = this.getProperties(cfg, bo);
        if (props != null) {
            return props.getProperty(prop);
        }
        return null;
    }

    protected Properties getProperties(IConfiguration cfg, IBuildObject bo) {
        return this.loadProperties(cfg, bo);
    }

    protected Map getLoaddedData(IConfiguration cfg) {
        Map map = null;
        try {
            IProject proj = cfg.getOwner().getProject();
            map = (HashMap)proj.getSessionProperty(propsSessionProperty);
            if (map == null) {
                map = new HashMap();
                proj.setSessionProperty(propsSessionProperty, map);
            }
            map = (Map)map.get(cfg.getId());
        }
        catch (CoreException coreException) {}
        return map;
    }

    protected void clearLoaddedData(IConfiguration cfg) {
        IProject proj = cfg.getOwner().getProject();
        try {
            proj.setSessionProperty(propsSessionProperty, null);
        }
        catch (CoreException coreException) {}
    }

    protected Properties loadProperties(IConfiguration cfg, IBuildObject bo) {
        Map map = this.getData(cfg);
        return this.getPropsFromData(map, bo);
    }

    protected Properties getPropsFromData(Map data, IBuildObject bo) {
        Object oVal = data.get(bo.getId());
        Properties props = null;
        if (oVal instanceof String) {
            props = this.stringToProps((String)oVal);
            data.put(bo.getId(), props);
        } else if (oVal instanceof Properties) {
            props = (Properties)oVal;
        }
        if (props == null) {
            props = new Properties();
            data.put(bo.getId(), props);
        }
        return props;
    }

    protected void storeData(IConfiguration cfg) {
        Map map = this.getLoaddedData(cfg);
        if (map != null) {
            this.storeData(cfg, map);
        }
    }

    protected Properties mapToProps(Map map) {
        Properties props = null;
        if (map != null && map.size() > 0) {
            props = new Properties();
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = null;
                Object oVal = entry.getValue();
                if (oVal instanceof Properties) {
                    value = this.propsToString((Properties)oVal);
                } else if (oVal instanceof String) {
                    value = (String)oVal;
                }
                if (key == null || value == null) continue;
                props.setProperty(key, value);
            }
        }
        return props;
    }

    protected String propsToString(Properties props) {
        if (props == null || props.size() == 0) {
            return null;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            props.store(stream, "");
        }
        catch (IOException iOException) {}
        byte[] bytes = stream.toByteArray();
        String value = null;
        try {
            value = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            value = new String(bytes);
        }
        return value;
    }

    protected Properties stringToProps(String str) {
        Properties props = null;
        if (str != null) {
            byte[] bytes;
            props = new Properties();
            try {
                bytes = str.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = str.getBytes();
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            try {
                props.load(stream);
            }
            catch (IOException iOException) {
                props = null;
            }
        }
        return props;
    }

    protected void storeData(IConfiguration cfg, Map map) {
        String str = null;
        Properties props = this.mapToProps(map);
        str = this.propsToString(props);
        this.storeString(cfg, str);
    }

    protected void storeString(IConfiguration cfg, String str) {
        Preferences prefs = this.getNode(cfg.getManagedProject());
        if (prefs != null) {
            if (str != null) {
                prefs.put(cfg.getId(), str);
            } else {
                prefs.remove(cfg.getId());
            }
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    protected String loadString(IConfiguration cfg) {
        String str = null;
        Preferences prefs = this.getNode(cfg.getManagedProject());
        if (prefs != null) {
            str = prefs.get(cfg.getId(), null);
        }
        return str;
    }

    protected Preferences getNode(IManagedProject mProject) {
        return this.getInstNode(mProject);
    }

    protected Preferences getProjNode(IManagedProject mProject) {
        IProject project = mProject.getOwner().getProject();
        if (project == null || !project.exists() || !project.isOpen()) {
            return null;
        }
        IEclipsePreferences prefs = new ProjectScope(project).getNode(ManagedBuilderCorePlugin.getUniqueIdentifier());
        if (prefs != null) {
            return prefs.node("properties");
        }
        return null;
    }

    protected Preferences getInstNode(IManagedProject mProject) {
        IEclipsePreferences prefs = new InstanceScope().getNode(ManagedBuilderCorePlugin.getUniqueIdentifier());
        if (prefs != null && (prefs = prefs.node("properties")) != null) {
            prefs = prefs.node(mProject.getId());
        }
        return prefs;
    }

    protected Map getData(IConfiguration cfg) {
        Map map = this.getLoaddedData(cfg);
        if (map == null) {
            map = this.loadData(cfg);
            this.setLoaddedData(cfg, map);
        }
        return map;
    }

    protected Map loadData(IConfiguration cfg) {
        HashMap map = null;
        String str = this.loadString(cfg);
        Properties props = this.stringToProps(str);
        map = this.propsToMap(props);
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    protected Map propsToMap(Properties props) {
        if (props != null) {
            return new HashMap<Object, Object>(props);
        }
        return null;
    }

    protected void setLoaddedData(IConfiguration cfg, Map data) {
        try {
            IProject proj = cfg.getOwner().getProject();
            HashMap<String, Map> map = (HashMap<String, Map>)proj.getSessionProperty(propsSessionProperty);
            if (map == null) {
                map = new HashMap<String, Map>();
                proj.setSessionProperty(propsSessionProperty, map);
            }
            map.put(cfg.getId(), data);
        }
        catch (CoreException coreException) {}
    }

    public void setProperty(IConfiguration cfg, String key, String value) {
        this.setProperty(cfg, cfg, key, value);
    }

    public void setProperty(IResourceConfiguration rcCfg, String key, String value) {
        this.setProperty(rcCfg.getParent(), rcCfg, key, value);
    }

    public void setProperty(IToolChain tc, String key, String value) {
        this.setProperty(tc.getParent(), tc, key, value);
    }

    public void setProperty(ITool tool, String key, String value) {
        this.setProperty(this.getConfiguration(tool), tool, key, value);
    }

    public void setProperty(IBuilder builder, String key, String value) {
        this.setProperty(this.getConfiguration(builder), builder, key, value);
    }

    public String getProperty(IConfiguration cfg, String key) {
        return this.getProperty(cfg, cfg, key);
    }

    public String getProperty(IResourceConfiguration rcCfg, String key) {
        return this.getProperty(rcCfg.getParent(), rcCfg, key);
    }

    public String getProperty(IToolChain tc, String key) {
        return this.getProperty(tc.getParent(), tc, key);
    }

    public String getProperty(ITool tool, String key) {
        return this.getProperty(this.getConfiguration(tool), tool, key);
    }

    public String getProperty(IBuilder builder, String key) {
        return this.getProperty(this.getConfiguration(builder), builder, key);
    }

    public void clearProperties(IManagedProject mProject) {
        if (mProject == null) {
            return;
        }
        IConfiguration[] cfgs = mProject.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            this.clearLoaddedData(cfgs[i]);
            ++i;
        }
        Preferences prefs = this.getNode(mProject);
        if (prefs != null) {
            try {
                Preferences parent = prefs.parent();
                prefs.removeNode();
                if (parent != null) {
                    parent.flush();
                }
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    public void clearProperties(IConfiguration cfg) {
        this.clearLoaddedData(cfg);
        this.storeData(cfg, null);
    }

    private IConfiguration getConfiguration(IBuilder builder) {
        IToolChain tc = builder.getParent();
        if (tc != null) {
            return tc.getParent();
        }
        return null;
    }

    private IConfiguration getConfiguration(ITool tool) {
        IBuildObject p = tool.getParent();
        IConfiguration cfg = null;
        if (p instanceof IToolChain) {
            cfg = ((IToolChain)p).getParent();
        } else if (p instanceof IResourceConfiguration) {
            cfg = ((IResourceConfiguration)p).getParent();
        }
        return cfg;
    }

    public void serialize(IConfiguration cfg) {
        if (cfg.isTemporary()) {
            return;
        }
        this.storeData(cfg);
    }

    public void serialize() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)projects[i], false);
            if (info != null && info.isValid() && info.getManagedProject() != null) {
                IConfiguration[] cfgs = info.getManagedProject().getConfigurations();
                int j = 0;
                while (j < cfgs.length) {
                    this.serialize(cfgs[j]);
                    ++j;
                }
            }
            ++i;
        }
    }
}

