/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.enablement;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.enablement.IBooleanExpression;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.MacroResolver;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;

public class CheckOptionExpression
implements IBooleanExpression {
    public static final String NAME = "checkOption";
    public static final String OPTION_ID = "optionId";
    public static final String HOLDER_ID = "holderId";
    public static final String VALUE = "value";
    public static final String IS_REGEX = "isRegex";
    public static final String OTHER_OPTION_ID = "otherOptionId";
    public static final String OTHER_HOLDER_ID = "otherHolderId";
    public static final String YES = "yes";
    public static final String TRUE = "true";
    private String fOptionId;
    private String fHolderId;
    private String fValue;
    private boolean fIsRegex;
    private String fOtherOptionId;
    private String fOtherHolderId;

    public CheckOptionExpression(IManagedConfigElement element) {
        this.fOptionId = element.getAttribute(OPTION_ID);
        this.fHolderId = element.getAttribute(HOLDER_ID);
        this.fValue = element.getAttribute(VALUE);
        this.fIsRegex = this.getBooleanValue(element.getAttribute(IS_REGEX));
        this.fOtherOptionId = element.getAttribute(OTHER_OPTION_ID);
        this.fOtherHolderId = element.getAttribute(OTHER_HOLDER_ID);
    }

    public boolean evaluate(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        boolean result = false;
        IBuildObject[] ho = this.getHolderAndOption(this.fOptionId, this.fHolderId, configuration, holder, option);
        if (ho != null) {
            if (this.fValue != null) {
                result = this.evaluate((IOption)ho[1], (IHoldsOptions)ho[0], this.fValue);
            } else {
                IBuildObject[] otherHo = this.getHolderAndOption(this.fOtherOptionId, this.fOtherHolderId, configuration, holder, option);
                if (otherHo != null) {
                    result = this.evaluate((IOption)ho[1], (IHoldsOptions)ho[0], (IOption)otherHo[1], (IHoldsOptions)otherHo[0]);
                }
            }
        }
        return result;
    }

    public boolean evaluate(IOption option, IHoldsOptions holder, String value) {
        IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
        String delimiter = ManagedBuildManager.getEnvironmentVariableProvider().getDefaultDelimiter();
        String inexVal = " ";
        try {
            String resolvedValue = provider.resolveValue(value, inexVal, delimiter, 2, new OptionContextData(option, holder));
            switch (option.getValueType()) {
                case 1: 
                case 2: {
                    String stringValue = option.getStringValue();
                    stringValue = provider.resolveValue(stringValue, inexVal, delimiter, 2, new OptionContextData(option, holder));
                    if (this.fIsRegex) {
                        Pattern pattern = Pattern.compile(resolvedValue);
                        Matcher matcher = pattern.matcher(stringValue);
                        return matcher.matches();
                    }
                    return stringValue.equals(resolvedValue);
                }
                case 0: {
                    return option.getBooleanValue() == this.getBooleanValue(resolvedValue);
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    List list = (List)option.getValue();
                    String listValue = provider.convertStringListToString(list.toArray(new String[list.size()]), delimiter);
                    listValue = provider.resolveValue(listValue, inexVal, delimiter, 2, new OptionContextData(option, holder));
                    if (this.fIsRegex) {
                        Pattern pattern = Pattern.compile(resolvedValue);
                        Matcher matcher = pattern.matcher(listValue);
                        return matcher.matches();
                    }
                    return listValue.equals(resolvedValue);
                }
            }
        }
        catch (BuildException buildException) {
        }
        catch (BuildMacroException buildMacroException) {}
        return false;
    }

    protected boolean getBooleanValue(String value) {
        if (TRUE.equalsIgnoreCase(value)) {
            return true;
        }
        return YES.equalsIgnoreCase(value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean evaluate(IOption option, IHoldsOptions holder, IOption otherOption, IHoldsOptions otherHolder) {
        try {
            if (option.getValueType() != otherOption.getValueType()) {
                return false;
            }
            BuildMacroProvider provider = (BuildMacroProvider)ManagedBuildManager.getBuildMacroProvider();
            String delimiter = ManagedBuildManager.getEnvironmentVariableProvider().getDefaultDelimiter();
            String inexVal = " ";
            switch (option.getValueType()) {
                case 1: 
                case 2: {
                    String stringValue = option.getStringValue();
                    stringValue = provider.resolveValue(stringValue, inexVal, delimiter, 2, new OptionContextData(option, holder));
                    String str = otherOption.getStringValue();
                    str = provider.resolveValue(str, inexVal, delimiter, 2, new OptionContextData(otherOption, otherHolder));
                    return stringValue.equals(str);
                }
                case 0: {
                    if (option.getBooleanValue() != otherOption.getBooleanValue()) return false;
                    return true;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    List list = (List)option.getValue();
                    String[] listValue = list.toArray(new String[list.size()]);
                    list = (List)otherOption.getValue();
                    String[] otherValue = list.toArray(new String[list.size()]);
                    IMacroContextInfo info = provider.getMacroContextInfo(2, new OptionContextData(option, holder));
                    IMacroSubstitutor subst = provider.getMacroSubstitutor(info, inexVal, delimiter);
                    listValue = MacroResolver.resolveStringListValues(listValue, subst, false);
                    info = provider.getMacroContextInfo(2, new OptionContextData(otherOption, otherHolder));
                    subst = provider.getMacroSubstitutor(info, inexVal, delimiter);
                    otherValue = MacroResolver.resolveStringListValues(otherValue, subst, false);
                    if (listValue.length != otherValue.length) return false;
                    int i = 0;
                    while (i < listValue.length) {
                        if (!listValue[i].equals(otherValue[i])) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            return false;
        }
        catch (BuildException buildException) {
            return false;
        }
        catch (BuildMacroException buildMacroException) {
            return false;
        }
        catch (ClassCastException classCastException) {}
        return false;
    }

    protected IBuildObject[] getHolderAndOption(String optionId, String holderId, IBuildObject configuration, IHoldsOptions holder, IOption option) {
        IBuildObject[] result = null;
        if (optionId == null) {
            result = new IBuildObject[]{holder, option};
        } else {
            IOption opt;
            IHoldsOptions hld = null;
            hld = holderId == null ? holder : this.getHolder(holderId, configuration);
            if (hld != null && (opt = this.getOption(optionId, hld)) != null) {
                result = new IBuildObject[]{hld, opt};
            }
        }
        return result;
    }

    protected IOption getOption(String optionId, IHoldsOptions holder) {
        return holder.getOptionBySuperClassId(optionId);
    }

    protected IHoldsOptions getHolder(String id, IBuildObject cfg) {
        IHoldsOptions holder;
        block6: {
            block7: {
                holder = null;
                if (!(cfg instanceof IResourceConfiguration)) break block7;
                ITool[] holders = ((IResourceConfiguration)cfg).getTools();
                int i = 0;
                while (i < holders.length) {
                    if (this.isHolder(id, holders[i])) {
                        holder = holders[i];
                        break block6;
                    }
                    ++i;
                }
                break block6;
            }
            if (!(cfg instanceof IConfiguration)) break block6;
            IToolChain tc = ((IConfiguration)cfg).getToolChain();
            if (this.isHolder(id, tc)) {
                holder = tc;
            } else {
                ITool[] holders = tc.getTools();
                int i = 0;
                while (i < holders.length) {
                    if (this.isHolder(id, holders[i])) {
                        holder = holders[i];
                        break;
                    }
                    ++i;
                }
            }
        }
        return holder;
    }

    protected boolean isHolder(String id, IHoldsOptions holder) {
        do {
            if (!id.equals(holder.getId())) continue;
            return true;
        } while ((holder = holder instanceof IToolChain ? ((IToolChain)holder).getSuperClass() : (holder instanceof ITool ? ((ITool)holder).getSuperClass() : null)) != null);
        return false;
    }
}

