/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.macros;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacro;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.DefaultMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.MacroResolver;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroStatus;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroSupplier;

public class DefaultMacroSubstitutor
implements IMacroSubstitutor {
    private static final Object UNDEFINED_MACRO_VALUE = new Object();
    private static final String EMPTY_STRING = "";
    private IMacroContextInfo fContextInfo;
    private String fInexistentMacroValue;
    private String fListDelimiter;
    private String fIncorrectlyReferencedMacroValue;
    private Map fDelimiterMap;
    private Map fResolvedMacros = new HashMap();
    private HashSet fMacrosUnderResolution = new HashSet();
    private Stack fMacroDescriptors = new Stack();

    public DefaultMacroSubstitutor(int contextType, Object contextData, String inexistentMacroValue, String listDelimiter, Map delimiterMap, String incorrectlyReferencedMacroValue) {
        this(new DefaultMacroContextInfo(contextType, contextData), inexistentMacroValue, listDelimiter, delimiterMap, incorrectlyReferencedMacroValue);
    }

    public DefaultMacroSubstitutor(int contextType, Object contextData, String inexistentMacroValue, String listDelimiter) {
        this(new DefaultMacroContextInfo(contextType, contextData), inexistentMacroValue, listDelimiter);
    }

    public DefaultMacroSubstitutor(IMacroContextInfo contextInfo, String inexistentMacroValue, String listDelimiter) {
        this(contextInfo, inexistentMacroValue, listDelimiter, null, inexistentMacroValue);
    }

    public DefaultMacroSubstitutor(IMacroContextInfo contextInfo, String inexistentMacroValue, String listDelimiter, Map delimiterMap, String incorrectlyReferencedMacroValue) {
        this.fContextInfo = contextInfo;
        this.fInexistentMacroValue = inexistentMacroValue;
        this.fListDelimiter = listDelimiter;
        this.fDelimiterMap = delimiterMap;
        this.fIncorrectlyReferencedMacroValue = incorrectlyReferencedMacroValue;
    }

    protected String resolveToString(MacroDescriptor des) throws BuildMacroException {
        String result = null;
        ResolvedMacro value = this.getResolvedMacro(des);
        result = value.getStringValue();
        return result;
    }

    protected String[] resolveToStringList(MacroDescriptor des) throws BuildMacroException {
        String[] result = null;
        ResolvedMacro value = this.getResolvedMacro(des);
        result = value.getStringListValue();
        return result;
    }

    public String resolveToString(String macroName) throws BuildMacroException {
        return this.resolveToString(new MacroDescriptor(macroName, this.fContextInfo));
    }

    public void setMacroContextInfo(IMacroContextInfo info) throws BuildMacroException {
        if (this.checkEqual(this.fContextInfo, info)) {
            return;
        }
        this.reset();
        this.fContextInfo = info;
    }

    public void setMacroContextInfo(int contextType, Object contextData) throws BuildMacroException {
        this.setMacroContextInfo(this.getMacroContextInfo(contextType, contextData));
    }

    protected IMacroContextInfo getMacroContextInfo(int contextType, Object contextData) {
        return ((BuildMacroProvider)ManagedBuildManager.getBuildMacroProvider()).getMacroContextInfo(contextType, contextData);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResolvedMacro getResolvedMacro(MacroDescriptor des) throws BuildMacroException {
        ResolvedMacro value = this.checkResolvingMacro(des);
        if (value != null) return value;
        try {
            value = this.resolveMacro(des);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (value != null) {
                this.addResolvedMacro(des, value);
                throw throwable;
            }
            value = new ResolvedMacro(des.fName, this.fInexistentMacroValue, false);
            this.addResolvedMacro(des, value);
            throw throwable;
        }
        {
            Object var3_5 = null;
            if (value != null) {
                this.addResolvedMacro(des, value);
                return value;
            }
            value = new ResolvedMacro(des.fName, this.fInexistentMacroValue, false);
            this.addResolvedMacro(des, value);
            return value;
        }
    }

    protected ResolvedMacro resolveMacro(MacroDescriptor des) throws BuildMacroException {
        return des.fMacro != null ? this.resolveMacro(des.fMacro) : this.resolveMacro(des.fName);
    }

    public String[] resolveToStringList(String macroName) throws BuildMacroException {
        return this.resolveToStringList(new MacroDescriptor(macroName, this.fContextInfo));
    }

    protected ResolvedMacro resolveMacro(String macroName) throws BuildMacroException {
        return this.resolveMacro(BuildMacroProvider.getMacro(macroName, this.fContextInfo, true));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResolvedMacro resolveParentMacro(MacroDescriptor macroDes) throws BuildMacroException {
        MacroDescriptor des = macroDes.getNext();
        ResolvedMacro macro = null;
        if (des == null) return macro;
        try {
            this.fMacroDescriptors.push(des);
            macro = this.resolveMacro(des.getMacro());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.fMacroDescriptors.pop();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.fMacroDescriptors.pop();
        }
        return macro;
    }

    protected ResolvedMacro resolveMacro(IBuildMacro macro) throws BuildMacroException {
        if (macro == null) {
            return null;
        }
        String macroName = macro.getName();
        DefaultMacroSubstitutor substitutor = this;
        ResolvedMacro resolvedMacro = null;
        if (MacroResolver.isStringListMacro(macro.getMacroValueType())) {
            String[] result = null;
            String[] unresolvedValues = macro.getStringListValue();
            if (unresolvedValues == null || unresolvedValues.length == 0) {
                resolvedMacro = new ResolvedMacro(macroName, EMPTY_STRING);
            } else {
                String[][] resolvedValues = new String[unresolvedValues.length][];
                int i = 0;
                while (i < unresolvedValues.length) {
                    try {
                        resolvedValues[i] = MacroResolver.resolveToStringList(unresolvedValues[i], substitutor);
                    }
                    catch (BuildMacroException e) {
                        IBuildMacroStatus status;
                        IBuildMacroStatus[] statuses = e.getMacroStatuses();
                        if (statuses != null && statuses.length == 1 && (status = statuses[0]).getMacroName() == null) {
                            e = new BuildMacroException(status.getCode(), macro.getName(), status.getExpression(), status.getReferencedMacroName(), this.fContextInfo != null ? this.fContextInfo.getContextType() : 0, this.fContextInfo != null ? this.fContextInfo.getContextData() : null);
                        }
                        throw e;
                    }
                    ++i;
                }
                if (resolvedValues.length == 1) {
                    result = resolvedValues[0];
                } else {
                    ArrayList<String> list = new ArrayList<String>();
                    int i2 = 0;
                    while (i2 < resolvedValues.length) {
                        list.addAll(Arrays.asList(resolvedValues[i2]));
                        ++i2;
                    }
                    result = list.toArray(new String[list.size()]);
                }
                resolvedMacro = new ResolvedMacro(macroName, result);
            }
        } else {
            try {
                resolvedMacro = new ResolvedMacro(macroName, MacroResolver.resolveToString(macro.getStringValue(), substitutor));
            }
            catch (BuildMacroException e) {
                IBuildMacroStatus status;
                IBuildMacroStatus[] statuses = e.getMacroStatuses();
                if (statuses != null && statuses.length == 1 && (status = statuses[0]).getMacroName() == null) {
                    e = new BuildMacroException(status.getCode(), macro.getName(), status.getExpression(), status.getReferencedMacroName(), this.fContextInfo != null ? this.fContextInfo.getContextType() : 0, this.fContextInfo != null ? this.fContextInfo.getContextData() : null);
                }
                throw e;
            }
        }
        return resolvedMacro;
    }

    private ResolvedMacro checkResolvingMacro(MacroDescriptor des) throws BuildMacroException {
        String name = des.fName;
        ResolvedMacro value = (ResolvedMacro)this.fResolvedMacros.get(name);
        if (value == null) {
            if (this.fMacrosUnderResolution.add(name)) {
                this.fMacroDescriptors.push(des);
            } else {
                MacroDescriptor last = (MacroDescriptor)this.fMacroDescriptors.lastElement();
                if (last != null && last.fName.equals(name)) {
                    value = this.resolveParentMacro(last);
                    if (value == null) {
                        value = new ResolvedMacro(name, EMPTY_STRING, false);
                    }
                } else if (this.fIncorrectlyReferencedMacroValue != null) {
                    value = new ResolvedMacro(name, this.fIncorrectlyReferencedMacroValue, false);
                } else {
                    throw new BuildMacroException(3, null, null, name, this.fContextInfo != null ? this.fContextInfo.getContextType() : 0, this.fContextInfo != null ? this.fContextInfo.getContextData() : null);
                }
            }
        }
        return value;
    }

    protected void addResolvedMacro(MacroDescriptor des, ResolvedMacro value) {
        String name = des.fName;
        this.fMacrosUnderResolution.remove(name);
        this.fResolvedMacros.put(name, value);
        this.fMacroDescriptors.pop();
    }

    protected ResolvedMacro removeResolvedMacro(String name) {
        return (ResolvedMacro)this.fResolvedMacros.remove(name);
    }

    public IMacroContextInfo getMacroContextInfo() {
        return this.fContextInfo;
    }

    public void reset() throws BuildMacroException {
        if (this.fMacrosUnderResolution.size() != 0) {
            throw new BuildMacroException(-1, null, null, null, 0, null);
        }
        this.fResolvedMacros.clear();
    }

    public Map getDelimiterMap() {
        return this.fDelimiterMap;
    }

    public void setDelimiterMap(Map delimiterMap) throws BuildMacroException {
        if (this.checkEqual(this.fDelimiterMap, delimiterMap)) {
            return;
        }
        this.reset();
        this.fDelimiterMap = delimiterMap;
    }

    public String getIncorrectlyReferencedMacroValue() {
        return this.fIncorrectlyReferencedMacroValue;
    }

    protected boolean checkEqual(Object o1, Object o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    public void setIncorrectlyReferencedMacroValue(String incorrectlyReferencedMacroValue) throws BuildMacroException {
        if (this.checkEqual(this.fIncorrectlyReferencedMacroValue, incorrectlyReferencedMacroValue)) {
            return;
        }
        this.reset();
        this.fIncorrectlyReferencedMacroValue = incorrectlyReferencedMacroValue;
    }

    public String getInexistentMacroValue() {
        return this.fInexistentMacroValue;
    }

    public void setInexistentMacroValue(String inexistentMacroValue) throws BuildMacroException {
        if (this.checkEqual(this.fInexistentMacroValue, inexistentMacroValue)) {
            return;
        }
        this.reset();
        this.fInexistentMacroValue = inexistentMacroValue;
    }

    public String getListDelimiter() {
        return this.fListDelimiter;
    }

    public void setListDelimiter(String listDelimiter) throws BuildMacroException {
        if (this.checkEqual(this.fListDelimiter, listDelimiter)) {
            return;
        }
        this.reset();
        this.fListDelimiter = listDelimiter;
    }

    protected class MacroDescriptor {
        private String fName;
        private IMacroContextInfo fInfo;
        private IBuildMacro fMacro;
        private boolean fInitialized;
        private int fSupplierNum;
        private int fEnvSupplierNum;

        public MacroDescriptor(String name, IMacroContextInfo info) {
            this.fName = name;
            this.fInfo = info;
        }

        public MacroDescriptor(String name, IMacroContextInfo info, int supplierNum) {
            this.fName = name;
            this.fInfo = info;
            this.fSupplierNum = supplierNum;
        }

        public MacroDescriptor(IBuildMacro macro, IMacroContextInfo info, int supplierNum) {
            this.fName = macro.getName();
            this.fInfo = info;
            this.fMacro = macro;
            this.fSupplierNum = supplierNum;
            this.fInitialized = true;
        }

        public MacroDescriptor getNext() {
            return new MacroDescriptor(this.fName, this.getInfo(), this.getSupplierNum() + 1);
        }

        public int getSupplierNum() {
            this.init();
            return this.fSupplierNum;
        }

        private void init() {
            if (this.fInitialized) {
                return;
            }
            this.fInitialized = true;
            while (this.fInfo != null) {
                IBuildMacroSupplier[] suppliers = this.fInfo.getSuppliers();
                if (suppliers != null) {
                    while (this.fSupplierNum < suppliers.length) {
                        this.fMacro = suppliers[this.fSupplierNum].getMacro(this.fName, this.fInfo.getContextType(), this.fInfo.getContextData());
                        if (this.fMacro != null) {
                            return;
                        }
                        ++this.fSupplierNum;
                    }
                }
                this.fSupplierNum = 0;
                this.fInfo = this.fInfo.getNext();
            }
        }

        protected IMacroContextInfo getInfo() {
            this.init();
            return this.fInfo;
        }

        public IBuildMacro getMacro() {
            this.init();
            return this.fMacro;
        }
    }

    protected class ResolvedMacro
    extends BuildMacro {
        private boolean fIsDefined;
        private boolean fIsList;

        public ResolvedMacro(String name) {
            super(name, 1, (String)null);
            this.fIsDefined = false;
        }

        public ResolvedMacro(String name, String value, boolean isDefined) {
            super(name, 1, value);
            this.fIsDefined = isDefined;
            this.fIsList = false;
        }

        public ResolvedMacro(String name, String value) {
            super(name, 1, value);
            this.fIsDefined = true;
            this.fIsList = false;
        }

        public ResolvedMacro(String name, String[] value) {
            super(name, 2, value);
            this.fIsDefined = true;
            this.fIsList = true;
        }

        public String getStringValue() throws BuildMacroException {
            if (this.fIsList && this.fStringValue == null) {
                this.fStringValue = this.stringListToString(this.fStringListValue);
            }
            return this.fStringValue;
        }

        public String[] getStringListValue() throws BuildMacroException {
            if (!this.fIsList && this.fStringListValue == null) {
                this.fStringListValue = new String[]{this.fStringValue};
            }
            return this.fStringListValue;
        }

        protected String getDelimiter() {
            Object delimiter;
            if (DefaultMacroSubstitutor.this.fDelimiterMap != null && (delimiter = DefaultMacroSubstitutor.this.fDelimiterMap.get(this.fName)) instanceof String) {
                return (String)delimiter;
            }
            return DefaultMacroSubstitutor.this.fListDelimiter;
        }

        protected String stringListToString(String[] values) throws BuildMacroException {
            String result = null;
            if (values == null) {
                result = null;
            } else if (values.length == 0) {
                result = DefaultMacroSubstitutor.EMPTY_STRING;
            } else if (values.length == 1) {
                result = values[0];
            } else {
                String delimiter = this.getDelimiter();
                if (delimiter != null) {
                    StringBuffer buffer = new StringBuffer();
                    int i = 0;
                    while (i < values.length) {
                        buffer.append(values[i]);
                        if (i < values.length - 1) {
                            buffer.append(delimiter);
                        }
                        ++i;
                    }
                    result = buffer.toString();
                } else {
                    throw new BuildMacroException(4, null, null, this.fName, DefaultMacroSubstitutor.this.fContextInfo != null ? DefaultMacroSubstitutor.this.fContextInfo.getContextType() : 0, DefaultMacroSubstitutor.this.fContextInfo != null ? DefaultMacroSubstitutor.this.fContextInfo.getContextData() : null);
                }
            }
            return result;
        }

        public boolean isList() {
            return this.fIsList;
        }

        public boolean isDefined() {
            return this.fIsDefined;
        }
    }
}

