/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.CategoryLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;

public abstract class AbstractCategoryItemRenderer
extends AbstractRenderer
implements CategoryItemRenderer,
Cloneable,
Serializable {
    private CategoryPlot plot;
    private CategoryLabelGenerator labelGenerator = null;
    private ObjectList labelGeneratorList = new ObjectList();
    private CategoryLabelGenerator baseLabelGenerator;
    private CategoryToolTipGenerator toolTipGenerator = null;
    private ObjectList toolTipGeneratorList = new ObjectList();
    private CategoryToolTipGenerator baseToolTipGenerator;
    private CategoryURLGenerator itemURLGenerator = null;
    private ObjectList itemURLGeneratorList = new ObjectList();
    private CategoryURLGenerator baseItemURLGenerator;
    private transient int rowCount;
    private transient int columnCount;

    protected AbstractCategoryItemRenderer() {
    }

    public CategoryPlot getPlot() {
        return this.plot;
    }

    public void setPlot(CategoryPlot plot) {
        if (plot == null) {
            throw new IllegalArgumentException("Null 'plot' argument.");
        }
        this.plot = plot;
    }

    public CategoryLabelGenerator getLabelGenerator(int row, int column) {
        return this.getSeriesLabelGenerator(row);
    }

    public CategoryLabelGenerator getSeriesLabelGenerator(int series) {
        if (this.labelGenerator != null) {
            return this.labelGenerator;
        }
        CategoryLabelGenerator generator = (CategoryLabelGenerator)this.labelGeneratorList.get(series);
        if (generator == null) {
            generator = this.baseLabelGenerator;
        }
        return generator;
    }

    public void setLabelGenerator(CategoryLabelGenerator generator) {
        this.labelGenerator = generator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setSeriesLabelGenerator(int series, CategoryLabelGenerator generator) {
        this.labelGeneratorList.set(series, (Object)generator);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public CategoryLabelGenerator getBaseLabelGenerator() {
        return this.baseLabelGenerator;
    }

    public void setBaseLabelGenerator(CategoryLabelGenerator generator) {
        this.baseLabelGenerator = generator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public CategoryToolTipGenerator getToolTipGenerator(int row, int column) {
        CategoryToolTipGenerator result = null;
        if (this.toolTipGenerator != null) {
            result = this.toolTipGenerator;
        } else {
            result = this.getSeriesToolTipGenerator(row);
            if (result == null) {
                result = this.baseToolTipGenerator;
            }
        }
        return result;
    }

    public CategoryToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(CategoryToolTipGenerator generator) {
        this.toolTipGenerator = generator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public CategoryToolTipGenerator getSeriesToolTipGenerator(int series) {
        return (CategoryToolTipGenerator)this.toolTipGeneratorList.get(series);
    }

    public void setSeriesToolTipGenerator(int series, CategoryToolTipGenerator generator) {
        this.toolTipGeneratorList.set(series, (Object)generator);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public CategoryToolTipGenerator getBaseToolTipGenerator() {
        return this.baseToolTipGenerator;
    }

    public void setBaseToolTipGenerator(CategoryToolTipGenerator generator) {
        this.baseToolTipGenerator = generator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public CategoryURLGenerator getItemURLGenerator(int row, int column) {
        return this.getSeriesItemURLGenerator(row);
    }

    public CategoryURLGenerator getSeriesItemURLGenerator(int series) {
        if (this.itemURLGenerator != null) {
            return this.itemURLGenerator;
        }
        CategoryURLGenerator generator = (CategoryURLGenerator)this.itemURLGeneratorList.get(series);
        if (generator == null) {
            generator = this.baseItemURLGenerator;
        }
        return generator;
    }

    public void setItemURLGenerator(CategoryURLGenerator generator) {
        this.itemURLGenerator = generator;
    }

    public void setSeriesItemURLGenerator(int series, CategoryURLGenerator generator) {
        this.itemURLGeneratorList.set(series, (Object)generator);
    }

    public CategoryURLGenerator getBaseItemURLGenerator() {
        return this.baseItemURLGenerator;
    }

    public void setBaseItemURLGenerator(CategoryURLGenerator generator) {
        this.baseItemURLGenerator = generator;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public CategoryItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, int rendererIndex, PlotRenderingInfo info) {
        this.setPlot(plot);
        CategoryDataset data = plot.getDataset(rendererIndex);
        if (data != null) {
            this.rowCount = data.getRowCount();
            this.columnCount = data.getColumnCount();
        } else {
            this.rowCount = 0;
            this.columnCount = 0;
        }
        return new CategoryItemRendererState(info);
    }

    public Range getRangeExtent(CategoryDataset dataset) {
        return DatasetUtilities.findRangeExtent(dataset);
    }

    public void drawBackground(Graphics2D g2, CategoryPlot plot, Rectangle2D dataArea) {
        plot.drawBackground(g2, dataArea);
    }

    public void drawOutline(Graphics2D g2, CategoryPlot plot, Rectangle2D dataArea) {
        plot.drawOutline(g2, dataArea);
    }

    public void drawDomainGridline(Graphics2D g2, CategoryPlot plot, Rectangle2D dataArea, double value) {
        Line2D.Double line = null;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            line = new Line2D.Double(dataArea.getMinX(), value, dataArea.getMaxX(), value);
        } else if (orientation == PlotOrientation.VERTICAL) {
            line = new Line2D.Double(value, dataArea.getMinY(), value, dataArea.getMaxY());
        }
        Paint paint = plot.getDomainGridlinePaint();
        if (paint == null) {
            paint = CategoryPlot.DEFAULT_GRIDLINE_PAINT;
        }
        g2.setPaint(paint);
        Stroke stroke = plot.getDomainGridlineStroke();
        if (stroke == null) {
            stroke = CategoryPlot.DEFAULT_GRIDLINE_STROKE;
        }
        g2.setStroke(stroke);
        g2.draw(line);
    }

    public void drawRangeGridline(Graphics2D g2, CategoryPlot plot, ValueAxis axis, Rectangle2D dataArea, double value) {
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        double v = axis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
        Line2D.Double line = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            line = new Line2D.Double(v, dataArea.getMinY(), v, dataArea.getMaxY());
        } else if (orientation == PlotOrientation.VERTICAL) {
            line = new Line2D.Double(dataArea.getMinX(), v, dataArea.getMaxX(), v);
        }
        Paint paint = plot.getRangeGridlinePaint();
        if (paint == null) {
            paint = CategoryPlot.DEFAULT_GRIDLINE_PAINT;
        }
        g2.setPaint(paint);
        Stroke stroke = plot.getRangeGridlineStroke();
        if (stroke == null) {
            stroke = CategoryPlot.DEFAULT_GRIDLINE_STROKE;
        }
        g2.setStroke(stroke);
        g2.draw(line);
    }

    public void drawRangeMarker(Graphics2D g2, CategoryPlot plot, ValueAxis axis, Marker marker, Rectangle2D dataArea) {
        if (marker instanceof ValueMarker) {
            ValueMarker vm = (ValueMarker)marker;
            double value = vm.getValue();
            Range range = axis.getRange();
            if (!range.contains(value)) {
                return;
            }
            PlotOrientation orientation = plot.getOrientation();
            double v = axis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
            Line2D.Double line = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                line = new Line2D.Double(v, dataArea.getMinY(), v, dataArea.getMaxY());
            } else if (orientation == PlotOrientation.VERTICAL) {
                line = new Line2D.Double(dataArea.getMinX(), v, dataArea.getMaxX(), v);
            }
            g2.setPaint(marker.getPaint());
            g2.setStroke(marker.getStroke());
            g2.draw(line);
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                Font labelFont = marker.getLabelFont();
                g2.setFont(labelFont);
                g2.setPaint(marker.getLabelPaint());
                double[] coordinates = this.calculateRangeMarkerTextAnchorPoint(g2, orientation, dataArea, line.getBounds2D(), marker.getLabelOffset(), anchor);
                TextUtilities.drawAlignedString((String)label, (Graphics2D)g2, (float)((float)coordinates[0]), (float)((float)coordinates[1]), (TextAnchor)TextAnchor.CENTER);
            }
        } else if (marker instanceof IntervalMarker) {
            IntervalMarker im = (IntervalMarker)marker;
            double start = im.getStartValue();
            double end = im.getEndValue();
            Range range = axis.getRange();
            if (!range.intersects(start, end)) {
                return;
            }
            start = range.constrain(start);
            end = range.constrain(end);
            double v0 = axis.valueToJava2D(start, dataArea, plot.getRangeAxisEdge());
            double v1 = axis.valueToJava2D(end, dataArea, plot.getRangeAxisEdge());
            PlotOrientation orientation = plot.getOrientation();
            Rectangle2D.Double rect = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                rect = new Rectangle2D.Double(v0, dataArea.getMinY(), v1 - v0, dataArea.getHeight());
            } else if (orientation == PlotOrientation.VERTICAL) {
                rect = new Rectangle2D.Double(dataArea.getMinX(), Math.min(v0, v1), dataArea.getWidth(), Math.abs(v1 - v0));
            }
            Paint p = marker.getPaint();
            if (p instanceof GradientPaint) {
                GradientPaint gp = (GradientPaint)p;
                GradientPaintTransformer t = im.getGradientPaintTransformer();
                if (t != null) {
                    gp = t.transform(gp, (Shape)rect);
                }
                g2.setPaint(gp);
            } else {
                g2.setPaint(p);
            }
            g2.fill(rect);
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                Font labelFont = marker.getLabelFont();
                g2.setFont(labelFont);
                g2.setPaint(marker.getLabelPaint());
                double[] coordinates = this.calculateRangeMarkerTextAnchorPoint(g2, orientation, dataArea, rect, marker.getLabelOffset(), anchor);
                TextUtilities.drawAlignedString((String)label, (Graphics2D)g2, (float)((float)coordinates[0]), (float)((float)coordinates[1]), (TextAnchor)marker.getLabelTextAnchor());
            }
        }
    }

    private double[] calculateRangeMarkerTextAnchorPoint(Graphics2D g2, PlotOrientation orientation, Rectangle2D dataArea, Rectangle2D markerArea, RectangleInsets markerOffset, RectangleAnchor anchor) {
        double[] result = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            Rectangle2D anchorRect = markerOffset.createOutsetRectangle(markerArea, true, false);
            result = RectangleAnchor.coordinates((Rectangle2D)anchorRect, (RectangleAnchor)anchor);
        } else if (orientation == PlotOrientation.VERTICAL) {
            Rectangle2D anchorRect = markerOffset.createOutsetRectangle(markerArea, false, true);
            result = RectangleAnchor.coordinates((Rectangle2D)anchorRect, (RectangleAnchor)anchor);
        }
        return result;
    }

    public LegendItem getLegendItem(int datasetIndex, int series) {
        String label;
        CategoryPlot cp = this.getPlot();
        if (cp == null) {
            return null;
        }
        CategoryDataset dataset = cp.getDataset(datasetIndex);
        String description = label = dataset.getRowKey(series).toString();
        Shape shape = this.getSeriesShape(series);
        Paint paint = this.getSeriesPaint(series);
        Paint outlinePaint = this.getSeriesOutlinePaint(series);
        Stroke stroke = this.getSeriesStroke(series);
        return new LegendItem(label, description, shape, true, paint, stroke, outlinePaint, stroke);
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof AbstractCategoryItemRenderer) {
            AbstractCategoryItemRenderer r = (AbstractCategoryItemRenderer)obj;
            boolean b0 = ObjectUtils.equal((Object)this.labelGenerator, (Object)r.labelGenerator);
            boolean b1 = ObjectUtils.equal((Object)this.labelGeneratorList, (Object)r.labelGeneratorList);
            boolean b2 = ObjectUtils.equal((Object)this.baseLabelGenerator, (Object)r.baseLabelGenerator);
            boolean b3 = ObjectUtils.equal((Object)this.toolTipGenerator, (Object)r.toolTipGenerator);
            boolean b4 = ObjectUtils.equal((Object)this.toolTipGeneratorList, (Object)r.toolTipGeneratorList);
            boolean b5 = ObjectUtils.equal((Object)this.baseToolTipGenerator, (Object)r.baseToolTipGenerator);
            boolean b6 = ObjectUtils.equal((Object)this.itemURLGenerator, (Object)r.itemURLGenerator);
            boolean b7 = ObjectUtils.equal((Object)this.itemURLGeneratorList, (Object)r.itemURLGeneratorList);
            boolean b8 = ObjectUtils.equal((Object)this.baseItemURLGenerator, (Object)r.baseItemURLGenerator);
            result = b0 && b1 && b2 && b3 && b4 && b5 && b6 && b7 && b8;
        }
        return result;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier result = null;
        CategoryPlot cp = this.getPlot();
        if (cp != null) {
            result = cp.getDrawingSupplier();
        }
        return result;
    }

    protected void drawItemLabel(Graphics2D g2, PlotOrientation orientation, CategoryDataset dataset, int row, int column, double x, double y, boolean negative) {
        CategoryLabelGenerator generator = this.getLabelGenerator(row, column);
        if (generator != null) {
            Font labelFont = this.getItemLabelFont(row, column);
            Paint paint = this.getItemLabelPaint(row, column);
            g2.setFont(labelFont);
            g2.setPaint(paint);
            String label = generator.generateLabel(dataset, row, column);
            ItemLabelPosition position = null;
            position = !negative ? this.getPositiveItemLabelPosition(row, column) : this.getNegativeItemLabelPosition(row, column);
            Point2D anchorPoint = this.calculateLabelAnchorPoint(position.getItemLabelAnchor(), x, y, orientation);
            RefineryUtilities.drawRotatedString((String)label, (Graphics2D)g2, (float)((float)anchorPoint.getX()), (float)((float)anchorPoint.getY()), (TextAnchor)position.getTextAnchor(), (TextAnchor)position.getRotationAnchor(), (double)position.getAngle());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PublicCloneable pc;
        AbstractCategoryItemRenderer clone = (AbstractCategoryItemRenderer)super.clone();
        if (this.labelGenerator != null) {
            if (this.labelGenerator instanceof PublicCloneable) {
                pc = (PublicCloneable)this.labelGenerator;
                clone.labelGenerator = (CategoryLabelGenerator)pc.clone();
            } else {
                throw new CloneNotSupportedException("ItemLabelGenerator not cloneable.");
            }
        }
        if (this.labelGeneratorList != null) {
            clone.labelGeneratorList = (ObjectList)this.labelGeneratorList.clone();
        }
        if (this.baseLabelGenerator != null) {
            if (this.baseLabelGenerator instanceof PublicCloneable) {
                pc = (PublicCloneable)this.baseLabelGenerator;
                clone.baseLabelGenerator = (CategoryLabelGenerator)pc.clone();
            } else {
                throw new CloneNotSupportedException("ItemLabelGenerator not cloneable.");
            }
        }
        if (this.toolTipGenerator != null) {
            if (this.toolTipGenerator instanceof PublicCloneable) {
                pc = (PublicCloneable)this.toolTipGenerator;
                clone.toolTipGenerator = (CategoryToolTipGenerator)pc.clone();
            } else {
                throw new CloneNotSupportedException("Tool tip generator not cloneable.");
            }
        }
        if (this.toolTipGeneratorList != null) {
            clone.toolTipGeneratorList = (ObjectList)this.toolTipGeneratorList.clone();
        }
        if (this.baseToolTipGenerator != null) {
            if (this.baseToolTipGenerator instanceof PublicCloneable) {
                pc = (PublicCloneable)this.baseToolTipGenerator;
                clone.baseToolTipGenerator = (CategoryToolTipGenerator)pc.clone();
            } else {
                throw new CloneNotSupportedException("Base tool tip generator not cloneable.");
            }
        }
        if (this.itemURLGenerator != null) {
            if (this.itemURLGenerator instanceof PublicCloneable) {
                pc = (PublicCloneable)this.itemURLGenerator;
                clone.itemURLGenerator = (CategoryURLGenerator)pc.clone();
            } else {
                throw new CloneNotSupportedException("Item URL generator not cloneable.");
            }
        }
        if (this.itemURLGeneratorList != null) {
            clone.itemURLGeneratorList = (ObjectList)this.itemURLGeneratorList.clone();
        }
        if (this.baseItemURLGenerator != null) {
            if (this.baseItemURLGenerator instanceof PublicCloneable) {
                pc = (PublicCloneable)this.baseItemURLGenerator;
                clone.baseItemURLGenerator = (CategoryURLGenerator)pc.clone();
            } else {
                throw new CloneNotSupportedException("Base item URL generator not cloneable.");
            }
        }
        return clone;
    }

    protected CategoryAxis getDomainAxis(CategoryPlot plot, int index) {
        CategoryAxis result = plot.getDomainAxis(index);
        if (result == null) {
            result = plot.getDomainAxis();
        }
        return result;
    }

    protected ValueAxis getRangeAxis(CategoryPlot plot, int index) {
        ValueAxis result = plot.getRangeAxis(index);
        if (result == null) {
            result = plot.getRangeAxis();
        }
        return result;
    }
}

