/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.IOException;
import java.io.InputStream;

public final class LineInputStream
extends InputStream
implements CharSequence {
    protected InputStream in;
    protected String filename;
    protected int startOffset;
    protected int startLineNum;
    protected int restartLine = -1;
    protected int restartOffset = -1;
    protected char[] currentLine = new char[4096];
    protected int currentLineLength = -1;
    protected int offsetInCurrentLine = -1;
    protected int offsetInStream = 0;
    protected int lineNumInCurrentStream = 0;
    protected boolean atEOF = false;

    public LineInputStream(InputStream readFrom, String filename) throws IOException {
        this(readFrom, filename, 0, 0);
    }

    public LineInputStream(InputStream readFrom, String filename, int startOffset, int startLineNum) throws IOException {
        this.in = readFrom;
        this.filename = filename;
        this.startOffset = startOffset;
        this.startLineNum = startLineNum;
        this.advanceToNextLine();
    }

    public String currentLine() throws IOException {
        this.ensureLineLoaded();
        return this.atEOF() ? null : String.valueOf(this.currentLine, this.offsetInCurrentLine, this.currentLineLength - this.offsetInCurrentLine);
    }

    protected boolean atBOL() throws IOException {
        this.ensureLineLoaded();
        return this.offsetInCurrentLine == 0;
    }

    public boolean atEOF() throws IOException {
        return this.offsetInCurrentLine >= this.currentLineLength && this.atEOF;
    }

    protected void ensureLineLoaded() throws IOException {
        if (!this.atEOF && this.offsetInCurrentLine >= this.currentLineLength) {
            this.advanceToNextLine();
        }
    }

    protected int peek() throws IOException {
        return this.atEOF() ? -1 : this.currentLine[this.offsetInCurrentLine];
    }

    public void advanceToNextLine() throws IOException {
        this.offsetInCurrentLine = 0;
        this.offsetInStream += Math.max(this.currentLineLength - this.offsetInCurrentLine, 0);
        if (this.atEOF) {
            return;
        }
        ++this.lineNumInCurrentStream;
        if (this.currentLineLength < 0) {
            this.currentLineLength = 0;
        } else {
            this.currentLine[0] = this.currentLine[this.currentLineLength];
            this.currentLineLength = 1;
        }
        int c = this.in.read();
        while (c != -1 && c != 10 && c != 13) {
            this.append(c);
            c = this.in.read();
        }
        if (c == -1) {
            this.append(10);
        }
        while (c != -1 && (c == 10 || c == 13)) {
            this.append(c);
            c = this.in.read();
        }
        if (c == -1) {
            this.atEOF = true;
        }
        this.currentLine[this.currentLineLength] = (char)c;
    }

    private void append(int c) {
        if (this.currentLineLength + 1 == this.currentLine.length) {
            char[] newCurrentLine = new char[this.currentLine.length * 2];
            System.arraycopy(this.currentLine, 0, newCurrentLine, 0, this.currentLine.length);
            this.currentLine = newCurrentLine;
        }
        this.currentLine[this.currentLineLength++] = (char)c;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getFileOffsetOfNextRead() {
        return this.offsetInStream;
    }

    public int getFileLineOfNextRead() {
        return this.lineNumInCurrentStream;
    }

    public int getTotalOffsetOfNextRead() {
        return this.startOffset + this.offsetInStream;
    }

    public int getTotalLineOfNextRead() {
        return this.startLineNum + this.lineNumInCurrentStream;
    }

    public int getStartLine() {
        return this.startLineNum;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getRestartLine() {
        return this.restartLine;
    }

    public void setRestartLine(int restartLine) {
        this.restartLine = restartLine;
    }

    public int getRestartOffset() {
        return this.restartOffset;
    }

    public void setRestartOffset(int restartOffset) {
        this.restartOffset = restartOffset;
    }

    public int read() throws IOException {
        this.ensureLineLoaded();
        int result = this.peek();
        if (result >= 0) {
            ++this.offsetInCurrentLine;
            ++this.offsetInStream;
        }
        return result;
    }

    public char charAt(int index) {
        return this.currentLine[this.offsetInCurrentLine + index];
    }

    public int length() {
        return this.currentLineLength - this.offsetInCurrentLine;
    }

    public CharSequence subSequence(int start, int end) {
        if (start < this.offsetInCurrentLine || end >= this.length()) {
            throw new IllegalArgumentException();
        }
        return new SubSequence(start, end);
    }

    private final class SubSequence
    implements CharSequence {
        private final int start;
        private final int end;

        private SubSequence(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public char charAt(int index) {
            return LineInputStream.this.currentLine[LineInputStream.this.offsetInCurrentLine + this.start];
        }

        public int length() {
            return this.end - this.start;
        }

        public CharSequence subSequence(int subseqStart, int subseqEnd) {
            return new SubSequence(this.start + subseqStart, this.start + subseqEnd);
        }

        public String toString() {
            return String.valueOf(LineInputStream.this.currentLine, this.start, this.end - this.start);
        }
    }
}

