/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

class OffsetLineReader {
    private BufferedReader bReader;
    private StringBuffer sBuf;
    private int lineNumber = 0;
    private int offset = 0;
    private int charBuf = -1;

    public OffsetLineReader(Reader reader) {
        this.bReader = new BufferedReader(reader);
        this.sBuf = new StringBuffer();
    }

    private int getNextChar() throws IOException {
        int c = this.bReader.read();
        if (c != -1) {
            ++this.offset;
        }
        return c;
    }

    public String readLine() throws IOException {
        if (this.charBuf < 0) {
            this.charBuf = this.getNextChar();
            if (this.charBuf < 0) {
                return null;
            }
        }
        this.sBuf.setLength(0);
        while (true) {
            if (this.charBuf == 10) {
                this.charBuf = this.getNextChar();
                ++this.lineNumber;
                break;
            }
            if (this.charBuf == 13) {
                this.charBuf = this.getNextChar();
                if (this.charBuf == 10) {
                    this.charBuf = this.getNextChar();
                }
                ++this.lineNumber;
                break;
            }
            if (this.charBuf == -1) break;
            this.sBuf.append((char)this.charBuf);
            this.charBuf = this.getNextChar();
        }
        return this.sBuf.toString();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getOffset() {
        if (this.charBuf < 0) {
            return this.offset;
        }
        return this.offset - 1;
    }
}

