/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.parser;

import java.util.LinkedList;
import org.eclipse.photran.internal.core.parser.Nonterminal;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.parser.Terminal;
import org.eclipse.photran.internal.core.parser.TerminalOrNonterminal;

public class ErrorRecovery {
    protected Parser parser;
    protected AbstractErrorProduction[] errorProductions;
    protected LinkedList recoveryList;

    public ErrorRecovery(Parser parserToRecover) {
        this.parser = parserToRecover;
        this.errorProductions = new AbstractErrorProduction[6];
        this.errorProductions[0] = new ErrorProduction0();
        this.errorProductions[1] = new ErrorProduction1();
        this.errorProductions[2] = new ErrorProduction2();
        this.errorProductions[3] = new ErrorProduction3();
        this.errorProductions[4] = new ErrorProduction4();
        this.errorProductions[5] = new ErrorProduction5();
    }

    boolean recover() throws Exception {
        this.recoveryList = new LinkedList();
        while (!this.parser.getSymbolStack().isEmpty()) {
            int errorProductionToUse = this.getRecoveryProductionForCurrentState();
            if (errorProductionToUse > -1) {
                return this.errorProductions[errorProductionToUse].attemptRecovery(this.parser, this.recoveryList);
            }
            TerminalOrNonterminal symOnTop = (TerminalOrNonterminal)this.parser.getSymbolStack().get(this.parser.getSymbolStack().size() - 1);
            int symsToPop = symOnTop.getNumberOfSymbolsOnValueStack();
            int i = 0;
            while (i < symsToPop) {
                this.recoveryList.add(0, this.parser.getValueStack().get(this.parser.getValueStack().size() - 1));
                this.parser.getValueStack().remove(this.parser.getValueStack().size() - 1);
                ++i;
            }
            this.parser.getStateStack().remove(this.parser.getStateStack().size() - 1);
            this.parser.getSymbolStack().remove(this.parser.getSymbolStack().size() - 1);
        }
        return false;
    }

    protected int getRecoveryProductionForCurrentState() {
        int i = 0;
        while (i < 6) {
            if (this.errorProductions[i].applies(this.parser)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private abstract class AbstractErrorProduction {
        private AbstractErrorProduction() {
        }

        public abstract boolean applies(Parser var1);

        public abstract boolean attemptRecovery(Parser var1, LinkedList var2) throws Exception;
    }

    private class ErrorProduction0
    extends AbstractErrorProduction {
        private ErrorProduction0() {
        }

        public boolean applies(Parser parser) {
            return parser.getSymbolStack().size() >= 1 && (TerminalOrNonterminal)parser.getSymbolStack().get(parser.getSymbolStack().size() - 1) == Terminal.TFormatTerminal.getInstance();
        }

        public boolean attemptRecovery(Parser parser, LinkedList recoveryList) throws Exception {
            while (parser.getLookaheadToken().getTerminal() != Terminal.T_EOS) {
                if (parser.getLookaheadToken().getTerminal() == Terminal.END_OF_INPUT) {
                    return false;
                }
                recoveryList.add(parser.getLookaheadToken());
                parser.readNextToken();
            }
            parser.getSymbolStack().add(Terminal.ERROR);
            parser.getValueStack().add(recoveryList);
            parser.getStateStack().add(new Integer(-999));
            parser.shiftAndGoToState(1124);
            return true;
        }
    }

    private class ErrorProduction1
    extends AbstractErrorProduction {
        private ErrorProduction1() {
        }

        public boolean applies(Parser parser) {
            return parser.getSymbolStack().size() >= 2 && (TerminalOrNonterminal)parser.getSymbolStack().get(parser.getSymbolStack().size() - 1) == Terminal.TFormatTerminal.getInstance() && (TerminalOrNonterminal)parser.getSymbolStack().get(parser.getSymbolStack().size() - 2) == Nonterminal.LblDefNonterminal.getInstance();
        }

        public boolean attemptRecovery(Parser parser, LinkedList recoveryList) throws Exception {
            while (parser.getLookaheadToken().getTerminal() != Terminal.T_EOS) {
                if (parser.getLookaheadToken().getTerminal() == Terminal.END_OF_INPUT) {
                    return false;
                }
                recoveryList.add(parser.getLookaheadToken());
                parser.readNextToken();
            }
            parser.getSymbolStack().add(Terminal.ERROR);
            parser.getValueStack().add(recoveryList);
            parser.getStateStack().add(new Integer(-999));
            parser.shiftAndGoToState(1508);
            return true;
        }
    }

    private class ErrorProduction2
    extends AbstractErrorProduction {
        private ErrorProduction2() {
        }

        public boolean applies(Parser parser) {
            return parser.getSymbolStack().size() >= 2 && (TerminalOrNonterminal)parser.getSymbolStack().get(parser.getSymbolStack().size() - 1) == Nonterminal.FunctionNameNonterminal.getInstance() && (TerminalOrNonterminal)parser.getSymbolStack().get(parser.getSymbolStack().size() - 2) == Nonterminal.FunctionPrefixNonterminal.getInstance();
        }

        public boolean attemptRecovery(Parser parser, LinkedList recoveryList) throws Exception {
            while (parser.getLookaheadToken().getTerminal() != Terminal.T_EOS) {
                if (parser.getLookaheadToken().getTerminal() == Terminal.END_OF_INPUT) {
                    return false;
                }
                recoveryList.add(parser.getLookaheadToken());
                parser.readNextToken();
            }
            parser.getSymbolStack().add(Terminal.ERROR);
            parser.getValueStack().add(recoveryList);
            parser.getStateStack().add(new Integer(-999));
            parser.shiftAndGoToState(1429);
            return true;
        }
    }

    private class ErrorProduction3
    extends AbstractErrorProduction {
        private ErrorProduction3() {
        }

        public boolean applies(Parser parser) {
            return parser.getSymbolStack().size() >= 3 && (TerminalOrNonterminal)parser.getSymbolStack().get(parser.getSymbolStack().size() - 1) == Nonterminal.FunctionNameNonterminal.getInstance() && (TerminalOrNonterminal)parser.getSymbolStack().get(parser.getSymbolStack().size() - 2) == Nonterminal.FunctionPrefixNonterminal.getInstance() && (TerminalOrNonterminal)parser.getSymbolStack().get(parser.getSymbolStack().size() - 3) == Nonterminal.LblDefNonterminal.getInstance();
        }

        public boolean attemptRecovery(Parser parser, LinkedList recoveryList) throws Exception {
            while (parser.getLookaheadToken().getTerminal() != Terminal.T_EOS) {
                if (parser.getLookaheadToken().getTerminal() == Terminal.END_OF_INPUT) {
                    return false;
                }
                recoveryList.add(parser.getLookaheadToken());
                parser.readNextToken();
            }
            parser.getSymbolStack().add(Terminal.ERROR);
            parser.getValueStack().add(recoveryList);
            parser.getStateStack().add(new Integer(-999));
            parser.shiftAndGoToState(2028);
            return true;
        }
    }

    private class ErrorProduction4
    extends AbstractErrorProduction {
        private ErrorProduction4() {
        }

        public boolean applies(Parser parser) {
            return parser.getSymbolStack().size() >= 2 && (TerminalOrNonterminal)parser.getSymbolStack().get(parser.getSymbolStack().size() - 1) == Nonterminal.SubroutineNameNonterminal.getInstance() && (TerminalOrNonterminal)parser.getSymbolStack().get(parser.getSymbolStack().size() - 2) == Nonterminal.SubroutinePrefixNonterminal.getInstance();
        }

        public boolean attemptRecovery(Parser parser, LinkedList recoveryList) throws Exception {
            while (parser.getLookaheadToken().getTerminal() != Terminal.T_EOS) {
                if (parser.getLookaheadToken().getTerminal() == Terminal.END_OF_INPUT) {
                    return false;
                }
                recoveryList.add(parser.getLookaheadToken());
                parser.readNextToken();
            }
            parser.getSymbolStack().add(Terminal.ERROR);
            parser.getValueStack().add(recoveryList);
            parser.getStateStack().add(new Integer(-999));
            parser.shiftAndGoToState(1619);
            return true;
        }
    }

    private class ErrorProduction5
    extends AbstractErrorProduction {
        private ErrorProduction5() {
        }

        public boolean applies(Parser parser) {
            return parser.getSymbolStack().size() >= 3 && (TerminalOrNonterminal)parser.getSymbolStack().get(parser.getSymbolStack().size() - 1) == Nonterminal.SubroutineNameNonterminal.getInstance() && (TerminalOrNonterminal)parser.getSymbolStack().get(parser.getSymbolStack().size() - 2) == Nonterminal.SubroutinePrefixNonterminal.getInstance() && (TerminalOrNonterminal)parser.getSymbolStack().get(parser.getSymbolStack().size() - 3) == Nonterminal.LblDefNonterminal.getInstance();
        }

        public boolean attemptRecovery(Parser parser, LinkedList recoveryList) throws Exception {
            while (parser.getLookaheadToken().getTerminal() != Terminal.T_EOS) {
                if (parser.getLookaheadToken().getTerminal() == Terminal.END_OF_INPUT) {
                    return false;
                }
                recoveryList.add(parser.getLookaheadToken());
                parser.readNextToken();
            }
            parser.getSymbolStack().add(Terminal.ERROR);
            parser.getValueStack().add(recoveryList);
            parser.getStateStack().add(new Integer(-999));
            parser.shiftAndGoToState(2036);
            return true;
        }
    }
}

