/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.errorparsers;

import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;

public class GFortranErrorParser
implements IErrorParser {
    String fileName = null;
    int lineNumber = -1;

    public boolean processLine(String line, ErrorParserManager eoParser) {
        return this.processLine(line, eoParser, 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processLine(String line, ErrorParserManager eoParser, int inheritedSeverity) {
        int firstColon;
        block22: {
            firstColon = line.indexOf(58);
            if (firstColon == 1) {
                try {
                    String os = System.getProperty("os.name");
                    if (os == null || !os.startsWith("Win")) break block22;
                    try {
                        if (Character.isLetter(line.charAt(0))) {
                            firstColon = line.indexOf(58, 2);
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                }
                catch (SecurityException securityException) {}
            }
        }
        if (firstColon == -1) return false;
        try {
            String tail;
            int q;
            int p;
            if (line.startsWith("In file ")) {
                this.fileName = line.substring(8, firstColon);
                String lineno = line.substring(firstColon + 1);
                try {
                    this.lineNumber = Integer.parseInt(lineno);
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    this.lineNumber = -1;
                    this.fileName = null;
                    return false;
                }
            }
            if (!line.startsWith("Error:")) {
                if (!line.startsWith("Fatal Error:")) return false;
            }
            String varName = null;
            String desc = line.substring(firstColon + 1).trim();
            int severity = this.extractSeverity("Error", inheritedSeverity);
            if (this.fileName == null) return false;
            if (this.lineNumber == -1) {
                return false;
            }
            if (!Path.EMPTY.isValidPath(this.fileName)) {
                return false;
            }
            IFile file = eoParser.findFileName(this.fileName);
            if (file != null) {
                if (eoParser.isConflictingName(this.fileName)) {
                    desc = "[Conflicting names: " + this.fileName + " ] " + desc;
                    file = null;
                }
            } else {
                Path path;
                file = eoParser.findFilePath(this.fileName);
                if (file == null && (path = new Path(this.fileName)).segmentCount() > 1) {
                    String name = path.lastSegment();
                    file = eoParser.findFileName(this.fileName);
                    if (file != null && eoParser.isConflictingName(this.fileName)) {
                        desc = "[Conflicting names: " + name + " ] " + desc;
                        file = null;
                    }
                }
            }
            if (file == null) {
                desc = String.valueOf(desc) + "[" + this.fileName + "]";
            }
            if ((p = desc.indexOf("Symbol '")) != -1) {
                varName = desc.substring(p + 8);
                varName = (p = varName.indexOf("'")) != -1 ? varName.substring(0, p) : null;
            }
            if ((p = desc.indexOf("at (")) != -1 && (q = (tail = desc.substring(p + 4)).indexOf(")")) != -1) {
                desc = String.valueOf(desc.substring(0, p)) + tail.substring(q + 1);
            }
            eoParser.generateMarker((IResource)file, this.lineNumber, desc, severity, varName);
            this.lineNumber = -1;
            this.fileName = null;
            return false;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        return false;
    }

    private int extractSeverity(String desc, int defaultSeverity) {
        int severity = defaultSeverity;
        if (desc.startsWith("warning") || desc.startsWith("Warning")) {
            severity = 1;
        }
        return severity;
    }
}

