/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.internal.envvar.BuildEnvVar;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvVarOperationProcessor;
import org.eclipse.cdt.managedbuilder.internal.ui.EnvironmentBlock;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewEnvVarDialog
extends StatusDialog {
    private static final String PREFIX = "NewEnvVarDialog";
    private static final String LABEL = "NewEnvVarDialog.label";
    private static final String NAME = "NewEnvVarDialog.label.name";
    private static final String VALUE = "NewEnvVarDialog.label.value";
    private static final String DELIMITER = "NewEnvVarDialog.label.delimiter";
    private static final String OPERATION = "NewEnvVarDialog.label.operation";
    private static final String OPERATION_REPLACE = "NewEnvVarDialog.label.operation.replace";
    private static final String OPERATION_PREPEND = "NewEnvVarDialog.label.operation.prepend";
    private static final String OPERATION_APPEND = "NewEnvVarDialog.label.operation.append";
    private static final String OPERATION_REMOVE = "NewEnvVarDialog.label.operation.remove";
    private static final String VALUE_PREPEND = "NewEnvVarDialog.label.value.prepend";
    private static final String VALUE_APPEND = "NewEnvVarDialog.label.value.append";
    private static final String TITLE_NEW = "NewEnvVarDialog.label.title.new";
    private static final String TITLE_EDIT = "NewEnvVarDialog.label.title.edit";
    private static final String STATUS = "NewEnvVarDialog.label.status";
    private static final String STATUS_CANNOT_CTREATE = "NewEnvVarDialog.label.status.cannot.create";
    private static final String EMPTY_STRING = new String();
    private String fTitle;
    private IBuildEnvironmentVariable fEditedVar;
    private EnvironmentBlock fEnvVarBlock;
    private IBuildEnvironmentVariable fResultingVar;
    private String fReplaceValue = null;
    private String fAppPrepValue = null;
    private boolean fAppPrepPrepend = true;
    private String fTypedName;
    private Combo fVarNameEdit;
    private Text fVarValueEdit;
    private Label fDelimiterLabel;
    private Text fDelimiterEdit;
    private Combo fOpSelector;
    private Label fOpVarValueLabel;
    private Text fOpVarValueEdit;

    public NewEnvVarDialog(Shell parentShell, EnvironmentBlock envBlock, IBuildEnvironmentVariable editedVar) {
        super(parentShell);
        this.fTitle = editedVar != null ? ManagedBuilderUIMessages.getResourceString(TITLE_EDIT) : ManagedBuilderUIMessages.getResourceString(TITLE_NEW);
        this.fEditedVar = editedVar;
        this.fEnvVarBlock = envBlock;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setFont(parent.getFont());
        comp.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        Label nameLabel = new Label(comp, 16384);
        nameLabel.setFont(comp.getFont());
        nameLabel.setText(ManagedBuilderUIMessages.getResourceString(NAME));
        nameLabel.setLayoutData((Object)new GridData());
        this.fVarNameEdit = new Combo(comp, 4);
        this.fVarNameEdit.setItems(this.getVarNames());
        this.fVarNameEdit.setFont(comp.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 250;
        this.fVarNameEdit.setLayoutData((Object)gd);
        this.fVarNameEdit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewEnvVarDialog.this.handleVarNameModified();
            }
        });
        this.fVarNameEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewEnvVarDialog.this.handleVarNameSelection();
            }
        });
        Label valueLabel = new Label(comp, 16384);
        valueLabel.setFont(comp.getFont());
        valueLabel.setText(ManagedBuilderUIMessages.getResourceString(VALUE));
        gd = new GridData();
        gd.horizontalSpan = 1;
        valueLabel.setLayoutData((Object)gd);
        this.fVarValueEdit = new Text(comp, 2052);
        this.fVarValueEdit.setFont(comp.getFont());
        gd = new GridData(768);
        gd.widthHint = 300;
        gd.horizontalSpan = 1;
        this.fVarValueEdit.setLayoutData((Object)gd);
        this.fVarValueEdit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewEnvVarDialog.this.handleVarValueModified();
            }
        });
        this.fDelimiterLabel = new Label(comp, 16384);
        this.fDelimiterLabel.setFont(comp.getFont());
        this.fDelimiterLabel.setText(ManagedBuilderUIMessages.getResourceString(DELIMITER));
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.widthHint = 100;
        this.fDelimiterLabel.setLayoutData((Object)gd);
        this.fDelimiterEdit = new Text(comp, 2052);
        this.fDelimiterEdit.setFont(comp.getFont());
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.widthHint = 50;
        this.fDelimiterEdit.setLayoutData((Object)gd);
        this.fDelimiterEdit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewEnvVarDialog.this.handleDelimiterModified();
            }
        });
        Label opLabel = new Label(comp, 16384);
        opLabel.setFont(comp.getFont());
        opLabel.setText(ManagedBuilderUIMessages.getResourceString(OPERATION));
        gd = new GridData();
        gd.horizontalSpan = 1;
        opLabel.setLayoutData((Object)gd);
        this.fOpSelector = new Combo(comp, 12);
        gd = new GridData(32);
        gd.horizontalSpan = 1;
        this.fOpSelector.setLayoutData((Object)gd);
        this.fOpSelector.setItems(new String[]{ManagedBuilderUIMessages.getResourceString(OPERATION_REPLACE), ManagedBuilderUIMessages.getResourceString(OPERATION_PREPEND), ManagedBuilderUIMessages.getResourceString(OPERATION_APPEND), ManagedBuilderUIMessages.getResourceString(OPERATION_REMOVE)});
        this.setSelectedOperation(1);
        this.fOpSelector.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                NewEnvVarDialog.this.handleOperationModified();
            }
        });
        this.fOpVarValueLabel = new Label(comp, 16384);
        this.fOpVarValueLabel.setFont(comp.getFont());
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.fOpVarValueLabel.setText(ManagedBuilderUIMessages.getResourceString(VALUE_PREPEND));
        this.fOpVarValueLabel.setLayoutData((Object)gd);
        this.fOpVarValueEdit = new Text(comp, 2052);
        this.fOpVarValueEdit.setFont(comp.getFont());
        gd = new GridData(768);
        gd.widthHint = 250;
        this.fOpVarValueEdit.setLayoutData((Object)gd);
        this.fOpVarValueEdit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewEnvVarDialog.this.handleOperationVarValueModified();
            }
        });
        if (this.fEditedVar != null) {
            this.loadVariableSettings(this.fEditedVar, true);
            this.fVarNameEdit.setEnabled(false);
        }
        this.updateWidgetState();
        return comp;
    }

    private String[] getVarNames() {
        IBuildEnvironmentVariable[] vars = this.fEnvVarBlock.getSystemVariables(true);
        String[] names = null;
        if (vars == null || vars.length == 0) {
            names = new String[]{};
        } else {
            names = new String[vars.length];
            int i = 0;
            while (i < vars.length) {
                names[i] = vars[i].getName();
                ++i;
            }
            final Collator collator = Collator.getInstance();
            Arrays.sort(names, new Comparator(){

                public int compare(Object a, Object b) {
                    String strA = ((String)a).toUpperCase();
                    String strB = ((String)b).toUpperCase();
                    return collator.compare(strA, strB);
                }
            });
        }
        return names;
    }

    private void handleVarNameSelection() {
        int index = this.fVarNameEdit.getSelectionIndex();
        if (index == -1) {
            this.loadVariableSettings(null);
        } else {
            this.loadVariableSettings(this.fVarNameEdit.getItem(index));
        }
    }

    private void loadVariableSettings(String name) {
        IBuildEnvironmentVariable var = this.fEnvVarBlock.getSystemVariable(name, true);
        if (var != null) {
            this.loadVariableSettings(var, false);
        } else {
            this.loadVariableSettings(name, EMPTY_STRING, 1, EMPTY_STRING);
        }
    }

    private void loadVariableSettings(String name, String value, int op, String delimiter) {
        this.setSelectedOperation(op);
        this.setSelectedVarName(this.notNull(name));
        switch (op) {
            case 3: {
                this.fOpVarValueEdit.setText(this.notNull(value));
                this.fReplaceValue = null;
                this.fAppPrepValue = this.notNull(value);
                this.fAppPrepPrepend = true;
                break;
            }
            case 4: {
                this.fOpVarValueEdit.setText(this.notNull(value));
                this.fReplaceValue = null;
                this.fAppPrepValue = this.notNull(value);
                this.fAppPrepPrepend = false;
                break;
            }
            case 2: {
                break;
            }
            default: {
                this.fVarValueEdit.setText(this.notNull(value));
                this.fReplaceValue = this.notNull(value);
                this.fAppPrepValue = null;
            }
        }
        this.fDelimiterEdit.setText(this.notNull(delimiter));
        this.updateWidgetState();
    }

    private void loadVariableSettings(IBuildEnvironmentVariable var, boolean isUser) {
        int op = var.getOperation();
        if (!isUser && op != 2) {
            op = 1;
        }
        this.loadVariableSettings(var.getName(), var.getValue(), op, var.getDelimiter());
    }

    private String notNull(String str) {
        return str == null ? EMPTY_STRING : str;
    }

    private String getSelectedVarName() {
        return this.fVarNameEdit.getText().trim();
    }

    private void setSelectedVarName(String name) {
        if (!this.varNamesEqual(this.fVarNameEdit.getText(), name)) {
            this.fTypedName = name;
            this.fVarNameEdit.setText(this.notNull(name).trim());
        }
    }

    private boolean varNamesEqual(String name1, String name2) {
        name1 = name1.trim();
        name2 = name2.trim();
        if (ManagedBuildManager.getEnvironmentVariableProvider().isVariableCaseSensitive()) {
            return name1.equals(name2);
        }
        return name1.equalsIgnoreCase(name2);
    }

    private int getSelectedOperation() {
        switch (this.fOpSelector.getSelectionIndex()) {
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 2;
            }
        }
        return 1;
    }

    private void setSelectedOperation(int op) {
        switch (op) {
            case 3: {
                this.fOpSelector.select(1);
                break;
            }
            case 4: {
                this.fOpSelector.select(2);
                break;
            }
            case 2: {
                this.fOpSelector.select(3);
                break;
            }
            default: {
                this.fOpSelector.select(0);
            }
        }
    }

    protected void okPressed() {
        String name = this.getSelectedVarName();
        if (name != null || !EMPTY_STRING.equals(name)) {
            this.fResultingVar = new BuildEnvVar(name, this.getSelectedVariableValue(), this.getSelectedOperation(), this.fDelimiterEdit.getText());
        }
        super.okPressed();
    }

    public int open() {
        this.fResultingVar = null;
        return super.open();
    }

    private String getSelectedVariableValue() {
        switch (this.getSelectedOperation()) {
            case 3: 
            case 4: {
                return this.fOpVarValueEdit.getText();
            }
            case 2: {
                return EMPTY_STRING;
            }
        }
        return this.fVarValueEdit.getText();
    }

    public IBuildEnvironmentVariable getDefinedVariable() {
        return this.fResultingVar;
    }

    private void handleVarNameModified() {
        String name = this.getSelectedVarName();
        if (this.fTypedName == null || !this.fTypedName.equals(name)) {
            this.loadVariableSettings(name);
        }
    }

    private void handleVarValueModified() {
        switch (this.getSelectedOperation()) {
            case 3: 
            case 4: {
                this.fAppPrepValue = this.fVarValueEdit.getText();
                this.fReplaceValue = null;
                break;
            }
            case 2: {
                break;
            }
            default: {
                this.fReplaceValue = this.fVarValueEdit.getText();
                this.fAppPrepValue = null;
            }
        }
    }

    private void handleOperationModified() {
        int op = this.getSelectedOperation();
        String newValue = this.recalculateValueString();
        switch (op) {
            case 3: {
                this.fVarValueEdit.setText(this.calculateAppendPrepend(this.getSelectedVarName(), newValue, this.fDelimiterEdit.getText(), true));
                this.fVarValueEdit.setEnabled(false);
                this.fOpVarValueEdit.setText(newValue);
                this.fOpVarValueLabel.setText(ManagedBuilderUIMessages.getResourceString(VALUE_PREPEND));
                this.fOpVarValueLabel.setVisible(true);
                this.fOpVarValueEdit.setVisible(true);
                this.fDelimiterEdit.setEnabled(true);
                this.fAppPrepPrepend = true;
                this.fAppPrepValue = newValue;
                this.fReplaceValue = null;
                break;
            }
            case 4: {
                this.fVarValueEdit.setText(this.calculateAppendPrepend(this.getSelectedVarName(), newValue, this.fDelimiterEdit.getText(), false));
                this.fVarValueEdit.setEnabled(false);
                this.fOpVarValueEdit.setText(newValue);
                this.fOpVarValueLabel.setText(ManagedBuilderUIMessages.getResourceString(VALUE_APPEND));
                this.fOpVarValueLabel.setVisible(true);
                this.fOpVarValueEdit.setVisible(true);
                this.fDelimiterEdit.setEnabled(true);
                this.fAppPrepPrepend = false;
                this.fAppPrepValue = newValue;
                this.fReplaceValue = null;
                break;
            }
            case 2: {
                this.fOpVarValueLabel.setVisible(false);
                this.fOpVarValueEdit.setVisible(false);
                this.fDelimiterEdit.setEnabled(false);
                this.fVarValueEdit.setText(EMPTY_STRING);
                this.fVarValueEdit.setEnabled(false);
                break;
            }
            default: {
                this.fVarValueEdit.setText(newValue);
                this.fOpVarValueLabel.setVisible(false);
                this.fOpVarValueEdit.setVisible(false);
                this.fDelimiterEdit.setEnabled(true);
                this.fVarValueEdit.setEnabled(true);
                this.fAppPrepValue = null;
                this.fReplaceValue = newValue;
            }
        }
        this.fOpVarValueLabel.getParent().layout(true);
    }

    private String recalculateValueString() {
        String val = EMPTY_STRING;
        switch (this.getSelectedOperation()) {
            case 3: {
                if (this.fAppPrepValue != null) {
                    val = this.fAppPrepValue;
                    break;
                }
                if (this.fReplaceValue == null) break;
                val = this.calculateAppPrepFromReplace(this.fReplaceValue, this.fDelimiterEdit.getText(), true);
                break;
            }
            case 4: {
                if (this.fAppPrepValue != null) {
                    val = this.fAppPrepValue;
                    break;
                }
                if (this.fReplaceValue == null) break;
                val = this.calculateAppPrepFromReplace(this.fReplaceValue, this.fDelimiterEdit.getText(), false);
                break;
            }
            case 2: {
                val = EMPTY_STRING;
                break;
            }
            default: {
                if (this.fReplaceValue != null) {
                    val = this.fReplaceValue;
                    break;
                }
                if (this.fAppPrepValue == null) break;
                val = this.fReplaceValue = this.calculateReplaceFromAppPrep(this.fAppPrepValue, this.fDelimiterEdit.getText(), this.fAppPrepPrepend);
            }
        }
        return val;
    }

    private String calculateAppPrepFromReplace(String replace, String delimiter, boolean prepend) {
        String val = replace;
        IBuildEnvironmentVariable var = this.fEnvVarBlock.getSystemVariable(this.getSelectedVarName(), true);
        if (var != null && var.getOperation() != 2) {
            String varValue = var.getValue();
            if (delimiter != null && !EMPTY_STRING.equals(delimiter)) {
                List replaceValues = EnvVarOperationProcessor.convertToList((String)replace, (String)delimiter);
                List varValues = EnvVarOperationProcessor.convertToList((String)varValue, (String)delimiter);
                List result = EnvVarOperationProcessor.removeDuplicates((List)replaceValues, (List)varValues);
                val = EnvVarOperationProcessor.convertToString((List)result, (String)delimiter);
            } else if (varValue != null && !EMPTY_STRING.equals(varValue)) {
                int index = replace.indexOf(varValue);
                if (index == -1) {
                    val = EMPTY_STRING;
                } else {
                    try {
                        val = index == 0 ? replace.substring(replace.length()) : replace.substring(0, index);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        val = EMPTY_STRING;
                    }
                }
            }
        }
        return val;
    }

    private String calculateReplaceFromAppPrep(String value, String delimiter, boolean prepend) {
        return this.calculateAppendPrepend(this.getSelectedVarName(), value, delimiter, prepend);
    }

    private void updateWidgetState() {
        this.handleOperationModified();
        this.validateState();
    }

    private void updateVariableValueForAppendPrepend(boolean prepend) {
        String name = this.getSelectedVarName();
        if (name == null || EMPTY_STRING.equals(name)) {
            return;
        }
        String opValue = this.fOpVarValueEdit.getText();
        this.fVarValueEdit.setText(this.calculateAppendPrepend(name, opValue, this.fDelimiterEdit.getText(), prepend));
    }

    private String calculateAppendPrepend(String name, String opValue, String delimiter, boolean prepend) {
        IBuildEnvironmentVariable var = this.fEnvVarBlock.getSystemVariable(name, true);
        if (var == null) {
            return opValue;
        }
        return EnvVarOperationProcessor.performAppendPrepend((String)var.getValue(), (String)opValue, (String)delimiter, (boolean)prepend);
    }

    private void handleDelimiterModified() {
        int op = this.getSelectedOperation();
        switch (op) {
            case 3: {
                String value = this.getSelectedVariableValue();
                this.fVarValueEdit.setText(this.calculateAppendPrepend(this.getSelectedVarName(), value, this.fDelimiterEdit.getText(), true));
                this.fAppPrepValue = value;
                this.fReplaceValue = null;
                break;
            }
            case 4: {
                String value = this.getSelectedVariableValue();
                this.fVarValueEdit.setText(this.calculateAppendPrepend(this.getSelectedVarName(), value, this.fDelimiterEdit.getText(), false));
                this.fAppPrepValue = value;
                this.fReplaceValue = null;
                break;
            }
            case 2: {
                break;
            }
            default: {
                this.fAppPrepValue = null;
                this.fReplaceValue = this.getSelectedVariableValue();
            }
        }
    }

    private void handleOperationVarValueModified() {
        this.handleDelimiterModified();
    }

    private void validateState() {
        StatusInfo status = new StatusInfo();
        String name = this.getSelectedVarName();
        if (EMPTY_STRING.equals(name)) {
            status.setError("");
        } else if (!this.fEnvVarBlock.canCreate(name)) {
            status.setError(ManagedBuilderUIMessages.getFormattedString(STATUS_CANNOT_CTREATE, name));
        }
        this.updateStatus((IStatus)status);
    }
}

