/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.OptionCategory;

public class ToolListElement {
    private ToolListElement parent = null;
    private List childElements = null;
    private IHoldsOptions optionHolder = null;
    private IOptionCategory optionCategory = null;
    private ITool tool = null;

    public ToolListElement(ToolListElement parent, IHoldsOptions optionHolder, IOptionCategory optionCategory) {
        this.parent = parent;
        this.optionHolder = optionHolder;
        this.optionCategory = optionCategory;
    }

    public ToolListElement(ITool tool) {
        this.tool = tool;
    }

    public boolean isEquivalentTo(ToolListElement e) {
        if (this.tool != null) {
            ITool matchTool = e.getTool();
            if (matchTool == this.tool) {
                return true;
            }
            if (matchTool == null) {
                return false;
            }
            return matchTool.getName().equals(this.tool.getName());
        }
        if (this.optionCategory != null) {
            IOptionCategory matchCategory = e.getOptionCategory();
            IHoldsOptions matchHolder = e.getHoldOptions();
            if (matchCategory == this.optionCategory && matchHolder == this.optionHolder) {
                return true;
            }
            if (matchCategory == null) {
                return false;
            }
            String matchCategoryName = OptionCategory.makeMatchName((IBuildObject)matchCategory);
            String optionCategoryName = OptionCategory.makeMatchName((IBuildObject)this.optionCategory);
            return matchHolder.getName().equals(this.optionHolder.getName()) && matchCategoryName.equals(optionCategoryName);
        }
        return false;
    }

    public ToolListElement getParent() {
        return this.parent;
    }

    public IHoldsOptions getHoldOptions() {
        return this.optionHolder;
    }

    public IOptionCategory getOptionCategory() {
        return this.optionCategory;
    }

    public ITool getTool() {
        return this.tool;
    }

    public ToolListElement[] getChildElements() {
        if (this.childElements != null) {
            return this.childElements.toArray(new ToolListElement[this.childElements.size()]);
        }
        return new ToolListElement[0];
    }

    public void addChildElement(ToolListElement element) {
        if (this.childElements == null) {
            this.childElements = new ArrayList();
        }
        this.childElements.add(element);
    }
}

