/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.loader;

import edu.uoregon.tau.common.Common;
import edu.uoregon.tau.common.Wget;
import edu.uoregon.tau.common.tar.Tar;
import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.database.ConnectionManager;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.database.ParseConfig;
import edu.uoregon.tau.perfdmf.database.PasswordField;
import edu.uoregon.tau.perfdmf.loader.ConfigureTest;
import edu.uoregon.tau.perfdmf.loader.DatabaseConfigurationException;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Configure {
    private static String Usage = "Usage: configure [{-h,--help}] [{-g,--configfile} filename] [{-c --config} configuration_name] [{-t,--tauroot} path]";
    private static String Greeting = "\nWelcome to the configuration program for PerfDMF.\nThis program will prompt you for some information necessary to ensure\nthe desired behavior for the PerfDMF tools.\n";
    private String configuration_name = "";
    private String perfdmf_home = "";
    private String tau_root = "";
    private String arch = "";
    private String jdbc_db_jarfile = "derby.jar";
    private String jdbc_db_driver = "org.apache.derby.jdbc.EmbeddedDriver";
    private String jdbc_db_type = "derby";
    private String db_hostname = "";
    private String db_portnum = "";
    private String db_dbname = "perfdmf";
    private String db_username = "";
    private String db_password = "";
    private String db_schemaprefix = "";
    private boolean store_db_password = false;
    private String db_schemafile = "dbschema.derby.txt";
    private String xml_parser = "xerces.jar";
    private ParseConfig parser;
    private boolean configFileFound = false;
    private String configFileName;

    public Configure(String string, String string2) {
        this.tau_root = string;
        this.arch = string2;
        this.perfdmf_home = string + "/tools/src/perfdmf";
    }

    public void errorPrint(String string) {
        System.err.println(string);
    }

    public void initialize(String string) {
        System.out.println(Greeting);
        try {
            this.configFileName = string;
            File file = new File(this.configFileName);
            if (file.exists()) {
                System.out.println("Configuration file found...");
                this.parseConfigFile();
                this.configFileFound = true;
            } else {
                System.out.println("Configuration file NOT found...");
                System.out.println("a new configuration file will be created.");
            }
        }
        catch (IOException iOException) {
            System.out.println("I/O Error occurred.");
        }
    }

    public void parseConfigFile() throws IOException, FileNotFoundException {
        System.out.println("Parsing config file...");
        this.parser = new ParseConfig(this.configFileName);
        this.perfdmf_home = this.parser.getPerfDMFHome();
        this.jdbc_db_jarfile = this.parser.getJDBCJarFile();
        this.jdbc_db_driver = this.parser.getJDBCDriver();
        this.jdbc_db_type = this.parser.getDBType();
        this.db_hostname = this.parser.getDBHost();
        this.db_portnum = this.parser.getDBPort();
        this.db_schemaprefix = this.parser.getDBSchemaPrefix();
        this.db_dbname = this.parser.getDBName();
        this.db_username = this.parser.getDBUserName();
        this.db_password = this.parser.getDBPasswd();
        this.db_schemafile = this.parser.getDBSchema();
        this.xml_parser = this.parser.getXMLSAXParser();
    }

    private String getSysDepRoot() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.trim().startsWith("windows")) {
            return this.tau_root + "/bin/";
        }
        return this.tau_root + "/" + this.arch + "/lib/";
    }

    public void promptForData() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("\nYou will now be prompted for new values, if desired.  The current or default\nvalues for each prompt are shown in parenthesis.\nTo accept the current/default value, just press Enter/Return.\n");
        try {
            Object object;
            boolean bl;
            int n;
            System.out.print("Please enter the name of this configuration.\n():");
            String string = bufferedReader.readLine();
            this.configuration_name = string.length() > 0 ? string : "";
            System.out.print("Please enter the TAU root directory.\n(" + this.tau_root + "):");
            string = bufferedReader.readLine();
            if (string.length() > 0) {
                this.tau_root = string;
                this.perfdmf_home = this.tau_root + "/tools/src/perfdmf";
            }
            String string2 = this.jdbc_db_type;
            boolean bl2 = false;
            while (!bl2) {
                System.out.println("Please enter the database vendor (oracle, postgresql, mysql, db2 or derby).");
                System.out.println("(" + this.jdbc_db_type + "):");
                string = bufferedReader.readLine();
                if (string.compareTo("oracle") != 0 && string.compareTo("postgresql") != 0 && string.compareTo("mysql") != 0 && string.compareTo("derby") != 0 && string.compareTo("db2") != 0 && string.length() != 0) continue;
                if (string.length() > 0) {
                    this.jdbc_db_type = string;
                }
                bl2 = true;
            }
            if (this.configFileFound) {
                if (this.jdbc_db_type.compareTo("postgresql") == 0 && string2.compareTo("postgresql") != 0) {
                    this.jdbc_db_jarfile = this.getSysDepRoot() + "postgresql.jar";
                    this.jdbc_db_driver = "org.postgresql.Driver";
                    this.db_schemafile = this.perfdmf_home + "/etc/" + "dbschema.txt";
                    this.db_portnum = "5432";
                    this.db_hostname = "localhost";
                    this.db_dbname = "perfdmf";
                } else if (this.jdbc_db_type.compareTo("mysql") == 0 && string2.compareTo("mysql") != 0) {
                    this.jdbc_db_jarfile = this.getSysDepRoot() + "mysql.jar";
                    this.jdbc_db_driver = "org.gjt.mm.mysql.Driver";
                    this.db_schemafile = this.perfdmf_home + "/etc/" + "dbschema.mysql.txt";
                    this.db_portnum = "3306";
                    this.db_hostname = "localhost";
                    this.db_dbname = "perfdmf";
                } else if (this.jdbc_db_type.compareTo("oracle") == 0 && string2.compareTo("oracle") != 0) {
                    this.jdbc_db_jarfile = this.getSysDepRoot() + "ojdbc14.jar";
                    this.jdbc_db_driver = "oracle.jdbc.OracleDriver";
                    this.db_schemafile = this.perfdmf_home + "/etc/" + "dbschema.oracle.txt";
                    this.db_portnum = "1521";
                    this.db_hostname = "localhost";
                    this.db_dbname = "perfdmf";
                } else if (this.jdbc_db_type.compareTo("derby") == 0 && string2.compareTo("derby") != 0) {
                    this.jdbc_db_jarfile = this.getSysDepRoot() + "derby.jar";
                    this.jdbc_db_driver = "org.apache.derby.jdbc.EmbeddedDriver";
                    this.db_schemafile = this.perfdmf_home + "/etc/" + "dbschema.derby.txt";
                    this.db_dbname = this.tau_root + "/" + this.arch + "/lib/perfdmf";
                    this.db_hostname = "";
                    this.db_portnum = "";
                } else if (this.jdbc_db_type.compareTo("db2") == 0 && string2.compareTo("db2") != 0) {
                    this.jdbc_db_jarfile = "";
                    this.jdbc_db_driver = "com.ibm.db2.jcc.DB2Driver";
                    this.db_schemafile = this.perfdmf_home + "/etc/" + "dbschema.db2.txt";
                    this.db_dbname = "perfdmf";
                    this.db_schemaprefix = "perfdmf";
                    this.db_hostname = "localhost";
                    this.db_portnum = "446";
                } else if (this.jdbc_db_type.compareTo("db2") == 0 && string2.compareTo("db2") == 0) {
                    n = this.jdbc_db_jarfile.indexOf("java/db2java.zip:");
                    this.jdbc_db_jarfile = n == -1 ? ((n = this.jdbc_db_jarfile.indexOf("java/db2jcc.jar:")) == -1 ? "" : this.jdbc_db_jarfile.substring(0, n - 1)) : this.jdbc_db_jarfile.substring(0, n - 1);
                }
            } else if (this.jdbc_db_type.compareTo("postgresql") == 0) {
                this.jdbc_db_jarfile = "postgresql.jar";
                this.jdbc_db_driver = "org.postgresql.Driver";
                this.db_schemafile = "dbschema.txt";
                this.db_hostname = "localhost";
                this.db_portnum = "5432";
            } else if (this.jdbc_db_type.compareTo("mysql") == 0) {
                this.jdbc_db_jarfile = "mysql.jar";
                this.jdbc_db_driver = "org.gjt.mm.mysql.Driver";
                this.db_schemafile = "dbschema.mysql.txt";
                this.db_hostname = "localhost";
                this.db_portnum = "3306";
            } else if (this.jdbc_db_type.compareTo("oracle") == 0) {
                this.jdbc_db_jarfile = "ojdbc14.jar";
                this.jdbc_db_driver = "oracle.jdbc.OracleDriver";
                this.db_schemafile = "dbschema.oracle.txt";
                this.db_hostname = "localhost";
                this.db_portnum = "1521";
            } else if (this.jdbc_db_type.compareTo("derby") == 0) {
                this.jdbc_db_jarfile = "derby.jar";
                this.jdbc_db_driver = "org.apache.derby.jdbc.EmbeddedDriver";
                this.db_schemafile = "dbschema.derby.txt";
                this.db_dbname = this.tau_root + "/" + this.arch + "/lib/perfdmf";
                this.db_hostname = "";
                this.db_portnum = "";
            } else if (this.jdbc_db_type.compareTo("db2") == 0) {
                this.jdbc_db_jarfile = "";
                this.jdbc_db_driver = "com.ibm.db2.jcc.DB2Driver";
                this.db_schemafile = "dbschema.db2.txt";
                this.db_dbname = "perfdmf";
                this.db_schemaprefix = "perfdmf";
                this.db_hostname = "localhost";
                this.db_portnum = "446";
            }
            if (!this.configFileFound) {
                this.jdbc_db_jarfile = this.getSysDepRoot() + this.jdbc_db_jarfile;
            }
            if (this.jdbc_db_type.compareTo("db2") == 0) {
                System.out.println("Please enter the path to the DB2 sqllib directory,");
                System.out.println("often something like /home/db2_srv/sqllib.");
                System.out.print("(" + this.jdbc_db_jarfile + "):");
            } else {
                System.out.print("Please enter the JDBC jar file.\n(" + this.jdbc_db_jarfile + "):");
            }
            string = bufferedReader.readLine();
            if (string.length() > 0) {
                this.jdbc_db_jarfile = string;
            }
            if (!new File(this.jdbc_db_jarfile).exists()) {
                if (this.jdbc_db_type.compareToIgnoreCase("oracle") == 0) {
                    System.out.println("\nSorry, can't automatically download drivers for Oracle");
                    System.out.println("Please acquire them manually\n");
                } else if (this.jdbc_db_type.compareToIgnoreCase("db2") == 0) {
                    System.out.println("\nSorry, can't automatically download drivers for db2");
                    System.out.println("Please acquire them manually\n");
                } else {
                    System.out.println("\n\nCouldn't find jarfile: " + this.jdbc_db_jarfile);
                    System.out.println("\nJDBC drivers are not distributed with TAU.  You should acquire the JDBC driver");
                    System.out.println("that corresponds to the database you are connecting to.  TAU can now attempt ");
                    System.out.println("to download a JDBC driver that will *probably* work.");
                    n = 0;
                    bl = false;
                    while (n == 0) {
                        System.out.print("\nWould you like to attempt to automatically download a JDBC driver? (y/n):");
                        string = bufferedReader.readLine();
                        if (string.compareToIgnoreCase("yes") == 0 || string.compareToIgnoreCase("y") == 0) {
                            n = 1;
                            bl = true;
                        }
                        if (string.compareToIgnoreCase("no") != 0 && string.compareToIgnoreCase("n") != 0) continue;
                        n = 1;
                        bl = false;
                    }
                    if (bl) {
                        try {
                            String string3;
                            String string4;
                            new File(".perfdmf_tmp").mkdirs();
                            System.setProperty("tar.location", ".perfdmf_tmp");
                            if (this.jdbc_db_type.compareToIgnoreCase("postgresql") == 0) {
                                Wget.wget((String)"http://www.cs.uoregon.edu/research/paracomp/tau/postgresql-redirect.html", (String)".perfdmf_tmp/postgresql-redirect.html", (boolean)false);
                                object = new BufferedReader(new InputStreamReader(new FileInputStream(new File(".perfdmf_tmp/postgresql-redirect.html"))));
                                string4 = "";
                                string3 = ((BufferedReader)object).readLine();
                                while (string3 != null) {
                                    if (string3.startsWith("URL=")) {
                                        string4 = string3.substring(4);
                                    }
                                    string3 = ((BufferedReader)object).readLine();
                                }
                                ((BufferedReader)object).close();
                                System.out.println("\nDownloading... " + string4);
                                System.out.print("Please Wait...");
                                Wget.wget((String)string4, (String)this.jdbc_db_jarfile, (boolean)true);
                                System.out.println(" Done");
                            }
                            if (this.jdbc_db_type.compareToIgnoreCase("mysql") == 0) {
                                Wget.wget((String)"http://www.cs.uoregon.edu/research/paracomp/tau/mysql-redirect.html", (String)".perfdmf_tmp/mysql-redirect.html", (boolean)false);
                                object = new BufferedReader(new InputStreamReader(new FileInputStream(new File(".perfdmf_tmp/mysql-redirect.html"))));
                                string4 = "";
                                string3 = "";
                                String string5 = "";
                                String string6 = ((BufferedReader)object).readLine();
                                while (string6 != null) {
                                    if (string6.startsWith("URL=")) {
                                        string4 = string6.substring(4);
                                    }
                                    if (string6.startsWith("FILE=")) {
                                        string3 = string6.substring(5);
                                    }
                                    if (string6.startsWith("JAR=")) {
                                        string5 = string6.substring(4);
                                    }
                                    string6 = ((BufferedReader)object).readLine();
                                }
                                ((BufferedReader)object).close();
                                System.out.println("\nDownloading... " + string4);
                                System.out.print("Please Wait...");
                                Wget.wget((String)string4, (String)(".perfdmf_tmp/" + string3), (boolean)true);
                                System.out.println(" Done");
                                System.out.println("\nUncompressing...");
                                Tar.guntar((String)(".perfdmf_tmp/" + string3));
                                Common.copy((String)(".perfdmf_tmp/" + string5), (String)this.jdbc_db_jarfile);
                            }
                            if (!new File(this.jdbc_db_jarfile).exists()) {
                                System.out.println("Unable to retrieve jarfile, please retrieve it manually");
                            }
                            Common.deltree((File)new File(".perfdmf_tmp"));
                        }
                        catch (Exception exception) {
                            System.out.println("Unable to retrieve jarfile:");
                            exception.printStackTrace();
                        }
                    }
                }
            }
            if (this.jdbc_db_type.compareTo("db2") == 0) {
                this.jdbc_db_jarfile = string = this.jdbc_db_jarfile + "/java/db2java.zip:" + this.jdbc_db_jarfile + "/java/db2jcc.jar:" + this.jdbc_db_jarfile + "/function:" + this.jdbc_db_jarfile + "/java/db2jcc_license_cu.jar";
            }
            System.out.print("Please enter the JDBC Driver name.\n(" + this.jdbc_db_driver + "):");
            string = bufferedReader.readLine();
            if (string.length() > 0) {
                this.jdbc_db_driver = string;
            }
            if (this.jdbc_db_type.compareTo("derby") != 0) {
                System.out.print("Please enter the hostname for the database server.\n(" + this.db_hostname + "):");
                string = bufferedReader.readLine();
                if (string.length() > 0) {
                    this.db_hostname = string;
                }
                System.out.print("Please enter the port number for the database JDBC connection.\n(" + this.db_portnum + "):");
                string = bufferedReader.readLine();
                if (string.length() > 0) {
                    this.db_portnum = string;
                }
            }
            if (this.jdbc_db_type.compareTo("oracle") == 0) {
                System.out.print("Please enter the oracle TCP service name.\n(" + this.db_dbname + "):");
            } else if (this.jdbc_db_type.compareTo("derby") == 0) {
                System.out.print("Please enter the path to the database directory.\n(" + this.db_dbname + "):");
            } else {
                System.out.print("Please enter the database name.\n(" + this.db_dbname + "):");
            }
            string = bufferedReader.readLine();
            if (string.length() > 0) {
                this.db_dbname = string;
            }
            if (this.jdbc_db_type.compareTo("oracle") == 0 || this.jdbc_db_type.compareTo("db2") == 0) {
                System.out.print("Please enter the database schema name, or your username if you are creating the tables now.\n(" + this.db_schemaprefix + "):");
                string = bufferedReader.readLine();
                if (string.length() > 0) {
                    this.db_schemaprefix = string;
                }
            }
            System.out.print("Please enter the database username.\n(" + this.db_username + "):");
            string = bufferedReader.readLine();
            if (string.length() > 0) {
                this.db_username = string;
            }
            n = 0;
            bl = false;
            while (n == 0) {
                System.out.print("Store the database password in CLEAR TEXT in your configuration file? (y/n):");
                string = bufferedReader.readLine();
                if (string.compareToIgnoreCase("yes") == 0 || string.compareToIgnoreCase("y") == 0) {
                    n = 1;
                    bl = true;
                }
                if (string.compareToIgnoreCase("no") != 0 && string.compareToIgnoreCase("n") != 0) continue;
                n = 1;
                bl = false;
            }
            if (bl) {
                object = new PasswordField();
                this.db_password = ((PasswordField)object).getPassword("Please enter the database password:");
                this.store_db_password = true;
            }
            if (this.configFileFound) {
                System.out.print("Please enter the PerfDMF schema file.\n(" + this.db_schemafile + "):");
            } else {
                System.out.print("Please enter the PerfDMF schema file.\n(" + this.perfdmf_home + "/etc/" + this.db_schemafile + "):");
            }
            string = bufferedReader.readLine();
            if (string.length() > 0) {
                this.db_schemafile = string;
            } else if (!this.configFileFound) {
                this.db_schemafile = this.perfdmf_home + "/etc/" + this.db_schemafile;
            }
        }
        catch (IOException iOException) {
            System.out.println("I/O Error occurred.");
        }
    }

    public void testDBConnection() {
    }

    public void testDBTransaction() {
    }

    public String writeConfigFile() {
        try {
            File file = this.configuration_name.length() == 0 ? new File(System.getProperty("user.home") + "/.ParaProf/perfdmf.cfg") : new File(this.configFileName + "." + this.configuration_name);
            System.out.println("\nWriting configuration file: " + file);
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("# This is the configuration file for the PerfDMF tools & API\n");
            bufferedWriter.write("# Items are listed as name:value, one per line.\n");
            bufferedWriter.write("# Comment lines begin with a '#' symbol.\n");
            bufferedWriter.write("# DO NOT EDIT THIS FILE!  It is modified by the configure utility.\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# PerfDMF home directory\n");
            bufferedWriter.write("perfdmf_home:" + this.perfdmf_home + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database JDBC jar file (with path to location)\n");
            bufferedWriter.write("jdbc_db_jarfile:" + this.jdbc_db_jarfile + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database JDBC driver name\n");
            bufferedWriter.write("jdbc_db_driver:" + this.jdbc_db_driver + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database type\n");
            bufferedWriter.write("jdbc_db_type:" + this.jdbc_db_type + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database host name\n");
            bufferedWriter.write("db_hostname:" + this.db_hostname + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database port number\n");
            bufferedWriter.write("db_portnum:" + this.db_portnum + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database name\n");
            bufferedWriter.write("db_dbname:" + this.db_dbname + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database Schema name\n");
            bufferedWriter.write("db_schemaprefix:" + this.db_schemaprefix + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database username\n");
            bufferedWriter.write("db_username:" + this.db_username + "\n");
            bufferedWriter.newLine();
            if (this.store_db_password) {
                bufferedWriter.write("# Database password\n");
                bufferedWriter.write("db_password:" + this.db_password + "\n");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("# Database Schema file - note: the path is absolute\n");
            bufferedWriter.write("db_schemafile:" + this.db_schemafile + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database XML parser jar file - note: the path is absolute\n");
            bufferedWriter.write("xml_sax_parser:" + this.xml_parser + "\n");
            bufferedWriter.newLine();
            bufferedWriter.close();
            return file.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void setPerfDMFHome(String string) {
        this.perfdmf_home = string;
    }

    public String getPerfDMFHome() {
        return this.perfdmf_home;
    }

    public void setJDBCJarfile(String string) {
        this.jdbc_db_jarfile = string;
    }

    public String getJDBCJarfile() {
        return this.jdbc_db_jarfile;
    }

    public void setJDBCDriver(String string) {
        this.jdbc_db_driver = string;
    }

    public String getJDBCDriver() {
        return this.jdbc_db_driver;
    }

    public void setJDBCType(Object object) {
        this.jdbc_db_type = (String)object;
    }

    public String getJDBCType() {
        return this.jdbc_db_type;
    }

    public void setDBHostname(String string) {
        this.db_hostname = string;
    }

    public String getDBHostname() {
        return this.db_hostname;
    }

    public void setDBPortNum(String string) {
        this.db_portnum = string;
    }

    public String getDBPortNum() {
        return this.db_portnum;
    }

    public void setDBName(String string) {
        this.db_dbname = string;
    }

    public String getDBName() {
        return this.db_dbname;
    }

    public void setDBUsername(String string) {
        this.db_username = string;
    }

    public String getDBUsername() {
        return this.db_username;
    }

    public void setDBPassword(String string) {
        this.db_password = string;
    }

    public String getDBPassword() {
        return this.db_password;
    }

    public void setDBSchemaFile(String string) {
        this.db_schemafile = string;
    }

    public String getDBSchemaFile() {
        return this.db_schemafile;
    }

    public void setXMLPaser(String string) {
        this.xml_parser = string;
    }

    public String getXMLPaser() {
        return this.xml_parser;
    }

    public void setConfigFileName(String string) {
        this.configuration_name = string;
    }

    public String getConfigFileName() {
        return this.configuration_name;
    }

    public void savePassword() {
        this.store_db_password = true;
    }

    public void createDB() throws DatabaseConfigurationException {
        ConnectionManager connectionManager = null;
        DB dB = null;
        try {
            connectionManager = new ConnectionManager(new Database(this.configFileName), true);
            connectionManager.connect();
            dB = connectionManager.getDB();
        }
        catch (SQLException sQLException) {
            System.out.println("\nPlease make sure that your DBMS is configured correctly, and");
            System.out.println("the database " + this.db_dbname + " has been created.");
            throw new DatabaseException("Error Connection to Database" + this.db_dbname, sQLException);
        }
        try {
            String string = new String("select * from application;");
            ResultSet resultSet = dB.executeQuery(string);
            resultSet.close();
            connectionManager.dbclose();
        }
        catch (Exception exception) {
            System.out.println(this.configFileName);
            connectionManager.genParentSchema(this.db_schemafile);
            connectionManager.dbclose();
            System.out.println("Congratulations! PerfDMF is configured and the database has been built.");
            System.out.println("You may begin loading applications.");
        }
        System.out.println("Configuration complete.");
    }

    public static void main(String[] stringArray) {
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addStringOption('g', "configfile");
        CmdLineParser.Option option2 = cmdLineParser.addStringOption('c', "config");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('t', "tauroot");
        CmdLineParser.Option option4 = cmdLineParser.addStringOption('a', "arch");
        CmdLineParser.Option option5 = cmdLineParser.addBooleanOption('h', "help");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            System.err.println(Usage);
            System.exit(-1);
        }
        String string = (String)cmdLineParser.getOptionValue(option);
        String string2 = (String)cmdLineParser.getOptionValue(option2);
        String string3 = (String)cmdLineParser.getOptionValue(option3);
        String string4 = (String)cmdLineParser.getOptionValue(option4);
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option5);
        if (bl != null && bl.booleanValue()) {
            System.err.println(Usage);
            System.exit(-1);
        }
        if (string == null) {
            string = string2 == null ? System.getProperty("user.home") + "/.ParaProf/perfdmf.cfg" : System.getProperty("user.home") + "/.ParaProf/perfdmf.cfg." + string2;
        }
        if (string3 == null) {
            string3 = new String("");
        }
        if (string4 == null) {
            string4 = new String("");
        }
        Configure configure = new Configure(string3, string4);
        configure.initialize(string);
        configure.promptForData();
        String string5 = configure.writeConfigFile();
        ConfigureTest configureTest = new ConfigureTest(string3);
        configureTest.initialize(string5);
        try {
            configureTest.createDB(true);
        }
        catch (DatabaseConfigurationException databaseConfigurationException) {
            databaseConfigurationException.printStackTrace();
            System.exit(0);
        }
    }
}

