/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template.c;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.corext.template.c.CContext;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.cdt.internal.ui.util.Strings;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class CFormatter {
    private final String fLineDelimiter;
    private final int fInitialIndentLevel;
    private boolean fUseCodeFormatter;

    public CFormatter(String lineDelimiter, int initialIndentLevel, boolean useCodeFormatter) {
        this.fLineDelimiter = lineDelimiter;
        this.fUseCodeFormatter = useCodeFormatter;
        this.fInitialIndentLevel = initialIndentLevel;
    }

    public void edit(TemplateBuffer buffer, CContext context, int indentationLevel) throws BadLocationException {
        try {
            if (this.fUseCodeFormatter) {
                try {
                    this.format(buffer, context);
                }
                catch (BadLocationException badLocationException) {
                    this.indent(buffer);
                }
                catch (MalformedTreeException malformedTreeException) {
                    this.indent(buffer);
                }
            } else {
                this.indent(buffer);
            }
            if (context.getStart() == context.getCompletionOffset() && context.getDocument().get(context.getStart(), context.getEnd() - context.getEnd()).trim().length() == 0) {
                return;
            }
            CFormatter.trimBegin(buffer);
        }
        catch (MalformedTreeException malformedTreeException) {
            throw new BadLocationException();
        }
    }

    private void format(TemplateBuffer templateBuffer, CContext context) throws BadLocationException {
        this.plainFormat(templateBuffer, context);
    }

    private void plainFormat(TemplateBuffer templateBuffer, CContext context) throws BadLocationException {
        MultiTextEdit root;
        Document doc = new Document(templateBuffer.getString());
        TemplateVariable[] variables = templateBuffer.getVariables();
        List offsets = CFormatter.variablesToPositions(variables);
        Map options = context.getTranslationUnit() != null ? context.getTranslationUnit().getCProject().getOptions(true) : CCorePlugin.getOptions();
        TextEdit edit = CodeFormatterUtil.format(0, doc.get(), this.fInitialIndentLevel, this.fLineDelimiter, options);
        if (edit == null) {
            throw new BadLocationException();
        }
        if (edit instanceof MultiTextEdit) {
            root = (MultiTextEdit)edit;
        } else {
            root = new MultiTextEdit(0, doc.getLength());
            root.addChild(edit);
        }
        Iterator it = offsets.iterator();
        while (it.hasNext()) {
            TextEdit position = (TextEdit)it.next();
            try {
                root.addChild(position);
            }
            catch (MalformedTreeException malformedTreeException) {}
        }
        root.apply((IDocument)doc, 2);
        CFormatter.positionsToVariables(offsets, variables);
        templateBuffer.setContent(doc.get(), variables);
    }

    private void indent(TemplateBuffer templateBuffer) throws BadLocationException, MalformedTreeException {
        int tabWidth;
        TemplateVariable[] variables = templateBuffer.getVariables();
        List positions = CFormatter.variablesToPositions(variables);
        Document document = new Document(templateBuffer.getString());
        MultiTextEdit root = new MultiTextEdit(0, document.getLength());
        root.addChildren(positions.toArray(new TextEdit[positions.size()]));
        IPreferenceStore store = CUIPlugin.getDefault().getCombinedPreferenceStore();
        boolean useSpaces = store.getBoolean("spacesForTabs");
        int indentWidth = tabWidth = store.getInt("tabWidth");
        String indent = CFormatter.createIndentString(this.fInitialIndentLevel * indentWidth, tabWidth, useSpaces);
        int offset = document.getLineOffset(0);
        InsertEdit edit = new InsertEdit(offset, indent);
        root.addChild((TextEdit)edit);
        root.apply((IDocument)document, 2);
        root.removeChild((TextEdit)edit);
        this.formatDelimiter((IDocument)document, root, 0);
        int lineCount = document.getNumberOfLines();
        int line = 1;
        while (line < lineCount) {
            IRegion region = document.getLineInformation(line);
            String lineContent = document.get(region.getOffset(), region.getLength());
            String lineIndent = Strings.getIndentString(lineContent, tabWidth);
            int lineIndentLevel = Strings.computeIndent(lineIndent, tabWidth);
            indent = CFormatter.createIndentString((this.fInitialIndentLevel + lineIndentLevel) * indentWidth, tabWidth, useSpaces);
            edit = new ReplaceEdit(region.getOffset(), lineIndent.length(), indent);
            root.addChild((TextEdit)edit);
            root.apply((IDocument)document, 2);
            root.removeChild((TextEdit)edit);
            this.formatDelimiter((IDocument)document, root, line);
            ++line;
        }
        CFormatter.positionsToVariables(positions, variables);
        templateBuffer.setContent(document.get(), variables);
    }

    private void formatDelimiter(IDocument document, MultiTextEdit root, int line) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        String lineDelimiter = document.getLineDelimiter(line);
        if (lineDelimiter != null) {
            ReplaceEdit edit = new ReplaceEdit(region.getOffset() + region.getLength(), lineDelimiter.length(), this.fLineDelimiter);
            root.addChild((TextEdit)edit);
            root.apply(document, 2);
            root.removeChild((TextEdit)edit);
        }
    }

    private static void trimBegin(TemplateBuffer templateBuffer) throws BadLocationException {
        String string = templateBuffer.getString();
        TemplateVariable[] variables = templateBuffer.getVariables();
        List positions = CFormatter.variablesToPositions(variables);
        int i = 0;
        while (i != string.length() && Character.isWhitespace(string.charAt(i))) {
            ++i;
        }
        string = CFormatter.edit(string, positions, (TextEdit)new DeleteEdit(0, i));
        CFormatter.positionsToVariables(positions, variables);
        templateBuffer.setContent(string, variables);
    }

    private static String edit(String string, List positions, TextEdit edit) throws BadLocationException {
        MultiTextEdit root = new MultiTextEdit(0, string.length());
        root.addChildren(positions.toArray(new TextEdit[positions.size()]));
        root.addChild(edit);
        Document document = new Document(string);
        root.apply((IDocument)document);
        return document.get();
    }

    private static String createIndentString(int displayedWidth, int tabWidth, boolean useSpaces) {
        return CFormatter.appendIndentString(new StringBuffer(displayedWidth), displayedWidth, tabWidth, useSpaces, 0).toString();
    }

    private static StringBuffer appendIndentString(StringBuffer buffer, int displayedWidth, int tabWidth, boolean useSpaces, int startColumn) {
        int tabStop = startColumn - startColumn % tabWidth;
        int tabs = useSpaces ? 0 : (displayedWidth - tabStop) / tabWidth;
        int i = 0;
        while (i < tabs) {
            buffer.append('\t');
            startColumn = tabStop += tabWidth;
            ++i;
        }
        int spaces = displayedWidth - startColumn;
        int i2 = 0;
        while (i2 < spaces) {
            buffer.append(' ');
            ++i2;
        }
        return buffer;
    }

    private static List variablesToPositions(TemplateVariable[] variables) {
        ArrayList<RangeMarker> positions = new ArrayList<RangeMarker>(5);
        int i = 0;
        while (i != variables.length) {
            int[] offsets = variables[i].getOffsets();
            String value = variables[i].getDefaultValue();
            int wsStart = 0;
            while (wsStart < value.length() && Character.isWhitespace(value.charAt(wsStart)) && !Strings.isLineDelimiterChar(value.charAt(wsStart))) {
                ++wsStart;
            }
            variables[i].getValues()[0] = value.substring(wsStart);
            int j = 0;
            while (j != offsets.length) {
                int n = j;
                offsets[n] = offsets[n] + wsStart;
                positions.add(new RangeMarker(offsets[j], 0));
                ++j;
            }
            ++i;
        }
        return positions;
    }

    private static void positionsToVariables(List positions, TemplateVariable[] variables) {
        Iterator iterator = positions.iterator();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            int[] offsets = new int[variable.getOffsets().length];
            int j = 0;
            while (j != offsets.length) {
                offsets[j] = ((TextEdit)iterator.next()).getOffset();
                ++j;
            }
            variable.setOffsets(offsets);
            ++i;
        }
    }
}

