/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.compare;

import org.eclipse.cdt.internal.ui.text.CSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public class CMergeViewer
extends TextMergeViewer {
    private static final String TITLE = "CMergeViewer.title";
    private IPropertyChangeListener fPreferenceChangeListener;
    private IPreferenceStore fPreferenceStore = CUIPlugin.getDefault().getCombinedPreferenceStore();
    private boolean fUseSystemColors;
    private CSourceViewerConfiguration fSourceViewerConfiguration;

    public CMergeViewer(Composite parent, int styles, CompareConfiguration mp) {
        super(parent, styles, mp);
        if (this.fPreferenceStore != null) {
            this.fPreferenceChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    CMergeViewer.this.handlePropertyChange(event);
                }
            };
            this.fPreferenceStore.addPropertyChangeListener(this.fPreferenceChangeListener);
        }
        this.fUseSystemColors = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        if (!this.fUseSystemColors) {
            RGB bg = CMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background");
            this.setBackgroundColor(bg);
            RGB fg = CMergeViewer.createColor(this.fPreferenceStore, "c_default");
            this.setForegroundColor(fg);
        }
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.fPreferenceChangeListener != null) {
            this.fPreferenceStore.removePropertyChangeListener(this.fPreferenceChangeListener);
            this.fPreferenceChangeListener = null;
        }
        super.handleDispose(event);
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals("AbstractTextEditor.Color.Background")) {
            if (!this.fUseSystemColors) {
                RGB bg = CMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background");
                this.setBackgroundColor(bg);
            }
        } else if (key.equals("AbstractTextEditor.Color.Background.SystemDefault")) {
            this.fUseSystemColors = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
            if (this.fUseSystemColors) {
                this.setBackgroundColor(null);
                this.setForegroundColor(null);
            } else {
                RGB bg = CMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background");
                this.setBackgroundColor(bg);
                RGB fg = CMergeViewer.createColor(this.fPreferenceStore, "c_default");
                this.setForegroundColor(fg);
            }
        } else if (key.equals("c_default") && !this.fUseSystemColors) {
            RGB fg = CMergeViewer.createColor(this.fPreferenceStore, "c_default");
            this.setForegroundColor(fg);
        }
        if (this.getSourceViewerConfiguration().affectsBehavior(event)) {
            this.getSourceViewerConfiguration().adaptToPreferenceChange(event);
            this.invalidateTextPresentation();
        }
    }

    private static RGB createColor(IPreferenceStore store, String key) {
        if (!store.contains(key)) {
            return null;
        }
        if (store.isDefault(key)) {
            return PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key);
        }
        return PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
    }

    private CSourceViewerConfiguration getSourceViewerConfiguration() {
        if (this.fSourceViewerConfiguration == null) {
            CTextTools tools = CUIPlugin.getDefault().getTextTools();
            this.fSourceViewerConfiguration = new CSourceViewerConfiguration(tools, null){

                public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
                    return "__dftl_partitioning";
                }
            };
        }
        return this.fSourceViewerConfiguration;
    }

    public String getTitle() {
        return CUIPlugin.getResourceString(TITLE);
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return CUIPlugin.getDefault().getTextTools().createDocumentPartitioner();
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof SourceViewer) {
            ((SourceViewer)textViewer).configure((SourceViewerConfiguration)this.getSourceViewerConfiguration());
        }
    }
}

