/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.compare;

import java.util.Stack;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.ui.compare.CNode;
import org.eclipse.cdt.internal.ui.compare.SourceElementRequestorAdapter;
import org.eclipse.jface.text.IDocument;

public class CParseTreeBuilder
extends SourceElementRequestorAdapter {
    private Stack fStack = new Stack();
    private IDocument fDocument;

    public CParseTreeBuilder(CNode root, IDocument doc) {
        this.fDocument = doc;
        this.fStack.clear();
        this.fStack.push(root);
    }

    public void enterClassSpecifier(IASTClassSpecifier classSpecification) {
        String name = classSpecification.getName();
        int start = classSpecification.getStartingOffset();
        if (classSpecification.getClassKind().equals(ASTClassKind.CLASS)) {
            this.push(65, name, start);
        } else if (classSpecification.getClassKind().equals(ASTClassKind.STRUCT)) {
            this.push(67, name, start);
        } else if (classSpecification.getClassKind().equals(ASTClassKind.UNION)) {
            this.push(69, name, start);
        } else if (classSpecification.getClassKind().equals(ASTClassKind.ENUM)) {
            this.push(63, name, start);
        }
    }

    public void enterCompilationUnit(IASTCompilationUnit compilationUnit) {
        this.push(60, "Translation Unit", 0);
    }

    public void enterFunctionBody(IASTFunction function) {
        this.push(74, function.getName(), function.getStartingOffset());
    }

    public void enterInclusion(IASTInclusion inclusion) {
        this.push(75, inclusion.getName(), inclusion.getStartingOffset());
    }

    public void enterLinkageSpecification(IASTLinkageSpecification linkageSpec) {
        this.push(2048, linkageSpec.getLinkageString(), linkageSpec.getStartingOffset());
    }

    public void enterMethodBody(IASTMethod method) {
        this.push(70, method.getName(), method.getStartingOffset());
    }

    public void enterNamespaceDefinition(IASTNamespaceDefinition namespaceDefinition) {
        this.push(61, namespaceDefinition.getName(), namespaceDefinition.getStartingOffset());
    }

    public void enterTemplateDeclaration(IASTTemplateDeclaration declaration) {
        this.push(92, "export", declaration.getStartingOffset());
    }

    public void enterTemplateInstantiation(IASTTemplateInstantiation instantiation) {
        this.push(92, "template instantiation", instantiation.getStartingOffset());
    }

    public void enterTemplateSpecialization(IASTTemplateSpecialization specialization) {
        this.push(92, "template specialization", specialization.getStartingOffset());
    }

    public void exitClassSpecifier(IASTClassSpecifier classSpecification) {
        this.pop(classSpecification.getEndingOffset());
    }

    public void exitCompilationUnit(IASTCompilationUnit translationUnit) {
        this.pop(this.fDocument.getLength());
    }

    public void exitFunctionBody(IASTFunction function) {
        this.pop(function.getEndingOffset());
    }

    public void exitInclusion(IASTInclusion inclusion) {
        this.pop(inclusion.getEndingOffset());
    }

    public void exitLinkageSpecification(IASTLinkageSpecification linkageSpec) {
        this.pop(linkageSpec.getEndingOffset());
    }

    public void exitMethodBody(IASTMethod method) {
        this.pop(method.getEndingOffset());
    }

    public void exitNamespaceDefinition(IASTNamespaceDefinition namespaceDefinition) {
        this.pop(namespaceDefinition.getEndingOffset());
    }

    public void exitTemplateDeclaration(IASTTemplateDeclaration declaration) {
        this.pop(declaration.getEndingOffset());
    }

    public void exitTemplateExplicitInstantiation(IASTTemplateInstantiation instantiation) {
        this.pop(instantiation.getEndingOffset());
    }

    public void exitTemplateSpecialization(IASTTemplateSpecialization specialization) {
        this.pop(specialization.getEndingOffset());
    }

    public void acceptEnumerationSpecifier(IASTEnumerationSpecifier enumeration) {
        this.push(63, enumeration.getName(), enumeration.getStartingOffset());
        this.pop(enumeration.getEndingOffset());
    }

    public void acceptFunctionDeclaration(IASTFunction function) {
        this.push(73, function.getName(), function.getStartingOffset());
        this.pop(function.getEndingOffset());
    }

    public void acceptMacro(IASTMacro macro) {
        this.push(79, macro.getName(), macro.getStartingOffset());
        this.pop(macro.getEndingOffset());
    }

    public void acceptMethodDeclaration(IASTMethod method) {
        this.push(71, method.getName(), method.getStartingOffset());
        this.pop(method.getEndingOffset());
    }

    public boolean acceptProblem(IProblem problem) {
        return true;
    }

    public void acceptTypedefDeclaration(IASTTypedefDeclaration typedef) {
        this.push(80, typedef.getName(), typedef.getStartingOffset());
        this.pop(typedef.getEndingOffset());
    }

    public void acceptUsingDeclaration(IASTUsingDeclaration usageDeclaration) {
        this.push(62, usageDeclaration.usingTypeName(), usageDeclaration.getStartingOffset());
        this.pop(usageDeclaration.getEndingOffset());
    }

    public void acceptUsingDirective(IASTUsingDirective usageDirective) {
        this.push(62, usageDirective.getNamespaceName(), usageDirective.getStartingOffset());
        this.pop(usageDirective.getEndingOffset());
    }

    public void acceptVariable(IASTVariable variable) {
        this.push(76, variable.getName(), variable.getStartingOffset());
        this.pop(variable.getEndingOffset());
    }

    public void acceptField(IASTField field) {
        this.push(72, field.getName(), field.getStartingOffset());
        this.pop(field.getEndingOffset());
    }

    private CNode getCurrentContainer() {
        return (CNode)((Object)this.fStack.peek());
    }

    private void push(int type, String name, int declarationStart) {
        this.fStack.push(new CNode(this.getCurrentContainer(), type, name, declarationStart, 0));
    }

    private void pop(int declarationEnd) {
        CNode current = this.getCurrentContainer();
        if (current.getTypeCode() == 60) {
            current.setAppendPosition(declarationEnd + 1);
        } else {
            current.setAppendPosition(declarationEnd);
        }
        current.setLength(declarationEnd - current.getRange().getOffset() + 1);
        this.fStack.pop();
    }

    public class ParseError
    extends Error {
        private static final long serialVersionUID = 1L;
    }
}

