/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.cdt.internal.ui.cview.CViewActionGroup;
import org.eclipse.cdt.internal.ui.cview.CViewMoveAction;
import org.eclipse.cdt.internal.ui.cview.CViewRenameAction;
import org.eclipse.cdt.internal.ui.cview.CopyAction;
import org.eclipse.cdt.internal.ui.cview.PasteAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.TextActionHandler;

public class RefactorActionGroup
extends CViewActionGroup {
    private Clipboard clipboard;
    private CopyAction copyAction;
    private DeleteResourceAction deleteAction;
    private PasteAction pasteAction;
    private CViewRenameAction renameAction;
    private CViewMoveAction moveAction;
    private TextActionHandler textActionHandler;

    public RefactorActionGroup(CView cview) {
        super(cview);
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection celements = (IStructuredSelection)this.getContext().getSelection();
        IStructuredSelection selection = SelectionConverter.convertSelectionToResources((ISelection)celements);
        boolean anyResourceSelected = !selection.isEmpty() && SelectionConverter.allResourcesAreOfType(selection, 7);
        this.copyAction.selectionChanged(selection);
        menu.add((IAction)this.copyAction);
        this.pasteAction.selectionChanged(selection);
        menu.add((IAction)this.pasteAction);
        if (anyResourceSelected) {
            this.deleteAction.selectionChanged(selection);
            menu.add((IAction)this.deleteAction);
            this.moveAction.selectionChanged(selection);
            menu.add((IAction)this.moveAction);
            this.renameAction.selectionChanged(selection);
            menu.add((IAction)this.renameAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        this.textActionHandler = new TextActionHandler(actionBars);
        this.textActionHandler.setCopyAction((IAction)this.copyAction);
        this.textActionHandler.setPasteAction((IAction)this.pasteAction);
        this.textActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.renameAction.setTextActionHandler(this.textActionHandler);
        actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.moveAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            if (this.deleteAction.isEnabled()) {
                this.deleteAction.run();
            }
            event.doit = false;
        } else if (event.keyCode == 0x100000B && event.stateMask == 0) {
            if (this.renameAction.isEnabled()) {
                this.renameAction.run();
            }
            event.doit = false;
        }
    }

    protected void makeActions() {
        TreeViewer treeViewer = this.getCView().getViewer();
        Shell shell = this.getCView().getSite().getShell();
        this.clipboard = new Clipboard(shell.getDisplay());
        this.pasteAction = new PasteAction(shell, this.clipboard);
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.pasteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.pasteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE"));
        this.pasteAction.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE"));
        this.copyAction = new CopyAction(shell, this.clipboard, this.pasteAction);
        this.copyAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
        this.moveAction = new CViewMoveAction(shell, (StructuredViewer)treeViewer);
        this.renameAction = new CViewRenameAction(shell, treeViewer);
        this.deleteAction = new DeleteResourceAction(shell);
        this.deleteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public void updateActionBars() {
        IStructuredSelection celements = (IStructuredSelection)this.getContext().getSelection();
        IStructuredSelection selection = SelectionConverter.convertSelectionToResources((ISelection)celements);
        this.copyAction.selectionChanged(selection);
        this.pasteAction.selectionChanged(selection);
        this.deleteAction.selectionChanged(selection);
        this.moveAction.selectionChanged(selection);
        this.renameAction.selectionChanged(selection);
    }
}

